/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.jflex.editor;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import org.intellij.jflex.parser.JFlexLexer;
import org.intellij.jflex.parser.JFlexParserDefinition;
import org.intellij.jflex.psi.JFlexTypes;
import org.jetbrains.annotations.NotNull;

public class JFlexSyntaxHighlighterFactory
extends SyntaxHighlighterFactory {
    public static final TextAttributesKey ILLEGAL = TextAttributesKey.createTextAttributesKey((String)"FLEX_ILLEGAL", (TextAttributesKey)HighlighterColors.BAD_CHARACTER);
    public static final TextAttributesKey MACRO = TextAttributesKey.createTextAttributesKey((String)"FLEX_MACRO", (TextAttributesKey)DefaultLanguageHighlighterColors.INSTANCE_FIELD);
    public static final TextAttributesKey STATE = TextAttributesKey.createTextAttributesKey((String)"FLEX_STATE", (TextAttributesKey)DefaultLanguageHighlighterColors.CLASS_NAME);
    public static final TextAttributesKey CLASS = TextAttributesKey.createTextAttributesKey((String)"FLEX_CLASS");
    public static final TextAttributesKey PATTERN_OP = TextAttributesKey.createTextAttributesKey((String)"FLEX_PATTERN_OP", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey CLASS_OP = TextAttributesKey.createTextAttributesKey((String)"FLEX_CHAR_CLASS_OP", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey OP_RANGE = TextAttributesKey.createTextAttributesKey((String)"FLEX_OP_RANGE", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey COMMENT = TextAttributesKey.createTextAttributesKey((String)"FLEX_COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.LINE_COMMENT);
    public static final TextAttributesKey OPTION = TextAttributesKey.createTextAttributesKey((String)"FLEX_OPTION", (TextAttributesKey)DefaultLanguageHighlighterColors.LABEL);
    public static final TextAttributesKey RAW_CODE = TextAttributesKey.createTextAttributesKey((String)"FLEX_RAW_CODE", (TextAttributesKey)EditorColors.INJECTED_LANGUAGE_FRAGMENT);
    public static final TextAttributesKey SECT_DIV = TextAttributesKey.createTextAttributesKey((String)"FLEX_SECTION_DIV", (TextAttributesKey)DefaultLanguageHighlighterColors.LABEL);
    public static final TextAttributesKey STRING = TextAttributesKey.createTextAttributesKey((String)"FLEX_STRING", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
    public static final TextAttributesKey CHAR = TextAttributesKey.createTextAttributesKey((String)"FLEX_CHAR", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
    public static final TextAttributesKey CHAR_ESC = TextAttributesKey.createTextAttributesKey((String)"FLEX_CHAR_ESC", (TextAttributesKey)DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
    public static final TextAttributesKey NUMBER = TextAttributesKey.createTextAttributesKey((String)"FLEX_NUMBER", (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
    public static final TextAttributesKey CLASS_STD = TextAttributesKey.createTextAttributesKey((String)"FLEX_PREDEFINED_CLASS", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey DOT = TextAttributesKey.createTextAttributesKey((String)"FLEX_DOT", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey EOF = TextAttributesKey.createTextAttributesKey((String)"FLEX_SECTION_DIV", (TextAttributesKey)DefaultLanguageHighlighterColors.LABEL);
    public static final TextAttributesKey LOOKAHEAD = TextAttributesKey.createTextAttributesKey((String)"FLEX_LOOKAHEAD", (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
    public static final TextAttributesKey COMMA = TextAttributesKey.createTextAttributesKey((String)"FLEX_COMMA", (TextAttributesKey)DefaultLanguageHighlighterColors.COMMA);
    public static final TextAttributesKey OP_EQUAL = TextAttributesKey.createTextAttributesKey((String)"FLEX_OP_EQUAL", (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
    public static final TextAttributesKey PARENS = TextAttributesKey.createTextAttributesKey((String)"FLEX_PARENS", (TextAttributesKey)DefaultLanguageHighlighterColors.PARENTHESES);
    public static final TextAttributesKey BRACES = TextAttributesKey.createTextAttributesKey((String)"FLEX_BRACES", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACES);
    public static final TextAttributesKey BRACKETS = TextAttributesKey.createTextAttributesKey((String)"FLEX_BRACKETS", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACKETS);
    public static final TextAttributesKey ANGLES = TextAttributesKey.createTextAttributesKey((String)"FLEX_ANGLES", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACKETS);

    @NotNull
    public SyntaxHighlighter getSyntaxHighlighter(Project project, VirtualFile virtualFile) {
        return new JFlexSyntaxHighlighter();
    }

    private static class JFlexSyntaxHighlighter
    extends SyntaxHighlighterBase {
        private JFlexSyntaxHighlighter() {
        }

        @NotNull
        public Lexer getHighlightingLexer() {
            return new JFlexLexer();
        }

        @NotNull
        public @NotNull TextAttributesKey @NotNull [] getTokenHighlights(IElementType o) {
            if (o == JFlexTypes.FLEX_LINE_COMMENT || o == JFlexTypes.FLEX_BLOCK_COMMENT) {
                return JFlexSyntaxHighlighter.pack((TextAttributesKey)COMMENT);
            }
            if (o == JFlexTypes.FLEX_RAW) {
                return JFlexSyntaxHighlighter.pack((TextAttributesKey)RAW_CODE);
            }
            if (o == JFlexTypes.FLEX_TWO_PERCS) {
                return JFlexSyntaxHighlighter.pack((TextAttributesKey)SECT_DIV);
            }
            if (o == JFlexTypes.FLEX_STRING) {
                return JFlexSyntaxHighlighter.pack((TextAttributesKey)STRING);
            }
            if (o == JFlexTypes.FLEX_CHAR) {
                return JFlexSyntaxHighlighter.pack((TextAttributesKey)CHAR);
            }
            if (o == JFlexTypes.FLEX_CHAR_ESC) {
                return JFlexSyntaxHighlighter.pack((TextAttributesKey)CHAR_ESC);
            }
            if (o == JFlexTypes.FLEX_NUMBER || o == JFlexTypes.FLEX_VERSION) {
                return JFlexSyntaxHighlighter.pack((TextAttributesKey)NUMBER);
            }
            if (o == JFlexTypes.FLEX_CHAR_CLASS) {
                return JFlexSyntaxHighlighter.pack((TextAttributesKey)CLASS_STD);
            }
            if (o == JFlexTypes.FLEX_EOF) {
                return JFlexSyntaxHighlighter.pack((TextAttributesKey)EOF);
            }
            if (o == JFlexTypes.FLEX_FSLASH) {
                return JFlexSyntaxHighlighter.pack((TextAttributesKey)LOOKAHEAD);
            }
            if (o == JFlexTypes.FLEX_COMMA) {
                return JFlexSyntaxHighlighter.pack((TextAttributesKey)COMMA);
            }
            if (o == JFlexTypes.FLEX_DOT) {
                return JFlexSyntaxHighlighter.pack((TextAttributesKey)DOT);
            }
            if (o == JFlexTypes.FLEX_EQ) {
                return JFlexSyntaxHighlighter.pack((TextAttributesKey)OP_EQUAL);
            }
            if (o == JFlexTypes.FLEX_DASH) {
                return JFlexSyntaxHighlighter.pack((TextAttributesKey)OP_RANGE);
            }
            if (o == JFlexTypes.FLEX_PAREN1 || o == JFlexTypes.FLEX_PAREN2) {
                return JFlexSyntaxHighlighter.pack((TextAttributesKey)PARENS);
            }
            if (o == JFlexTypes.FLEX_BRACE1 || o == JFlexTypes.FLEX_BRACE2) {
                return JFlexSyntaxHighlighter.pack((TextAttributesKey)BRACES);
            }
            if (o == JFlexTypes.FLEX_BRACK1 || o == JFlexTypes.FLEX_BRACK2) {
                return JFlexSyntaxHighlighter.pack((TextAttributesKey)BRACKETS);
            }
            if (o == JFlexTypes.FLEX_ANGLE1 || o == JFlexTypes.FLEX_ANGLE2) {
                return JFlexSyntaxHighlighter.pack((TextAttributesKey)ANGLES);
            }
            if (JFlexParserDefinition.PATTERN_OPERATORS.contains(o)) {
                return JFlexSyntaxHighlighter.pack((TextAttributesKey)PATTERN_OP);
            }
            if (JFlexParserDefinition.CHAR_CLASS_OPERATORS.contains(o)) {
                return JFlexSyntaxHighlighter.pack((TextAttributesKey)CLASS_OP);
            }
            if (o == JFlexTypes.FLEX_UNCLOSED || o == TokenType.BAD_CHARACTER) {
                return JFlexSyntaxHighlighter.pack((TextAttributesKey)ILLEGAL);
            }
            if (o.toString().startsWith("%")) {
                return JFlexSyntaxHighlighter.pack((TextAttributesKey)OPTION);
            }
            return TextAttributesKey.EMPTY_ARRAY;
        }
    }
}

