/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.jflex.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.intellij.jflex.JFlexLanguage;
import org.intellij.jflex.parser.JFlexLexer;
import org.intellij.jflex.parser.JFlexParser;
import org.intellij.jflex.psi.JFlexTokenType;
import org.intellij.jflex.psi.JFlexTypes;
import org.intellij.jflex.psi.impl.JFlexFileImpl;
import org.jetbrains.annotations.NotNull;

public class JFlexParserDefinition
implements ParserDefinition {
    public static final IFileElementType FILE_NODE_TYPE = new IFileElementType("JFLEX_FILE", (Language)JFlexLanguage.INSTANCE);
    public static final IElementType FLEX_NEWLINE = new JFlexTokenType("newline");
    public static final TokenSet WS = TokenSet.create((IElementType[])new IElementType[]{TokenType.WHITE_SPACE, FLEX_NEWLINE});
    public static final TokenSet COMMENTS = TokenSet.create((IElementType[])new IElementType[]{JFlexTypes.FLEX_LINE_COMMENT, JFlexTypes.FLEX_BLOCK_COMMENT});
    public static final TokenSet LITERALS = TokenSet.create((IElementType[])new IElementType[]{JFlexTypes.FLEX_STRING});
    public static final TokenSet CHAR_CLASS_OPERATORS = TokenSet.create((IElementType[])new IElementType[]{JFlexTypes.FLEX_AMPAMP, JFlexTypes.FLEX_BARBAR, JFlexTypes.FLEX_DASHDASH, JFlexTypes.FLEX_HAT, JFlexTypes.FLEX_TILDETILDE});
    public static final TokenSet PATTERN_OPERATORS = TokenSet.create((IElementType[])new IElementType[]{JFlexTypes.FLEX_BAR, JFlexTypes.FLEX_BANG, JFlexTypes.FLEX_DOLLAR, JFlexTypes.FLEX_PLUS, JFlexTypes.FLEX_QUESTION, JFlexTypes.FLEX_STAR, JFlexTypes.FLEX_TILDE});

    @NotNull
    public Lexer createLexer(Project project) {
        return new JFlexLexer();
    }

    @NotNull
    public PsiParser createParser(Project project) {
        return new JFlexParser();
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        return FILE_NODE_TYPE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        return WS;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        return COMMENTS;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        return LITERALS;
    }

    @NotNull
    public PsiElement createElement(ASTNode astNode) {
        throw new UnsupportedOperationException(astNode.getElementType().toString());
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider fileViewProvider) {
        return new JFlexFileImpl(fileViewProvider);
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode astNode, ASTNode astNode1) {
        return ParserDefinition.SpaceRequirements.MAY;
    }
}

