/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.jflex.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.SyntaxTraverser;
import org.intellij.jflex.JFlexLanguage;
import org.intellij.jflex.psi.JFlexJavaCode;
import org.intellij.jflex.psi.JFlexJavaType;
import org.intellij.jflex.psi.JFlexMacroDefinition;
import org.intellij.jflex.psi.impl.JFlexPsiImplUtil;
import org.jetbrains.annotations.NotNull;

public class JFlexPsiElementFactory {
    private static PsiFile createFile(@NotNull Project project, @NotNull String text) {
        return PsiFileFactory.getInstance((Project)project).createFileFromText("a.flex", (Language)JFlexLanguage.INSTANCE, (CharSequence)text, false, false);
    }

    public static PsiElement createIdFromText(@NotNull Project project, @NotNull String text) {
        return JFlexPsiImplUtil.computeDefinitions(JFlexPsiElementFactory.createFile(project, "%%\n" + text + "="), JFlexMacroDefinition.class).get(0).getId();
    }

    public static PsiElement createJavaCodeFromText(@NotNull Project project, @NotNull String text) {
        return (PsiElement)SyntaxTraverser.psiTraverser((PsiElement)JFlexPsiElementFactory.createFile(project, text)).filter(JFlexJavaCode.class).first();
    }

    public static PsiElement createJavaTypeFromText(@NotNull Project project, @NotNull String text) {
        return (PsiElement)SyntaxTraverser.psiTraverser((PsiElement)JFlexPsiElementFactory.createFile(project, "%%\n%extends " + text)).filter(JFlexJavaType.class).first();
    }
}

