/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.jflex.psi.impl;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.JBIterable;
import org.intellij.jflex.psi.JFlexDeclarationsSection;
import org.intellij.jflex.psi.JFlexJavaCode;
import org.intellij.jflex.psi.JFlexStateDefinition;
import org.jetbrains.annotations.NotNull;

public class JFlexStateUsageSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters>
implements DumbAware {
    protected JFlexStateUsageSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        PsiElement element = queryParameters.getElementToSearch();
        PsiFile containingFile = element.getContainingFile();
        if (element instanceof PsiField) {
            PsiElement context;
            PsiElement psiElement = context = containingFile == null ? null : containingFile.getContext();
            if (!(context instanceof JFlexJavaCode)) {
                return;
            }
            String name = ((PsiField)element).getName();
            PsiFile file = context.getContainingFile();
            JFlexStateDefinition state = (JFlexStateDefinition)SyntaxTraverser.psiTraverser((PsiElement)PsiTreeUtil.findChildOfType((PsiElement)file, JFlexDeclarationsSection.class)).filter(JFlexStateDefinition.class).filter(o -> name.equals(o.getName())).first();
            if (state != null) {
                SearchScope scope = queryParameters.getEffectiveSearchScope().intersectWith((SearchScope)new LocalSearchScope((PsiElement)file));
                queryParameters.getOptimizer().searchWord(state.getName(), scope, true, (PsiElement)state);
            }
        } else if (element instanceof JFlexStateDefinition) {
            PsiJavaFile javaFile;
            PsiField field;
            JFlexStateDefinition state = (JFlexStateDefinition)element;
            String name = state.getName();
            JFlexJavaCode javaCode = (JFlexJavaCode)SyntaxTraverser.psiTraverser((PsiElement)containingFile).filter(JFlexJavaCode.class).first();
            if (javaCode == null) {
                return;
            }
            Pair injectedFile = (Pair)JBIterable.from((Iterable)InjectedLanguageManager.getInstance((Project)javaCode.getProject()).getInjectedPsiFiles((PsiElement)javaCode)).first();
            if (injectedFile != null && injectedFile.first instanceof PsiJavaFile && (field = (PsiField)JBIterable.of((Object[])(javaFile = (PsiJavaFile)injectedFile.first).getClasses()).take(1).flatMap(o -> JBIterable.of((Object[])o.getFields())).find(o -> name.equals(o.getName()))) != null) {
                SearchScope scope = queryParameters.getEffectiveSearchScope().intersectWith((SearchScope)new LocalSearchScope((PsiElement)javaFile));
                queryParameters.getOptimizer().searchWord(name, scope, true, (PsiElement)field);
            }
        }
    }
}

