/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.FileMapData;
import com.intellij.rt.coverage.data.LineMapData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.JSR45Util;
import com.intellij.rt.coverage.instrumentation.filters.FilterUtils;
import com.intellij.rt.coverage.instrumentation.filters.classFilter.PrivateConstructorOfUtilClassFilter;
import com.intellij.rt.coverage.util.ClassNameUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.coverage.gnu.trove.TIntObjectHashMap;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceLineCounter
extends ClassVisitor {
    private final boolean myExcludeLines;
    private final ClassData myClassData;
    private final ProjectData myProjectData;
    private final TIntObjectHashMap<String> myNSourceLines = new TIntObjectHashMap();
    private final Set<String> myMethodsWithSourceCode = new HashSet<String>();
    private int myTotalBranches = 0;
    private int myCurrentLine;
    private boolean myInterface;
    private boolean myEnum;
    private String myClassName;
    private FileMapData[] myFileMapData;

    public SourceLineCounter(ClassData classData, boolean excludeLines, ProjectData projectData) {
        this(classData, excludeLines, projectData, FilterUtils.ignorePrivateConstructorOfUtilClassEnabled());
    }

    public SourceLineCounter(ClassData classData, boolean excludeLines, ProjectData projectData, boolean ignorePrivateConstructorOfUtilClasses) {
        super(589824);
        ClassVisitor classVisitor = new ClassVisitor(589824){};
        if (ignorePrivateConstructorOfUtilClasses) {
            classVisitor = new PrivateConstructorOfUtilClassFilter(classVisitor){

                protected void removeLine(int line) {
                    String methodSignature = (String)SourceLineCounter.this.myNSourceLines.remove(line);
                    if (methodSignature != null) {
                        SourceLineCounter.this.myMethodsWithSourceCode.remove(methodSignature);
                    }
                }
            };
        }
        this.cv = classVisitor;
        this.myProjectData = projectData;
        this.myClassData = classData;
        this.myExcludeLines = excludeLines;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.myInterface = (access & 0x200) != 0;
        this.myEnum = (access & 0x4000) != 0;
        this.myClassName = ClassNameUtil.convertToFQName(name);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public void visitSource(String sourceFileName, String debug) {
        if (this.shouldCalculateSource()) {
            this.myClassData.setSource(sourceFileName);
        }
        if (debug != null && this.myClassName != null) {
            this.myFileMapData = JSR45Util.extractLineMapping(debug, this.myClassName);
        }
        super.visitSource(sourceFileName, debug);
    }

    @Override
    public void visitOuterClass(String outerClassName, String methodName, String methodSig) {
        String fqnName;
        ClassData outerClass;
        if (this.shouldCalculateSource() && (outerClass = this.myProjectData.getOrCreateClassData(fqnName = ClassNameUtil.convertToFQName(outerClassName))).getSource() == null) {
            outerClass.setSource(this.myClassData.getSource());
        }
        super.visitOuterClass(outerClassName, methodName, methodSig);
    }

    @Override
    public MethodVisitor visitMethod(int access, final String name, final String desc, String signature, String[] exceptions) {
        MethodVisitor v = this.cv.visitMethod(access, name, desc, signature, exceptions);
        if (this.myInterface) {
            return v;
        }
        if ((access & 0x40) != 0) {
            return v;
        }
        if (this.myEnum) {
            if (name.equals("values") && desc.startsWith("()[L")) {
                return v;
            }
            if (name.equals("valueOf") && desc.startsWith("(Ljava/lang/String;)L")) {
                return v;
            }
            if (name.equals("<init>") && signature != null && signature.equals("()V")) {
                return v;
            }
        }
        return new MethodVisitor(589824, v){
            private boolean myHasInstructions;

            public void visitLineNumber(int line, Label start) {
                super.visitLineNumber(line, start);
                this.myHasInstructions = false;
                SourceLineCounter.this.myCurrentLine = line;
                if (!SourceLineCounter.this.myExcludeLines || SourceLineCounter.this.myClassData == null || SourceLineCounter.this.myClassData.getStatus(name + desc) != null || !name.equals("<init>") && !name.equals("<clinit>")) {
                    SourceLineCounter.this.myNSourceLines.put(line, name + desc);
                    SourceLineCounter.this.myMethodsWithSourceCode.add(name + desc);
                }
            }

            public void visitInsn(int opcode) {
                super.visitInsn(opcode);
                if (opcode == 177 && !this.myHasInstructions) {
                    SourceLineCounter.this.myNSourceLines.remove(SourceLineCounter.this.myCurrentLine);
                } else {
                    this.myHasInstructions = true;
                }
            }

            public void visitIntInsn(int opcode, int operand) {
                super.visitIntInsn(opcode, operand);
                this.myHasInstructions = true;
            }

            public void visitVarInsn(int opcode, int var) {
                super.visitVarInsn(opcode, var);
                this.myHasInstructions = true;
            }

            public void visitTypeInsn(int opcode, String type) {
                super.visitTypeInsn(opcode, type);
                this.myHasInstructions = true;
            }

            public void visitFieldInsn(int opcode, String owner, String name2, String desc2) {
                super.visitFieldInsn(opcode, owner, name2, desc2);
                this.myHasInstructions = true;
            }

            public void visitMethodInsn(int opcode, String owner, String name2, String desc2, boolean itf) {
                super.visitMethodInsn(opcode, owner, name2, desc2, itf);
                this.myHasInstructions = true;
            }

            public void visitJumpInsn(int opcode, Label label) {
                super.visitJumpInsn(opcode, label);
                this.myHasInstructions = true;
                if (opcode != 167 && opcode != 168) {
                    SourceLineCounter.this.myTotalBranches++;
                }
            }

            public void visitLdcInsn(Object cst) {
                super.visitLdcInsn(cst);
                this.myHasInstructions = true;
            }

            public void visitIincInsn(int var, int increment) {
                super.visitIincInsn(var, increment);
                this.myHasInstructions = true;
            }

            public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
                super.visitTableSwitchInsn(min, max, dflt, labels);
                this.myHasInstructions = true;
                SourceLineCounter.this.myTotalBranches++;
            }

            public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
                super.visitLookupSwitchInsn(dflt, keys, labels);
                this.myHasInstructions = true;
                SourceLineCounter.this.myTotalBranches++;
            }

            public void visitMultiANewArrayInsn(String desc2, int dims) {
                super.visitMultiANewArrayInsn(desc2, dims);
                this.myHasInstructions = true;
            }

            public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
                super.visitTryCatchBlock(start, end, handler, type);
                this.myHasInstructions = true;
            }
        };
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        this.applyMappings();
    }

    public int getNSourceLines() {
        return this.myNSourceLines.size();
    }

    public TIntObjectHashMap<String> getSourceLines() {
        return this.myNSourceLines;
    }

    public Set<String> getMethodsWithSourceCode() {
        return this.myMethodsWithSourceCode;
    }

    public int getNMethodsWithCode() {
        return this.myMethodsWithSourceCode.size();
    }

    public boolean isInterface() {
        return this.myInterface;
    }

    public boolean isEnum() {
        return this.myEnum;
    }

    public int getTotalBranches() {
        return this.myTotalBranches;
    }

    private boolean shouldCalculateSource() {
        return this.myProjectData != null;
    }

    private void applyMappings() {
        if (this.myFileMapData == null || this.myClassName == null) {
            return;
        }
        for (FileMapData mapData : this.myFileMapData) {
            boolean isThisClass = this.myClassName.equals(mapData.getClassName());
            for (LineMapData lineMapData : mapData.getLines()) {
                for (int i = lineMapData.getTargetMinLine(); i <= lineMapData.getTargetMaxLine(); ++i) {
                    String signature = this.myNSourceLines.remove(i);
                    if (signature == null) continue;
                    int sourceLine = lineMapData.getSourceLineNumber();
                    if (!isThisClass || this.myNSourceLines.containsKey(sourceLine)) continue;
                    this.myNSourceLines.put(sourceLine, signature);
                }
            }
        }
    }
}

