/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters;

import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.kotlin.KotlinUtils;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Type;

public abstract class KotlinCoroutinesFilter
extends MethodVisitor {
    private boolean myGetCoroutinesSuspendedVisited = false;
    private boolean myStoreCoroutinesSuspendedVisited = false;
    private boolean myLoadCoroutinesSuspendedVisited = false;
    private boolean myLoadStateLabelVisited = false;
    private boolean myStoreStateLabelVisited = false;
    private boolean mySuspendCallVisited = false;
    private int myCoroutinesSuspendedIndex = -1;
    private int myLine = -1;
    private boolean myHadLineDataBefore = false;
    private final Instrumenter myContext;

    public KotlinCoroutinesFilter(MethodVisitor methodVisitor, Instrumenter instrumenter) {
        super(589824, methodVisitor);
        this.myContext = instrumenter;
    }

    protected abstract void onIgnoredJump();

    protected abstract void onIgnoredSwitch(Label var1, Label ... var2);

    protected void onIgnoredLine(int line) {
        this.myContext.removeLine(line);
    }

    public static boolean isApplicable(Instrumenter context, String name, String desc) {
        return KotlinUtils.isKotlinClass(context) && (name.equals("invokeSuspend") || desc.endsWith("Lkotlin/coroutines/Continuation;)Ljava/lang/Object;"));
    }

    public void visitLineNumber(int line, Label start) {
        this.myHadLineDataBefore = this.myContext.getLineData(line) != null;
        super.visitLineNumber(line, start);
        this.myLine = line;
    }

    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        boolean suspendCallVisited;
        super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        boolean getCoroutinesSuspendedVisited = opcode == 184 && owner.equals("kotlin/coroutines/intrinsics/IntrinsicsKt") && name.equals("getCOROUTINE_SUSPENDED") && descriptor.equals("()Ljava/lang/Object;");
        boolean bl = suspendCallVisited = descriptor.endsWith("Lkotlin/coroutines/Continuation;)Ljava/lang/Object;") || owner.startsWith("kotlin/jvm/functions/Function") && this.myStoreStateLabelVisited && name.equals("invoke") && opcode == 185;
        if (getCoroutinesSuspendedVisited || suspendCallVisited) {
            this.myGetCoroutinesSuspendedVisited |= getCoroutinesSuspendedVisited;
            this.mySuspendCallVisited |= suspendCallVisited;
        } else {
            this.myGetCoroutinesSuspendedVisited = false;
            this.mySuspendCallVisited = false;
        }
    }

    public void visitVarInsn(int opcode, int var) {
        super.visitVarInsn(opcode, var);
        if (!this.myStoreCoroutinesSuspendedVisited && this.myGetCoroutinesSuspendedVisited && opcode == 58) {
            this.myStoreCoroutinesSuspendedVisited = true;
            this.myCoroutinesSuspendedIndex = var;
        }
        this.myLoadCoroutinesSuspendedVisited = this.myStoreCoroutinesSuspendedVisited && opcode == 25 && var == this.myCoroutinesSuspendedIndex;
    }

    public void visitJumpInsn(int opcode, Label label) {
        boolean compareWithCoroutinesSuspend;
        super.visitJumpInsn(opcode, label);
        boolean bl = compareWithCoroutinesSuspend = this.myLoadCoroutinesSuspendedVisited || this.myGetCoroutinesSuspendedVisited;
        if (compareWithCoroutinesSuspend && this.mySuspendCallVisited && opcode == 166) {
            this.onIgnoredJump();
            this.mySuspendCallVisited = false;
        }
        this.myLoadCoroutinesSuspendedVisited = false;
    }

    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        super.visitFieldInsn(opcode, owner, name, descriptor);
        boolean labelVisited = name.equals("label") && descriptor.equals("I") && Type.getObjectType(owner).getClassName().startsWith(this.myContext.getClassName());
        this.myLoadStateLabelVisited = labelVisited && opcode == 180;
        this.myStoreStateLabelVisited = labelVisited && opcode == 181;
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        super.visitTableSwitchInsn(min, max, dflt, labels);
        if (this.myLoadStateLabelVisited) {
            this.onIgnoredSwitch(dflt, labels);
            if (!this.myHadLineDataBefore) {
                this.onIgnoredLine(this.myLine);
            }
        }
        this.myLoadStateLabelVisited = false;
    }

    public void visitInsn(int opcode) {
        super.visitInsn(opcode);
        if (opcode == 176 && this.myLoadCoroutinesSuspendedVisited && !this.myHadLineDataBefore) {
            this.onIgnoredLine(this.myLine);
        }
    }
}

