/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.kotlin;

import com.intellij.rt.coverage.instrumentation.MethodFilteringVisitor;
import com.intellij.rt.coverage.instrumentation.filters.enumerating.KotlinCoroutinesEnumeratingFilter;
import com.intellij.rt.coverage.instrumentation.filters.enumerating.KotlinDefaultArgsBranchFilter;
import com.intellij.rt.coverage.instrumentation.filters.enumerating.KotlinWhenMappingExceptionFilter;
import com.intellij.rt.coverage.instrumentation.filters.enumerating.LineEnumeratorFilter;
import com.intellij.rt.coverage.instrumentation.filters.signature.KotlinSyntheticAccessMethodFilter;
import com.intellij.rt.coverage.instrumentation.filters.signature.KotlinSyntheticConstructorOfSealedClassFilter;
import com.intellij.rt.coverage.instrumentation.filters.signature.MethodSignatureFilter;
import com.intellij.rt.coverage.instrumentation.filters.visiting.KotlinCoroutinesVisitingFilter;
import com.intellij.rt.coverage.instrumentation.filters.visiting.KotlinImplementerDefaultInterfaceMemberFilter;
import com.intellij.rt.coverage.instrumentation.filters.visiting.KotlinInlineVisitingFilter;
import com.intellij.rt.coverage.instrumentation.filters.visiting.MethodVisitingFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KotlinUtils {
    private static final String KOTLIN_CLASS_LABEL = "IS_KOTLIN";
    public static final String KOTLIN_METADATA = "Lkotlin/Metadata;";
    private static final boolean ourKotlinEnabled = !"false".equals(System.getProperty("coverage.kotlin.enable", "true"));

    public static boolean isKotlinClass(MethodFilteringVisitor context) {
        Object currentProperty = context.getProperty(KOTLIN_CLASS_LABEL);
        if (currentProperty instanceof Boolean) {
            return (Boolean)currentProperty;
        }
        boolean isKotlin = context.getAnnotations().contains(KOTLIN_METADATA);
        context.addProperty(KOTLIN_CLASS_LABEL, isKotlin);
        return isKotlin;
    }

    public static List<MethodSignatureFilter> createSignatureFilters() {
        if (!ourKotlinEnabled) {
            return Collections.emptyList();
        }
        ArrayList<MethodSignatureFilter> result = new ArrayList<MethodSignatureFilter>();
        result.add(new KotlinSyntheticConstructorOfSealedClassFilter());
        result.add(new KotlinSyntheticAccessMethodFilter());
        return result;
    }

    public static List<MethodVisitingFilter> createVisitingFilters() {
        if (!ourKotlinEnabled) {
            return Collections.emptyList();
        }
        ArrayList<MethodVisitingFilter> result = new ArrayList<MethodVisitingFilter>();
        result.add(new KotlinImplementerDefaultInterfaceMemberFilter());
        result.add(new KotlinCoroutinesVisitingFilter());
        result.add(new KotlinInlineVisitingFilter());
        return result;
    }

    public static List<LineEnumeratorFilter> createLineEnumeratorFilters() {
        if (!ourKotlinEnabled) {
            return Collections.emptyList();
        }
        ArrayList<LineEnumeratorFilter> result = new ArrayList<LineEnumeratorFilter>();
        result.add(new KotlinWhenMappingExceptionFilter());
        result.add(new KotlinDefaultArgsBranchFilter());
        result.add(new KotlinCoroutinesEnumeratingFilter());
        return result;
    }
}

