/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util.classFinder;

import com.intellij.rt.coverage.util.ErrorReporter;
import com.intellij.rt.coverage.util.classFinder.ClassEntry;
import com.intellij.rt.coverage.util.classFinder.ClassPathEntry;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFinder {
    private final List<Pattern> myIncludePatterns;
    private final List<Pattern> myExcludePatterns;
    private final Set<ClassLoader> myClassloaders;

    public ClassFinder(List<Pattern> includePatterns, List<Pattern> excludePatterns) {
        this.myIncludePatterns = includePatterns;
        this.myExcludePatterns = excludePatterns;
        this.myClassloaders = new HashSet<ClassLoader>();
    }

    public void addClassLoader(ClassLoader cl) {
        if (cl != null) {
            if (cl.getClass().getName().equals("jetbrains.buildServer.agent.AgentClassLoader")) {
                return;
            }
            if (cl instanceof URLClassLoader) {
                this.myClassloaders.add(cl);
            }
            if (cl.getParent() != null) {
                this.addClassLoader(cl.getParent());
            }
        }
    }

    public Collection<ClassEntry> findMatchedClasses() {
        HashSet<ClassEntry> classes = new HashSet<ClassEntry>();
        for (ClassPathEntry entry : this.getClassPathEntries()) {
            try {
                classes.addAll(entry.getClassesIterator(this.myIncludePatterns, this.myExcludePatterns));
            }
            catch (IOException e) {
                ErrorReporter.reportError("Error during iterating classes.", e);
            }
        }
        return classes;
    }

    protected Collection<ClassPathEntry> getClassPathEntries() {
        HashSet<ClassPathEntry> result = new HashSet<ClassPathEntry>();
        result.addAll(ClassFinder.extractEntries(System.getProperty("java.class.path")));
        result.addAll(ClassFinder.extractEntries(System.getProperty("sun.boot.class.path")));
        this.collectClassloaderEntries(result);
        return result;
    }

    private void collectClassloaderEntries(Set<ClassPathEntry> result) {
        for (ClassLoader myClassloader : this.myClassloaders) {
            URLClassLoader cl = (URLClassLoader)myClassloader;
            try {
                URL[] urls;
                for (URL url : urls = cl.getURLs()) {
                    if (!"file".equals(url.getProtocol())) continue;
                    String path = this.fixPath(url.getPath());
                    result.add(new ClassPathEntry(path, cl));
                }
            }
            catch (Exception e) {
                ErrorReporter.reportError("Exception occurred on trying collect ClassPath URLs. One of possible reasons is shutting down Tomcat before finishing tests. Coverage won't be affected but some of uncovered classes could be missing from the report.", e);
            }
        }
    }

    private String fixPath(String path) {
        String result = path;
        try {
            result = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            ErrorReporter.reportError("Could not decode the path: " + path + ", error: " + e.getMessage(), e);
        }
        if (result.length() == 0) {
            return result;
        }
        if (result.charAt(0) == '/' && result.length() > 3 && result.charAt(2) == ':') {
            result = result.substring(1);
        }
        return result;
    }

    private static Collection<ClassPathEntry> extractEntries(String classPath) {
        if (classPath == null) {
            return Collections.emptyList();
        }
        String[] entries = classPath.split(System.getProperty("path.separator"));
        HashSet<ClassPathEntry> result = new HashSet<ClassPathEntry>();
        for (String entry : entries) {
            result.add(new ClassPathEntry(entry, null));
        }
        return result;
    }

    public Set<ClassLoader> getClassloaders() {
        return this.myClassloaders;
    }
}

