/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.data;

import com.intellij.rt.coverage.data.JumpData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.SwitchData;
import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.data.Jump;
import com.intellij.rt.coverage.instrumentation.data.Switch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.coverage.org.objectweb.asm.Label;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchDataContainer {
    private final Instrumenter myContext;
    private int myNextId = 0;
    private Label myLastFalseJump;
    private Label myLastTrueJump;
    private Map<Label, Jump> myJumps;
    private Map<Label, Switch> mySwitches;

    public BranchDataContainer(Instrumenter context) {
        this.myContext = context;
    }

    public int getSize() {
        return this.myNextId;
    }

    public void resetMethod() {
        this.myLastFalseJump = null;
        this.myLastTrueJump = null;
        if (this.myJumps != null) {
            this.myJumps.clear();
        }
        if (this.mySwitches != null) {
            this.mySwitches.clear();
        }
    }

    public Instrumenter getContext() {
        return this.myContext;
    }

    public Jump getJump(Label jump) {
        if (this.myJumps == null) {
            return null;
        }
        return this.myJumps.get(jump);
    }

    public Switch getSwitch(Label label) {
        if (this.mySwitches == null) {
            return null;
        }
        return this.mySwitches.get(label);
    }

    public void addLine(LineData lineData) {
        int id = lineData.getId();
        if (id == -1) {
            id = this.myNextId++;
            lineData.setId(id);
        }
    }

    public void addJump(LineData lineData, int index, Label trueLabel, Label falseLabel) {
        int line = lineData.getLineNumber();
        Jump trueJump = new Jump(this.myNextId++, index, line, false);
        Jump falseJump = new Jump(this.myNextId++, index, line, true);
        this.myLastTrueJump = trueLabel;
        this.myLastFalseJump = falseLabel;
        if (this.myJumps == null) {
            this.myJumps = new HashMap<Label, Jump>();
        }
        this.myJumps.put(falseLabel, falseJump);
        this.myJumps.put(trueLabel, trueJump);
        JumpData jumpData = lineData.addJump(index);
        jumpData.setId(trueJump.getId(), trueJump.getType());
        jumpData.setId(falseJump.getId(), falseJump.getType());
    }

    public void addLookupSwitch(LineData lineData, int index, Label dflt, int[] keys, Label[] labels) {
        List<Switch> switches = this.rememberSwitchLabels(lineData.getLineNumber(), dflt, labels, index);
        SwitchData switchData = lineData.addSwitch(index, keys);
        this.setSwitchIds(switchData, switches);
    }

    public void addTableSwitch(LineData lineData, int index, int min, int max, Label dflt, Label[] labels) {
        List<Switch> switches = this.rememberSwitchLabels(lineData.getLineNumber(), dflt, labels, index);
        SwitchData switchData = lineData.addSwitch(index, min, max);
        this.setSwitchIds(switchData, switches);
    }

    public void removeLastJump() {
        if (this.myLastTrueJump == null) {
            return;
        }
        this.myJumps.remove(this.myLastFalseJump);
        Jump trueJump = this.myJumps.remove(this.myLastTrueJump);
        this.myLastTrueJump = null;
        this.myLastFalseJump = null;
        if (trueJump == null) {
            return;
        }
        LineData lineData = this.myContext.getLineData(trueJump.getLine());
        if (lineData == null) {
            return;
        }
        lineData.removeJump(lineData.jumpsCount() - 1);
    }

    public void removeLastSwitch(Label dflt, Label ... labels) {
        if (this.mySwitches == null) {
            return;
        }
        Switch aSwitch = this.mySwitches.remove(dflt);
        for (Label label : labels) {
            this.mySwitches.remove(label);
        }
        if (aSwitch == null) {
            return;
        }
        LineData lineData = this.myContext.getLineData(aSwitch.getLine());
        if (lineData == null) {
            return;
        }
        lineData.removeSwitch(lineData.switchesCount() - 1);
    }

    private List<Switch> rememberSwitchLabels(int line, Label dflt, Label[] labels, int switchIndex) {
        ArrayList<Switch> result = new ArrayList<Switch>();
        if (this.mySwitches == null) {
            this.mySwitches = new HashMap<Label, Switch>();
        }
        Switch aSwitch = new Switch(this.myNextId++, switchIndex, line, -1);
        result.add(aSwitch);
        this.mySwitches.put(dflt, aSwitch);
        for (int i = labels.length - 1; i >= 0; --i) {
            aSwitch = new Switch(this.myNextId++, switchIndex, line, i);
            result.add(aSwitch);
            this.mySwitches.put(labels[i], aSwitch);
        }
        return result;
    }

    private void setSwitchIds(SwitchData data, List<Switch> switches) {
        for (Switch aSwitch : switches) {
            data.setId(aSwitch.getId(), aSwitch.getKey());
        }
    }
}

