/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.visiting;

import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.filters.visiting.KotlinInlineVisitingFilter;
import com.intellij.rt.coverage.instrumentation.filters.visiting.MethodVisitingFilter;
import org.jetbrains.coverage.gnu.trove.TIntHashSet;
import org.jetbrains.coverage.gnu.trove.TIntProcedure;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class ClosingBracesFilter
extends MethodVisitingFilter {
    private String myName;
    private boolean myHasInstructions;
    private boolean myHasLines;
    private int myCurrentLine;
    private boolean mySeenReturn;
    private TIntHashSet myLinesToIgnore;
    private boolean myInline;

    public void initFilter(MethodVisitor methodVisitor, Instrumenter context, String name, String desc) {
        super.initFilter(methodVisitor, context, name, desc);
        this.myName = name;
        this.myHasInstructions = false;
        this.myHasLines = false;
        this.myCurrentLine = -1;
        this.myLinesToIgnore = new TIntHashSet();
        this.myInline = false;
        this.mySeenReturn = false;
    }

    private void addEmptyLineToRemove() {
        if (this.myHasLines && !this.myHasInstructions) {
            if (this.mySeenReturn) {
                this.myLinesToIgnore.add(this.myCurrentLine);
            } else {
                this.myContext.removeLine(this.myCurrentLine);
            }
        }
    }

    public void visitLineNumber(int line, Label start) {
        this.addEmptyLineToRemove();
        if (this.myCurrentLine != line) {
            this.myHasInstructions = this.myContext.getLineData(line) != null & !this.myLinesToIgnore.remove(line);
            this.myHasLines = true;
            this.myCurrentLine = line;
            this.mySeenReturn = false;
        }
        super.visitLineNumber(line, start);
    }

    public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
        super.visitLocalVariable(name, descriptor, signature, start, end, index);
        this.myInline |= KotlinInlineVisitingFilter.isInlineMethod(this.myName, name);
    }

    public void visitEnd() {
        this.addEmptyLineToRemove();
        if (!this.myInline) {
            this.myLinesToIgnore.forEach(new TIntProcedure(){

                public boolean execute(int line) {
                    ClosingBracesFilter.this.myContext.removeLine(line);
                    return true;
                }
            });
        }
        super.visitEnd();
    }

    public void visitInsn(int opcode) {
        super.visitInsn(opcode);
        if (!this.myHasLines) {
            return;
        }
        if (172 <= opcode && opcode <= 177) {
            this.mySeenReturn = true;
            return;
        }
        if (opcode == 87) {
            return;
        }
        this.setHasInstructions();
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        super.visitTableSwitchInsn(min, max, dflt, labels);
        this.setHasInstructions();
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        super.visitLookupSwitchInsn(dflt, keys, labels);
        this.setHasInstructions();
    }

    public void visitJumpInsn(int opcode, Label label) {
        super.visitJumpInsn(opcode, label);
        this.setHasInstructions();
    }

    public void visitLdcInsn(Object value) {
        super.visitLdcInsn(value);
        this.setHasInstructions();
    }

    public void visitIincInsn(int var, int increment) {
        super.visitIincInsn(var, increment);
        this.setHasInstructions();
    }

    public void visitIntInsn(int opcode, int operand) {
        super.visitIntInsn(opcode, operand);
        this.setHasInstructions();
    }

    public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
        super.visitMultiANewArrayInsn(descriptor, numDimensions);
        this.setHasInstructions();
    }

    public void visitTypeInsn(int opcode, String type) {
        super.visitTypeInsn(opcode, type);
        this.setHasInstructions();
    }

    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        super.visitFieldInsn(opcode, owner, name, descriptor);
        if (opcode == 178 && owner.equals("kotlin/Unit") && name.equals("INSTANCE") && descriptor.equals("Lkotlin/Unit;")) {
            return;
        }
        this.setHasInstructions();
    }

    public void visitVarInsn(int opcode, int var) {
        super.visitVarInsn(opcode, var);
        this.setHasInstructions();
    }

    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        this.setHasInstructions();
    }

    private void setHasInstructions() {
        this.myHasInstructions |= !this.mySeenReturn && this.myHasLines;
    }

    public boolean isApplicable(Instrumenter context, int access, String name, String desc, String signature, String[] exceptions) {
        return true;
    }
}

