/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import com.intellij.rt.coverage.util.ErrorReporter;
import com.intellij.rt.coverage.util.ReportSection;
import com.intellij.rt.coverage.util.UncoveredBranchesSection;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.coverage.gnu.trove.TIntObjectHashMap;
import org.jetbrains.coverage.gnu.trove.TObjectIntHashMap;
import org.jetbrains.coverage.gnu.trove.TObjectProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportSectionsUtil {
    public static final int UNCOVERED_BRANCHES_SECTION_ID = 1;

    private static TIntObjectHashMap<ReportSection> getSections() {
        TIntObjectHashMap<ReportSection> result = new TIntObjectHashMap<ReportSection>();
        result.put(1, new UncoveredBranchesSection());
        return result;
    }

    public static void loadSections(ProjectData projectData, DataInputStream in, TIntObjectHashMap<ClassData> dict) throws IOException {
        int numberOfSections = CoverageIOUtil.readINT(in);
        TIntObjectHashMap<ReportSection> sections = ReportSectionsUtil.getSections();
        for (int i = 0; i < numberOfSections; ++i) {
            int sectionId = CoverageIOUtil.readINT(in);
            int size = CoverageIOUtil.readINT(in);
            int version = CoverageIOUtil.readINT(in);
            ReportSection section = sections.get(sectionId);
            if (section != null) {
                if (version <= section.getVersion()) {
                    section.load(projectData, in, dict, version);
                    continue;
                }
                ErrorReporter.reportError("Section version " + version + " is greater than agent maximum support version " + section.getVersion() + "\nPlease try to update coverage agent.");
            } else {
                ErrorReporter.reportError("Unknown section id " + sectionId + ". Please try to update coverage agent.");
            }
            in.skipBytes(size);
        }
    }

    public static void saveSections(ProjectData projectData, DataOutputStream out, TObjectIntHashMap<String> dict) throws IOException {
        List<ReportSection> sections = ReportSectionsUtil.getEngagedSections(projectData);
        CoverageIOUtil.writeINT(out, sections.size());
        for (ReportSection section : sections) {
            section.save(projectData, out, dict);
        }
    }

    private static List<ReportSection> getEngagedSections(final ProjectData projectData) {
        final ArrayList<ReportSection> engagedSections = new ArrayList<ReportSection>();
        ReportSectionsUtil.getSections().forEachValue(new TObjectProcedure<ReportSection>(){

            @Override
            public boolean execute(ReportSection section) {
                if (section.isEngaged(projectData)) {
                    engagedSections.add(section);
                }
                return true;
            }
        });
        return engagedSections;
    }
}

