/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import com.intellij.rt.coverage.util.ReportSection;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.coverage.gnu.trove.TIntObjectHashMap;
import org.jetbrains.coverage.gnu.trove.TObjectIntHashMap;
import org.jetbrains.coverage.gnu.trove.TObjectIntProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UncoveredBranchesSection
extends ReportSection {
    @Override
    public int getId() {
        return 1;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public boolean isEngaged(ProjectData projectData) {
        return !projectData.isSampling();
    }

    @Override
    public void load(ProjectData projectData, DataInputStream in, TIntObjectHashMap<ClassData> dict, int version) throws IOException {
        int classId = CoverageIOUtil.readINT(in);
        while (classId != -1) {
            ClassData classData = dict.get(classId);
            for (Object object : classData.getLines()) {
                LineData line = (LineData)object;
                if (line == null || line.getHits() > 0) continue;
                int jumpsNumber = CoverageIOUtil.readINT(in);
                for (int jumpId = 0; jumpId < jumpsNumber; ++jumpId) {
                    line.addJump(jumpId);
                }
                int switchesNumber = CoverageIOUtil.readINT(in);
                for (int switchId = 0; switchId < switchesNumber; ++switchId) {
                    int keysLength = CoverageIOUtil.readINT(in);
                    int[] keys = new int[keysLength];
                    for (int k = 0; k < keysLength; ++k) {
                        keys[k] = k;
                    }
                    line.addSwitch(switchId, keys);
                }
                line.fillArrays();
            }
            classId = CoverageIOUtil.readINT(in);
        }
    }

    @Override
    protected void saveInternal(final ProjectData projectData, final DataOutput out, TObjectIntHashMap<String> dict) throws IOException {
        try {
            dict.forEachEntry(new TObjectIntProcedure<String>(){

                @Override
                public boolean execute(String className, int index) {
                    try {
                        UncoveredBranchesSection.this.saveClass(projectData.getClassData(className), out, index);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    return true;
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
        CoverageIOUtil.writeINT(out, -1);
    }

    private void saveClass(ClassData classData, DataOutput out, int index) throws IOException {
        LineData lineData;
        int line;
        LineData[] lines = (LineData[])classData.getLines();
        if (lines == null) {
            return;
        }
        for (line = 0; line < lines.length && ((lineData = lines[line]) == null || lineData.getHits() != 0); ++line) {
        }
        if (line == lines.length) {
            return;
        }
        CoverageIOUtil.writeINT(out, index);
        while (line < lines.length) {
            lineData = lines[line];
            if (lineData != null && lineData.getHits() <= 0) {
                CoverageIOUtil.writeINT(out, lineData.jumpsCount());
                CoverageIOUtil.writeINT(out, lineData.switchesCount());
                for (int i = 0; i < lineData.switchesCount(); ++i) {
                    CoverageIOUtil.writeINT(out, lineData.getSwitchData(i).getHits().length);
                }
            }
            ++line;
        }
    }
}

