/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.instrumentation.BranchesInstrumenter;
import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.UnloadedUtil;
import com.intellij.rt.coverage.instrumentation.data.BranchDataContainer;
import com.intellij.rt.coverage.instrumentation.util.SaveLabelsMethodNode;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Opcodes;
import org.jetbrains.coverage.org.objectweb.asm.tree.MethodNode;

public class BranchesEnumerator
extends MethodVisitor
implements Opcodes {
    private final BranchesInstrumenter myInstrumenter;
    private final MethodNode myMethodNode = (MethodNode)this.mv;
    private final MethodVisitor myWriterMethodVisitor;
    protected final BranchDataContainer myBranchData;
    private final int myAccess;
    private final String myMethodName;
    private final String myDescriptor;
    protected int myCurrentLine;
    private boolean myHasExecutableLines = false;

    public BranchesEnumerator(BranchesInstrumenter instrumenter, BranchDataContainer branchData, MethodVisitor mv, int access, String name, String desc, String signature, String[] exceptions) {
        super(589824, new SaveLabelsMethodNode(access, name, desc, signature, exceptions));
        this.myInstrumenter = instrumenter;
        this.myWriterMethodVisitor = mv;
        this.myAccess = access;
        this.myMethodName = name;
        this.myDescriptor = desc;
        this.myBranchData = branchData;
    }

    protected void onNewJump(Label originalLabel, Label trueLabel, Label falseLabel) {
    }

    protected void onNewSwitch(SwitchLabels original, SwitchLabels replacement) {
    }

    public void visitEnd() {
        super.visitEnd();
        if (this.myWriterMethodVisitor != UnloadedUtil.EMPTY_METHOD_VISITOR) {
            this.myMethodNode.accept(this.myInstrumenter.createInstrumentingVisitor(this.myWriterMethodVisitor, this, this.myAccess, this.myMethodName, this.myDescriptor));
        }
    }

    public void visitLineNumber(int line, Label start) {
        this.myCurrentLine = line;
        this.myHasExecutableLines = true;
        LineData lineData = this.myInstrumenter.getOrCreateLineData(this.myCurrentLine, this.myMethodName, this.myDescriptor);
        if (lineData != null) {
            this.myBranchData.addLine(lineData);
        }
        super.visitLineNumber(line, start);
    }

    public void visitJumpInsn(int opcode, Label label) {
        LineData lineData;
        if (!this.myHasExecutableLines) {
            super.visitJumpInsn(opcode, label);
            return;
        }
        boolean jumpInstrumented = false;
        if (opcode != 167 && opcode != 168 && !"<clinit>".equals(this.myMethodName) && (lineData = this.myInstrumenter.getLineData(this.myCurrentLine)) != null) {
            Label trueLabel = new Label();
            Label falseLabel = new Label();
            this.myBranchData.addJump(lineData, trueLabel, falseLabel);
            this.onNewJump(label, trueLabel, falseLabel);
            jumpInstrumented = true;
            super.visitJumpInsn(opcode, trueLabel);
            super.visitJumpInsn(167, falseLabel);
            super.visitLabel(trueLabel);
            super.visitJumpInsn(167, label);
            super.visitLabel(falseLabel);
        }
        if (!jumpInstrumented) {
            super.visitJumpInsn(opcode, label);
        }
    }

    private SwitchLabels replaceLabels(SwitchLabels original, LineData lineData, int[] keys) {
        Label beforeSwitchLabel = new Label();
        Label newDefaultLabel = new Label();
        Label[] newLabels = new Label[original.getLabels().length];
        for (int i = 0; i < original.getLabels().length; ++i) {
            newLabels[i] = new Label();
        }
        super.visitJumpInsn(167, beforeSwitchLabel);
        SwitchLabels replacement = new SwitchLabels(newDefaultLabel, newLabels);
        this.myBranchData.addSwitch(lineData, keys, newDefaultLabel, newLabels);
        this.onNewSwitch(original, replacement);
        for (int i = 0; i < newLabels.length; ++i) {
            super.visitLabel(newLabels[i]);
            super.visitJumpInsn(167, original.getLabels()[i]);
        }
        super.visitLabel(newDefaultLabel);
        super.visitJumpInsn(167, original.getDefault());
        super.visitLabel(beforeSwitchLabel);
        return replacement;
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        if (!this.myHasExecutableLines) {
            super.visitLookupSwitchInsn(dflt, keys, labels);
            return;
        }
        SwitchLabels switchLabels = this.visitSwitch(dflt, labels, keys);
        super.visitLookupSwitchInsn(switchLabels.getDefault(), keys, switchLabels.getLabels());
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        if (!this.myHasExecutableLines) {
            super.visitTableSwitchInsn(min, max, dflt, labels);
            return;
        }
        SwitchLabels switchLabels = this.visitSwitch(dflt, labels, BranchesEnumerator.asLookupKeys(min, max));
        super.visitTableSwitchInsn(min, max, switchLabels.getDefault(), switchLabels.getLabels());
    }

    private SwitchLabels visitSwitch(Label dflt, Label[] labels, int[] keys) {
        SwitchLabels switchLabels = new SwitchLabels(dflt, labels);
        LineData lineData = this.myInstrumenter.getLineData(this.myCurrentLine);
        if (lineData != null) {
            switchLabels = this.replaceLabels(switchLabels, lineData, keys);
        }
        return switchLabels;
    }

    private static int[] asLookupKeys(int min, int max) {
        int[] keys = new int[max - min + 1];
        for (int i = min; min <= i && i <= max; ++i) {
            keys[i - min] = i;
        }
        return keys;
    }

    public boolean hasNoLines() {
        return !this.myHasExecutableLines;
    }

    protected Instrumenter getInstrumenter() {
        return this.myInstrumenter;
    }

    protected static class SwitchLabels {
        private final Label myDefault;
        private final Label[] myLabels;

        private SwitchLabels(Label dflt, Label[] labels) {
            this.myDefault = dflt;
            this.myLabels = labels;
        }

        public Label getDefault() {
            return this.myDefault;
        }

        public Label[] getLabels() {
            return this.myLabels;
        }
    }
}

