/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.AbstractIntellijClassfileTransformer;
import com.intellij.rt.coverage.instrumentation.BranchesInstrumenter;
import com.intellij.rt.coverage.instrumentation.InstrumentationUtils;
import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.LineInstrumenter;
import com.intellij.rt.coverage.instrumentation.dataAccess.CondyCoverageDataAccess;
import com.intellij.rt.coverage.instrumentation.dataAccess.CoverageDataAccess;
import com.intellij.rt.coverage.instrumentation.dataAccess.FieldCoverageDataAccess;
import com.intellij.rt.coverage.instrumentation.dataAccess.NameCoverageDataAccess;
import com.intellij.rt.coverage.instrumentation.filters.FilterUtils;
import com.intellij.rt.coverage.instrumentation.filters.classFilter.ClassFilter;
import com.intellij.rt.coverage.instrumentation.filters.classes.ClassSignatureFilter;
import com.intellij.rt.coverage.instrumentation.testTracking.TestTrackingMode;
import com.intellij.rt.coverage.util.ClassNameUtil;
import com.intellij.rt.coverage.util.OptionsUtil;
import com.intellij.rt.coverage.util.classFinder.ClassFinder;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageTransformer
extends AbstractIntellijClassfileTransformer {
    private static final List<ClassSignatureFilter> ourFilters = FilterUtils.createClassSignatureFilters();
    private final ProjectData data;
    private final boolean shouldSaveSource;
    private final List<Pattern> excludePatterns;
    private final List<Pattern> includePatterns;
    private final ClassFinder cf;
    private final TestTrackingMode testTrackingMode;

    public CoverageTransformer(ProjectData data, boolean shouldSaveSource, List<Pattern> excludePatterns, List<Pattern> includePatterns) {
        this(data, shouldSaveSource, excludePatterns, includePatterns, null, null);
    }

    public CoverageTransformer(ProjectData data, boolean shouldSaveSource, List<Pattern> excludePatterns, List<Pattern> includePatterns, ClassFinder cf, TestTrackingMode testTrackingMode) {
        this.data = data;
        this.shouldSaveSource = shouldSaveSource;
        this.excludePatterns = excludePatterns;
        this.includePatterns = includePatterns;
        this.cf = cf;
        this.testTrackingMode = testTrackingMode;
    }

    @Override
    protected ClassVisitor createClassVisitor(String className, ClassLoader loader, ClassReader cr, ClassVisitor cw) {
        return CoverageTransformer.createInstrumenter(this.data, className, cr, cw, this.testTrackingMode, this.data.isBranchCoverage(), this.shouldSaveSource, OptionsUtil.IGNORE_PRIVATE_CONSTRUCTOR_OF_UTIL_CLASS, this.createDataAccess(className, cr, this.data.isBranchCoverage()));
    }

    static ClassVisitor createInstrumenter(ProjectData data, String className, ClassReader cr, ClassVisitor cw, TestTrackingMode testTrackingMode, boolean branchCoverage, boolean shouldSaveSource, boolean shouldIgnorePrivateConstructorOfUtilCLass, CoverageDataAccess dataAccess) {
        for (ClassSignatureFilter filter : ourFilters) {
            if (!filter.shouldFilter(cr)) continue;
            return null;
        }
        Instrumenter instrumenter = branchCoverage ? (testTrackingMode != null ? testTrackingMode.createInstrumenter(data, cw, cr, className, shouldSaveSource, dataAccess) : new BranchesInstrumenter(data, cw, className, shouldSaveSource, dataAccess)) : new LineInstrumenter(data, cw, className, shouldSaveSource, dataAccess);
        ClassVisitor result = instrumenter;
        instrumenter.addProperty("PrivateConstructorOfUtilClassFilter", shouldIgnorePrivateConstructorOfUtilCLass);
        for (ClassFilter cv : FilterUtils.createClassFilters()) {
            if (!cv.isApplicable(instrumenter)) continue;
            cv.initFilter(instrumenter, result);
            result = cv;
        }
        return result;
    }

    private CoverageDataAccess createDataAccess(String className, ClassReader cr, boolean branchCoverage) {
        if (!branchCoverage && OptionsUtil.NEW_LINE_COVERAGE_ENABLED || branchCoverage && OptionsUtil.NEW_BRANCH_COVERAGE_ENABLED) {
            if (OptionsUtil.CONDY_ENABLED && InstrumentationUtils.getBytecodeVersion(cr) >= 55) {
                return new CondyCoverageDataAccess(this.createCondyInit(className, cr, branchCoverage));
            }
            return new FieldCoverageDataAccess(cr, className, this.createInit(className, cr, branchCoverage));
        }
        return new NameCoverageDataAccess(this.createInit(className, cr, branchCoverage));
    }

    protected CoverageDataAccess.Init createInit(String className, ClassReader cr, boolean branchCoverage) {
        return new CoverageDataAccess.Init("__$hits$__", "[I", "com/intellij/rt/coverage/data/ProjectData", "getHitsMask", "(Ljava/lang/String;)[I", new Object[]{className});
    }

    protected CoverageDataAccess.Init createCondyInit(String className, ClassReader cr, boolean branchCoverage) {
        return new CoverageDataAccess.Init("__$hits$__", "[I", "com/intellij/rt/coverage/util/CondyUtils", "getHitsMask", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/Class;Ljava/lang/String;)[I", new Object[]{className});
    }

    @Override
    protected boolean shouldExclude(String className) {
        return ClassNameUtil.matchesPatterns(className, this.excludePatterns);
    }

    @Override
    protected AbstractIntellijClassfileTransformer.InclusionPattern getInclusionPattern() {
        return this.includePatterns.isEmpty() ? null : new AbstractIntellijClassfileTransformer.InclusionPattern(){

            public boolean accept(String className) {
                return ClassNameUtil.matchesPatterns(className, CoverageTransformer.this.includePatterns);
            }
        };
    }

    @Override
    protected void visitClassLoader(ClassLoader classLoader) {
        if (this.cf != null) {
            this.cf.addClassLoader(classLoader);
        }
    }

    @Override
    protected boolean isStopped() {
        return this.data.isStopped();
    }
}

