/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.instrumentation.filters.FilterUtils;
import com.intellij.rt.coverage.instrumentation.filters.methods.MethodFilter;
import com.intellij.rt.coverage.util.StringsPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.coverage.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodFilteringVisitor
extends ClassVisitor {
    private static final List<MethodFilter> ourMethodFilters = FilterUtils.createMethodFilters();
    private final String myClassName;
    private boolean myEnum = false;
    private boolean myHasInterfaces = false;
    private boolean myIsAbstract = false;
    private final List<String> myAnnotations = new ArrayList<String>();
    private HashMap<String, Object> myProperties;

    public MethodFilteringVisitor(ClassVisitor classVisitor, String className) {
        super(589824, classVisitor);
        this.myClassName = className;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.myEnum = (access & 0x4000) != 0;
        this.myHasInterfaces = interfaces != null && interfaces.length > 0;
        this.myIsAbstract = (access & 0x400) != 0;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public boolean shouldInstrumentMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ((access & 0x40) != 0) {
            return false;
        }
        if ((access & 0x400) != 0) {
            return false;
        }
        for (MethodFilter filter : ourMethodFilters) {
            if (!filter.shouldFilter(access, name, desc, signature, exceptions, this)) continue;
            return false;
        }
        return true;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        this.myAnnotations.add(StringsPool.getFromPool(descriptor));
        return super.visitAnnotation(descriptor, visible);
    }

    public String getClassName() {
        return this.myClassName;
    }

    public boolean isEnum() {
        return this.myEnum;
    }

    public boolean isAbstract() {
        return this.myIsAbstract;
    }

    public boolean hasInterfaces() {
        return this.myHasInterfaces;
    }

    public List<String> getAnnotations() {
        return this.myAnnotations;
    }

    public Object getProperty(String key) {
        if (this.myProperties == null) {
            return null;
        }
        return this.myProperties.get(key);
    }

    public void addProperty(String key, Object value) {
        if (this.myProperties == null) {
            this.myProperties = new HashMap();
        }
        this.myProperties.put(key, value);
    }
}

