/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.branches;

import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.filters.KotlinUtils;
import com.intellij.rt.coverage.instrumentation.filters.branches.BranchesFilter;
import org.jetbrains.coverage.org.objectweb.asm.Label;

public class KotlinWhenStringFilter
extends BranchesFilter {
    private int myState = 0;
    private Label myJumpLabel;
    private Label myDefaultLabel;

    public boolean isApplicable(Instrumenter context, int access, String name, String desc, String signature, String[] exceptions) {
        return KotlinUtils.isKotlinClass(context);
    }

    public void visitJumpInsn(int opcode, Label label) {
        super.visitJumpInsn(opcode, label);
        if (this.myState == 0 && opcode == 198) {
            this.myJumpLabel = label;
            ++this.myState;
        } else if (this.myState == 5 && opcode == 153 && label == this.myDefaultLabel) {
            this.myState = 0;
            this.myBranchData.removeLastJump();
        } else if (this.myState == 5 && opcode == 154) {
            ++this.myState;
        } else if (this.myState == 6 && opcode == 167 && label == this.myDefaultLabel) {
            this.myState = 3;
            this.myBranchData.removeLastJump();
        } else {
            this.myState = 0;
        }
    }

    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        if ((this.myState == 0 || this.myState == 1) && opcode == 182 && "java/lang/String".equals(owner) && "hashCode".equals(name) && "()I".equals(descriptor)) {
            this.myState = 2;
            return;
        }
        if (this.myState == 4 && opcode == 182 && "java/lang/String".equals(owner) && "equals".equals(name) && "(Ljava/lang/Object;)Z".equals(descriptor)) {
            ++this.myState;
            return;
        }
        this.myState = 0;
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        super.visitLookupSwitchInsn(dflt, keys, labels);
        this.visitSwitch(dflt);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        super.visitTableSwitchInsn(min, max, dflt, labels);
        this.visitSwitch(dflt);
    }

    private void visitSwitch(Label dflt) {
        if (this.myState == 2) {
            if (this.myJumpLabel == dflt) {
                this.myJumpLabel = null;
                this.myBranchData.removeLastJump();
            }
            this.myDefaultLabel = dflt;
            ++this.myState;
            return;
        }
        this.myState = 0;
    }

    public void visitLdcInsn(Object value) {
        super.visitLdcInsn(value);
        if ((this.myState == 3 || this.myState == 6) && value instanceof String) {
            this.myState = 4;
            return;
        }
        this.myState = 0;
    }
}

