/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.offline;

import com.intellij.rt.coverage.offline.RawHitsReport;
import com.intellij.rt.coverage.offline.RawProjectData;
import com.intellij.rt.coverage.util.ErrorReporter;
import com.intellij.rt.coverage.util.MethodCaller;
import java.io.File;

public class RawProjectInit {
    private static final MethodCaller GET_OR_CREATE_HITS_MASK_INTERNAL_METHOD = new MethodCaller("getOrCreateHitsInternal", new Class[]{String.class, Integer.TYPE});
    public static volatile RawProjectData ourProjectData;

    public static int[] getOrCreateHitsMask(String className, int length) {
        if (ourProjectData != null) {
            return RawProjectInit.ourProjectData.getOrCreateClass((String)className, (int)length).hits;
        }
        try {
            return (int[])GET_OR_CREATE_HITS_MASK_INTERNAL_METHOD.invokeStatic(RawProjectInit.class.getName(), new Object[]{className, length}, ClassLoader.getSystemClassLoader());
        }
        catch (Exception e) {
            ErrorReporter.reportError("Error in class data access: " + className, e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int[] getOrCreateHitsInternal(String className, int length) {
        if (ourProjectData != null) return RawProjectInit.ourProjectData.getOrCreateClass((String)className, (int)length).hits;
        Class<RawProjectData> clazz = RawProjectData.class;
        synchronized (RawProjectData.class) {
            if (ourProjectData != null) return RawProjectInit.ourProjectData.getOrCreateClass((String)className, (int)length).hits;
            ourProjectData = new RawProjectData();
            String filePath = System.getProperty("coverage.offline.report.path");
            if (filePath != null) {
                File file = new File(filePath);
                RawHitsReport.dumpOnExit(file, ourProjectData);
                ErrorReporter.setBasePath(file.getParent());
            } else {
                ErrorReporter.reportError("Output file path is not set. Please set 'coverage.offline.report.path' property");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return RawProjectInit.ourProjectData.getOrCreateClass((String)className, (int)length).hits;
        }
    }
}

