/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodCaller {
    private Method myMethod;
    private final String myMethodName;
    private final Class<?>[] myParamTypes;

    public MethodCaller(String methodName, Class<?>[] paramTypes) {
        this.myMethodName = methodName;
        this.myParamTypes = paramTypes;
    }

    public Object invoke(Object thisObj, Object[] paramValues) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (this.myMethod == null) {
            this.myMethod = MethodCaller.findMethod(thisObj.getClass(), this.myMethodName, this.myParamTypes);
        }
        return this.myMethod.invoke(thisObj, paramValues);
    }

    public Object invokeStatic(String className, Object[] paramValues, ClassLoader loader) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        if (this.myMethod == null) {
            Class<?> clazz = Class.forName(className, false, loader);
            this.myMethod = MethodCaller.findMethod(clazz, this.myMethodName, this.myParamTypes);
        }
        return this.myMethod.invoke(null, paramValues);
    }

    private static Method findMethod(Class<?> clazz, String name, Class<?>[] paramTypes) throws NoSuchMethodException {
        Method m = clazz.getDeclaredMethod(name, paramTypes);
        m.setAccessible(true);
        return m;
    }
}

