/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.data.instructions.ClassInstructions;
import com.intellij.rt.coverage.instrumentation.BranchesEnumerator;
import com.intellij.rt.coverage.instrumentation.InstructionsEnumerator;
import com.intellij.rt.coverage.instrumentation.InstrumentationUtils;
import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.data.BranchDataContainer;
import com.intellij.rt.coverage.instrumentation.data.Jump;
import com.intellij.rt.coverage.instrumentation.data.Switch;
import com.intellij.rt.coverage.instrumentation.dataAccess.CoverageDataAccess;
import com.intellij.rt.coverage.instrumentation.filters.FilterUtils;
import com.intellij.rt.coverage.instrumentation.filters.branches.BranchesFilter;
import com.intellij.rt.coverage.instrumentation.util.LinesUtil;
import com.intellij.rt.coverage.instrumentation.util.LocalVariableInserter;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class BranchesInstrumenter
extends Instrumenter {
    private final CoverageDataAccess myDataAccess;
    private final BranchDataContainer myBranchData = new BranchDataContainer(this);

    public BranchesInstrumenter(ProjectData projectData, ClassVisitor classVisitor, String className, boolean shouldSaveSource, CoverageDataAccess dataAccess) {
        super(projectData, classVisitor, className, shouldSaveSource);
        this.myDataAccess = dataAccess;
    }

    protected MethodVisitor createMethodLineEnumerator(MethodVisitor mv, String name, String desc, int access, String signature, String[] exceptions) {
        this.myBranchData.resetMethod();
        mv = this.myProjectData.isInstructionsCoverageEnabled() ? new InstructionsEnumerator(this, this.myBranchData, mv, access, name, desc, signature, exceptions) : new BranchesEnumerator(this, this.myBranchData, mv, access, name, desc, signature, exceptions);
        return this.chainFilters(name, desc, access, signature, exceptions, mv);
    }

    public MethodVisitor createInstrumentingVisitor(MethodVisitor mv, BranchesEnumerator enumerator, int access, String name, String desc) {
        if (enumerator.hasNoLines()) {
            return this.myDataAccess.createMethodVisitor(mv, name, false);
        }
        HitsVisitor visitor = new HitsVisitor(mv, access, desc){

            public void visitCode() {
                BranchesInstrumenter.this.myDataAccess.onMethodStart(this.mv, this.getLVIndex());
                super.visitCode();
            }
        };
        return this.myDataAccess.createMethodVisitor(visitor, name, true);
    }

    public void visitEnd() {
        this.myDataAccess.onClassEnd(this);
        super.visitEnd();
        if (this.myProjectData.isInstructionsCoverageEnabled()) {
            ClassInstructions classInstructions = new ClassInstructions(this.myClassData, this.myBranchData.getInstructions());
            this.myProjectData.getInstructions().put(this.myClassData.getName(), classInstructions);
        }
    }

    protected void initLineData() {
        this.myClassData.createHitsMask(this.myBranchData.getSize());
        this.myClassData.setLines(LinesUtil.calcLineArray(this.myMaxLineNumber, this.myLines));
    }

    private MethodVisitor chainFilters(String name, String desc, int access, String signature, String[] exceptions, MethodVisitor root) {
        for (BranchesFilter filter : FilterUtils.createBranchFilters()) {
            if (!filter.isApplicable(this, access, name, desc, signature, exceptions)) continue;
            filter.initFilter(root, this, this.myBranchData);
            root = filter;
        }
        return root;
    }

    public class HitsVisitor
    extends LocalVariableInserter {
        public HitsVisitor(MethodVisitor methodVisitor, int access, String descriptor) {
            super(methodVisitor, access, descriptor, "__$localHits$__", "[I");
        }

        public void visitLineNumber(int line, Label start) {
            LineData lineData = BranchesInstrumenter.this.getLineData(line);
            if (lineData != null) {
                this.incrementHitById(lineData.getId());
            }
            super.visitLineNumber(line, start);
        }

        public void visitLabel(Label label) {
            Switch aSwitch;
            super.visitLabel(label);
            Jump jump = BranchesInstrumenter.this.myBranchData.getJump(label);
            if (jump != null) {
                this.incrementHitById(jump.getId());
            }
            if ((aSwitch = BranchesInstrumenter.this.myBranchData.getSwitch(label)) != null) {
                this.incrementHitById(aSwitch.getId());
            }
        }

        private void incrementHitById(int id) {
            if (id == -1) {
                return;
            }
            InstrumentationUtils.touchById(this.mv, this.getLVIndex(), id);
        }
    }
}

