/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.FileMapData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.JSR45Util;
import com.intellij.rt.coverage.instrumentation.MethodFilteringVisitor;
import com.intellij.rt.coverage.instrumentation.filters.FilterUtils;
import com.intellij.rt.coverage.instrumentation.filters.KotlinUtils;
import com.intellij.rt.coverage.instrumentation.filters.lines.LinesFilter;
import com.intellij.rt.coverage.util.ClassNameUtil;
import com.intellij.rt.coverage.util.StringsPool;
import org.jetbrains.coverage.gnu.trove.TIntHashSet;
import org.jetbrains.coverage.gnu.trove.TIntObjectHashMap;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public abstract class Instrumenter
extends MethodFilteringVisitor {
    private final boolean myShouldSaveSource;
    protected TIntObjectHashMap<LineData> myLines = new TIntObjectHashMap(4, 0.99f);
    private TIntHashSet myIgnoredLines;
    protected int myMaxLineNumber = -1;
    protected ClassData myClassData;
    protected boolean myProcess;
    private int myIgnoreSection = 0;

    public Instrumenter(ProjectData projectData, ClassVisitor classVisitor, String className, boolean shouldSaveSource) {
        super(classVisitor, className, projectData);
        this.myShouldSaveSource = shouldSaveSource;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.myProcess = (access & 0x200) == 0;
        this.myClassData = this.myProjectData.getOrCreateClassData(StringsPool.getFromPool(this.getClassName()));
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        if (mv == null) {
            return null;
        }
        if (!this.shouldInstrumentMethod(access, name, desc, signature, exceptions)) {
            return mv;
        }
        this.myProcess = true;
        MethodVisitor filters = this.chainFilters(mv, access, name, desc, signature, exceptions);
        return new MethodVisitor(589824, filters){

            public void visitLineNumber(int line, Label start) {
                if (Instrumenter.this.isIgnoreSection()) {
                    Instrumenter.this.onIgnoredLine(line);
                }
                super.visitLineNumber(line, start);
            }
        };
    }

    private MethodVisitor chainFilters(MethodVisitor root, int access, String name, String desc, String signature, String[] exceptions) {
        root = this.createMethodLineEnumerator(root, name, desc, access, signature, exceptions);
        for (LinesFilter filter : FilterUtils.createLineFilters()) {
            if (!filter.isApplicable(this, access, name, desc, signature, exceptions)) continue;
            filter.initFilter(root, this, name, desc);
            root = filter;
        }
        return root;
    }

    protected abstract MethodVisitor createMethodLineEnumerator(MethodVisitor var1, String var2, String var3, int var4, String var5, String[] var6);

    public void visitEnd() {
        if (this.myProcess) {
            this.initLineData();
            this.myLines = null;
            this.myClassData.setIgnoredLines(this.myIgnoredLines);
            this.myIgnoredLines = null;
        }
        super.visitEnd();
    }

    protected abstract void initLineData();

    protected LineData getOrCreateLineData(int line, String name, String desc) {
        LineData lineData;
        if (line > this.myMaxLineNumber) {
            this.myMaxLineNumber = line;
        }
        if (this.isIgnoreSection() && !KotlinUtils.isKotlinClass(this)) {
            return null;
        }
        if (this.myLines == null) {
            this.myLines = new TIntObjectHashMap();
        }
        if (!this.isIgnoreSection() && this.myIgnoredLines != null) {
            this.myIgnoredLines.remove(line);
        }
        if ((lineData = this.myLines.get(line)) == null) {
            lineData = new LineData(line, StringsPool.getFromPool(name + desc));
            this.myLines.put(line, lineData);
        }
        return lineData;
    }

    public void visitSource(String source, String debug) {
        FileMapData[] mapping;
        super.visitSource(source, debug);
        if (this.myShouldSaveSource) {
            this.myProjectData.getOrCreateClassData(StringsPool.getFromPool(this.getClassName())).setSource(source);
        }
        if (debug != null && (mapping = JSR45Util.extractLineMapping(debug, this.getClassName())) != null) {
            this.myProjectData.addLineMaps(this.getClassName(), mapping);
        }
    }

    public void visitOuterClass(String outerClassName, String methodName, String methodSig) {
        String fqnName;
        ClassData outerClass;
        if (this.myShouldSaveSource && (outerClass = this.myProjectData.getOrCreateClassData(StringsPool.getFromPool(fqnName = ClassNameUtil.convertToFQName(outerClassName)))).getSource() == null) {
            outerClass.setSource(this.myClassData.getSource());
        }
        super.visitOuterClass(outerClassName, methodName, methodSig);
    }

    public boolean isBranchCoverage() {
        return this.myProjectData.isBranchCoverage();
    }

    public LineData getLineData(int line) {
        return this.myLines.get(line);
    }

    public void removeLine(int line) {
        this.myLines.remove(line);
        this.onIgnoredLine(line);
    }

    private void onIgnoredLine(int line) {
        if (this.myIgnoredLines == null) {
            this.myIgnoredLines = new TIntHashSet();
        }
        this.myIgnoredLines.add(line);
    }

    public int linesCount() {
        return this.myLines.size();
    }

    public boolean isIgnoreSection() {
        return this.myIgnoreSection > 0;
    }

    public void setIgnoreSection(boolean ignore) {
        this.myIgnoreSection = ignore ? ++this.myIgnoreSection : --this.myIgnoreSection;
    }
}

