/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters;

import com.intellij.rt.coverage.instrumentation.MethodFilteringVisitor;
import com.intellij.rt.coverage.instrumentation.filters.branches.BranchesFilter;
import com.intellij.rt.coverage.instrumentation.filters.branches.KotlinCoroutinesBranchesFilter;
import com.intellij.rt.coverage.instrumentation.filters.branches.KotlinDefaultArgsBranchFilter;
import com.intellij.rt.coverage.instrumentation.filters.branches.KotlinLateinitFilter;
import com.intellij.rt.coverage.instrumentation.filters.branches.KotlinOpenMemberWithDefaultArgsFilter;
import com.intellij.rt.coverage.instrumentation.filters.branches.KotlinUnsafeCastFilter;
import com.intellij.rt.coverage.instrumentation.filters.branches.KotlinWhenMappingExceptionFilter;
import com.intellij.rt.coverage.instrumentation.filters.branches.KotlinWhenStringFilter;
import com.intellij.rt.coverage.instrumentation.filters.classFilter.ClassFilter;
import com.intellij.rt.coverage.instrumentation.filters.classFilter.KotlinAnonymousClassInIgnoredMethodFilter;
import com.intellij.rt.coverage.instrumentation.filters.classFilter.KotlinValueClassFilter;
import com.intellij.rt.coverage.instrumentation.filters.classes.ClassSignatureFilter;
import com.intellij.rt.coverage.instrumentation.filters.classes.KotlinFunctionOrPropertyReferenceFilter;
import com.intellij.rt.coverage.instrumentation.filters.lines.KotlinCoroutinesLinesFilter;
import com.intellij.rt.coverage.instrumentation.filters.lines.KotlinDefaultArgsLineFilter;
import com.intellij.rt.coverage.instrumentation.filters.lines.KotlinDeprecatedMethodFilter;
import com.intellij.rt.coverage.instrumentation.filters.lines.KotlinImplementerDefaultInterfaceMemberFilter;
import com.intellij.rt.coverage.instrumentation.filters.lines.KotlinInlineFilter;
import com.intellij.rt.coverage.instrumentation.filters.lines.LinesFilter;
import com.intellij.rt.coverage.instrumentation.filters.methods.KotlinLocalFunctionInsideIgnoredMethodFilter;
import com.intellij.rt.coverage.instrumentation.filters.methods.KotlinSyntheticAccessMethodFilter;
import com.intellij.rt.coverage.instrumentation.filters.methods.KotlinSyntheticConstructorOfSealedClassFilter;
import com.intellij.rt.coverage.instrumentation.filters.methods.MethodFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KotlinUtils {
    public static final String KOTLIN_DEFAULT_CONSTRUCTOR_MARKER = "Lkotlin/jvm/internal/DefaultConstructorMarker;";
    private static final String KOTLIN_CLASS_LABEL = "IS_KOTLIN";
    public static final String SEALED_CLASS_LABEL = "IS_SEALED_CLASS";
    public static final String KOTLIN_METADATA = "Lkotlin/Metadata;";
    private static final boolean ourKotlinEnabled = !"false".equals(System.getProperty("coverage.kotlin.enable", "true"));

    public static boolean isKotlinClass(MethodFilteringVisitor context) {
        Object currentProperty = context.getProperty(KOTLIN_CLASS_LABEL);
        if (currentProperty instanceof Boolean) {
            return (Boolean)currentProperty;
        }
        boolean isKotlin = context.getAnnotations().contains(KOTLIN_METADATA);
        context.addProperty(KOTLIN_CLASS_LABEL, isKotlin);
        return isKotlin;
    }

    public static boolean isSealedClass(MethodFilteringVisitor context) {
        Object currentProperty = context.getProperty(SEALED_CLASS_LABEL);
        if (currentProperty instanceof Boolean) {
            return (Boolean)currentProperty;
        }
        return false;
    }

    public static List<MethodFilter> createMethodFilters() {
        if (!ourKotlinEnabled) {
            return Collections.emptyList();
        }
        ArrayList<MethodFilter> result = new ArrayList<MethodFilter>();
        result.add(new KotlinSyntheticConstructorOfSealedClassFilter());
        result.add(new KotlinSyntheticAccessMethodFilter());
        result.add(new KotlinLocalFunctionInsideIgnoredMethodFilter());
        return result;
    }

    public static List<ClassSignatureFilter> createClassSignatureFilters() {
        if (!ourKotlinEnabled) {
            return Collections.emptyList();
        }
        ArrayList<ClassSignatureFilter> result = new ArrayList<ClassSignatureFilter>();
        result.add(new KotlinFunctionOrPropertyReferenceFilter());
        return result;
    }

    public static List<LinesFilter> createLineFilters() {
        if (!ourKotlinEnabled) {
            return Collections.emptyList();
        }
        ArrayList<LinesFilter> result = new ArrayList<LinesFilter>();
        result.add(new KotlinImplementerDefaultInterfaceMemberFilter());
        result.add(new KotlinCoroutinesLinesFilter());
        result.add(new KotlinInlineFilter());
        result.add(new KotlinDeprecatedMethodFilter());
        result.add(new KotlinDefaultArgsLineFilter());
        return result;
    }

    public static List<BranchesFilter> createBranchFilters() {
        if (!ourKotlinEnabled) {
            return Collections.emptyList();
        }
        ArrayList<BranchesFilter> result = new ArrayList<BranchesFilter>();
        result.add(new KotlinWhenMappingExceptionFilter());
        result.add(new KotlinDefaultArgsBranchFilter());
        result.add(new KotlinCoroutinesBranchesFilter());
        result.add(new KotlinLateinitFilter());
        result.add(new KotlinOpenMemberWithDefaultArgsFilter());
        result.add(new KotlinUnsafeCastFilter());
        result.add(new KotlinWhenStringFilter());
        return result;
    }

    public static List<ClassFilter> createClassFilters() {
        if (!ourKotlinEnabled) {
            return Collections.emptyList();
        }
        ArrayList<ClassFilter> result = new ArrayList<ClassFilter>();
        result.add(new KotlinValueClassFilter());
        result.add(new KotlinAnonymousClassInIgnoredMethodFilter());
        return result;
    }
}

