/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.branches;

import com.intellij.rt.coverage.data.JumpData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.SwitchData;
import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.filters.KotlinUtils;
import com.intellij.rt.coverage.instrumentation.filters.branches.BranchesFilter;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.coverage.org.objectweb.asm.Label;

public class KotlinWhenMappingExceptionFilter
extends BranchesFilter {
    private Map<Label, PositionData> myJumpLabels;
    private Map<Label, PositionData> mySwitchLabels;
    private Label myCurrentLabel = null;
    private int myCurrentLine;
    private int myState = 0;
    private Label myJumpLabel;

    public boolean isApplicable(Instrumenter context, int access, String name, String desc, String signature, String[] exceptions) {
        return KotlinUtils.isKotlinClass(context);
    }

    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
        this.myCurrentLine = line;
    }

    public void visitLabel(Label label) {
        super.visitLabel(label);
        this.myCurrentLabel = label;
        if (this.myState == 2 && label == this.myJumpLabel) {
            this.myBranchData.removeLastJump();
        }
        this.myState = 0;
    }

    public void visitJumpInsn(int opcode, Label label) {
        LineData lineData;
        this.myJumpLabel = label;
        this.myState = 1;
        if (opcode != 167 && opcode != 168 && (lineData = this.myContext.getLineData(this.myCurrentLine)) != null) {
            if (this.myJumpLabels == null) {
                this.myJumpLabels = new HashMap<Label, PositionData>();
            }
            this.myJumpLabels.put(label, new PositionData(this.myCurrentLine, lineData.jumpsCount()));
        }
        super.visitJumpInsn(opcode, label);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        LineData lineData = this.myContext.getLineData(this.myCurrentLine);
        if (lineData != null) {
            if (this.mySwitchLabels == null) {
                this.mySwitchLabels = new HashMap<Label, PositionData>();
            }
            this.mySwitchLabels.put(dflt, new PositionData(this.myCurrentLine, lineData.switchesCount()));
        }
        super.visitTableSwitchInsn(min, max, dflt, labels);
    }

    public void visitTypeInsn(int opcode, String type) {
        super.visitTypeInsn(opcode, type);
        if (opcode == 187 && type.equals("kotlin/NoWhenBranchMatchedException")) {
            SwitchData switchData;
            LineData lineData;
            PositionData switchPosition;
            JumpData jumpData;
            LineData lineData2;
            PositionData jumpPosition;
            this.myState = this.myState == 1 ? 2 : 0;
            PositionData positionData = jumpPosition = this.myJumpLabels == null ? null : this.myJumpLabels.get(this.myCurrentLabel);
            if (jumpPosition != null && (lineData2 = this.myContext.getLineData(jumpPosition.myLine)) != null && jumpPosition.myIndex < lineData2.jumpsCount() && (jumpData = lineData2.getJumpData(jumpPosition.myIndex)) != null) {
                jumpData.touchFalseHit();
            }
            PositionData positionData2 = switchPosition = this.mySwitchLabels == null ? null : this.mySwitchLabels.get(this.myCurrentLabel);
            if (switchPosition != null && (lineData = this.myContext.getLineData(switchPosition.myLine)) != null && switchPosition.myIndex < lineData.switchesCount() && (switchData = lineData.getSwitchData(switchPosition.myIndex)) != null) {
                switchData.touch(-1);
            }
        } else {
            this.myState = 0;
        }
    }

    private static class PositionData {
        private final int myLine;
        private final int myIndex;

        private PositionData(int line, int index) {
            this.myLine = line;
            this.myIndex = index;
        }
    }
}

