/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.lines;

import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.filters.lines.LinesFilter;
import com.intellij.rt.coverage.util.ClassNameUtil;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.coverage.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class AnnotationIgnoredMethodFilter
extends LinesFilter {
    private boolean myShouldIgnore;
    private String myName;
    private String myDesc;

    public boolean isApplicable(Instrumenter context, int access, String name, String desc, String signature, String[] exceptions) {
        List<Pattern> annotations = context.getProjectData().getAnnotationsToIgnore();
        return annotations != null && !annotations.isEmpty();
    }

    public void initFilter(MethodVisitor methodVisitor, Instrumenter context, String name, String desc) {
        super.initFilter(methodVisitor, context, name, desc);
        this.myName = name;
        this.myDesc = desc;
        List<Pattern> annotations = context.getProjectData().getAnnotationsToIgnore();
        for (String annotation : context.getAnnotations()) {
            String annotationName = ClassNameUtil.convertVMNameToFQN(annotation);
            if (!ClassNameUtil.matchesPatterns(annotationName, annotations)) continue;
            this.myContext.setIgnoreSection(true);
            this.myShouldIgnore = true;
            break;
        }
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        String annotationName = ClassNameUtil.convertVMNameToFQN(descriptor);
        if (!this.myShouldIgnore && ClassNameUtil.matchesPatterns(annotationName, this.myContext.getProjectData().getAnnotationsToIgnore())) {
            this.myContext.setIgnoreSection(true);
            this.myShouldIgnore = true;
        }
        return super.visitAnnotation(descriptor, visible);
    }

    public void visitCode() {
        super.visitCode();
        if (this.myShouldIgnore) {
            this.myContext.getProjectData().addIgnoredMethod(this.myContext.getClassName(), this.myName, this.myDesc);
        }
    }

    public void visitEnd() {
        super.visitEnd();
        if (this.myShouldIgnore) {
            this.myContext.setIgnoreSection(false);
        }
    }
}

