/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters;

import com.intellij.rt.coverage.instrumentation.filters.KotlinUtils;
import com.intellij.rt.coverage.instrumentation.filters.branches.BooleanInvertFilter;
import com.intellij.rt.coverage.instrumentation.filters.branches.BranchesFilter;
import com.intellij.rt.coverage.instrumentation.filters.branches.NotNullAssertionsFilter;
import com.intellij.rt.coverage.instrumentation.filters.classFilter.ClassFilter;
import com.intellij.rt.coverage.instrumentation.filters.classFilter.PrivateConstructorOfUtilClassFilter;
import com.intellij.rt.coverage.instrumentation.filters.classes.ClassSignatureFilter;
import com.intellij.rt.coverage.instrumentation.filters.lines.AnnotationIgnoredMethodFilter;
import com.intellij.rt.coverage.instrumentation.filters.lines.ClosingBracesFilter;
import com.intellij.rt.coverage.instrumentation.filters.lines.LinesFilter;
import com.intellij.rt.coverage.instrumentation.filters.methods.DeserializeLambdaFilter;
import com.intellij.rt.coverage.instrumentation.filters.methods.EnumMethodsFilter;
import com.intellij.rt.coverage.instrumentation.filters.methods.MethodFilter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterUtils {
    public static List<MethodFilter> createMethodFilters() {
        List<MethodFilter> result = KotlinUtils.createMethodFilters();
        result.add(new EnumMethodsFilter());
        result.add(new DeserializeLambdaFilter());
        return result;
    }

    public static List<ClassSignatureFilter> createClassSignatureFilters() {
        return KotlinUtils.createClassSignatureFilters();
    }

    public static List<ClassFilter> createClassFilters() {
        List<ClassFilter> result = KotlinUtils.createClassFilters();
        result.add(new PrivateConstructorOfUtilClassFilter());
        return result;
    }

    public static List<LinesFilter> createLineFilters() {
        List<LinesFilter> result = KotlinUtils.createLineFilters();
        result.add(new ClosingBracesFilter());
        result.add(new AnnotationIgnoredMethodFilter());
        return result;
    }

    public static List<BranchesFilter> createBranchFilters() {
        List<BranchesFilter> result = KotlinUtils.createBranchFilters();
        result.add(new NotNullAssertionsFilter());
        result.add(new BooleanInvertFilter());
        return result;
    }
}

