/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XMLProjectData {
    private final Map<String, FileInfo> myFiles = new HashMap<String, FileInfo>();
    private final Map<String, ClassInfo> myClasses = new HashMap<String, ClassInfo>();

    public void addClass(ClassInfo info) {
        this.myClasses.put(info.name, info);
    }

    public void addFile(FileInfo info) {
        this.myFiles.put(info.path, info);
    }

    public ClassInfo getClass(String name) {
        return this.myClasses.get(name);
    }

    public FileInfo getFile(String path) {
        return this.myFiles.get(path);
    }

    public Collection<ClassInfo> getClasses() {
        return this.myClasses.values();
    }

    public Collection<FileInfo> getFiles() {
        return this.myFiles.values();
    }

    public static class LineInfo {
        public final int lineNumber;
        public int missedInstructions;
        public int coveredInstructions;
        public int missedBranches;
        public int coveredBranches;

        public LineInfo(int lineNumber, int missedInstructions, int coveredInstructions, int missedBranches, int coveredBranches) {
            this.lineNumber = lineNumber;
            this.missedInstructions = missedInstructions;
            this.coveredInstructions = coveredInstructions;
            this.missedBranches = missedBranches;
            this.coveredBranches = coveredBranches;
        }

        public LineInfo(int lineNumber) {
            this.lineNumber = lineNumber;
        }
    }

    public static class FileInfo {
        public final String path;
        public final List<LineInfo> lines = new ArrayList<LineInfo>();

        public FileInfo(String path) {
            this.path = path;
        }
    }

    public static class ClassInfo {
        public final String name;
        public final String fileName;
        public final int missedLines;
        public final int coveredLines;
        public final int missedInstructions;
        public final int coveredInstructions;
        public final int missedBranches;
        public final int coveredBranches;
        public final int missedMethods;
        public final int coveredMethods;

        public ClassInfo(String name, String fileName, int missedLines, int coveredLines, int missedInstructions, int coveredInstructions, int missedBranches, int coveredBranches, int missedMethods, int coveredMethods) {
            this.name = name;
            this.fileName = fileName;
            this.missedLines = missedLines;
            this.coveredLines = coveredLines;
            this.missedInstructions = missedInstructions;
            this.coveredInstructions = coveredInstructions;
            this.missedBranches = missedBranches;
            this.coveredBranches = coveredBranches;
            this.missedMethods = missedMethods;
            this.coveredMethods = coveredMethods;
        }
    }
}

