/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.CoverageArgs;
import com.intellij.rt.coverage.instrumentation.CoverageRuntime;
import com.intellij.rt.coverage.instrumentation.CoverageTransformer;
import com.intellij.rt.coverage.instrumentation.testTracking.TestTrackingArrayMode;
import com.intellij.rt.coverage.instrumentation.testTracking.TestTrackingClassDataMode;
import com.intellij.rt.coverage.instrumentation.testTracking.TestTrackingMode;
import com.intellij.rt.coverage.util.CoverageReport;
import com.intellij.rt.coverage.util.ErrorReporter;
import com.intellij.rt.coverage.util.OptionsUtil;
import com.intellij.rt.coverage.util.TestTrackingCallback;
import com.intellij.rt.coverage.util.classFinder.ClassFinder;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Instrumentator {
    public static boolean ourIsInitialized = false;

    /*
     * WARNING - void declaration
     */
    public static void premain(String argsString, Instrumentation instrumentation) throws Exception {
        void var1_1;
        String string;
        new Instrumentator().performPremain(string, (Instrumentation)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void performPremain(String argsString, Instrumentation instrumentation) throws Exception {
        Class<Instrumentator> clazz = Instrumentator.class;
        synchronized (Instrumentator.class) {
            void var1_1;
            void var2_4;
            void var3_6;
            CoverageArgs args;
            if (ourIsInitialized) {
                ErrorReporter.info("Coverage agent has been applied twice, ignore the second one.");
                // ** MonitorExit[var3_5] (shouldn't be in output)
                return;
            }
            ourIsInitialized = true;
            // ** MonitorExit[var3_5] (shouldn't be in output)
            try {
                args = CoverageArgs.fromString(argsString);
            }
            catch (IllegalArgumentException e) {
                ErrorReporter.error("Failed to parse agent arguments", e);
                System.exit(1);
                return;
            }
            ErrorReporter.printInfo("---- IntelliJ IDEA coverage runner ---- ");
            ErrorReporter.printInfo(args.branchCoverage ? "Branch coverage " + (args.testTracking ? "with tracking per test coverage ..." : "...") : "Line coverage ...");
            this.logPatterns(args.includePatterns, "include");
            this.logPatterns(args.excludePatterns, "exclude");
            this.logPatterns(args.annotationsToIgnore, "exclude annotations");
            TestTrackingMode testTrackingMode = this.createTestTrackingMode(args.testTracking);
            TestTrackingCallback callback = testTrackingMode == null ? null : testTrackingMode.createTestTrackingCallback();
            ProjectData data = new ProjectData(args.dataFile, args.branchCoverage, callback);
            data.setIncludePatterns(args.includePatterns);
            data.setExcludePatterns(args.excludePatterns);
            data.setAnnotationsToIgnore(args.annotationsToIgnore);
            data.setInstructionsCoverage(OptionsUtil.INSTRUCTIONS_COVERAGE_ENABLED);
            this.createDataFile(args.dataFile);
            CoverageRuntime.installRuntime(data);
            ClassFinder cf = new ClassFinder(args.includePatterns, args.excludePatterns);
            CoverageReport report = new CoverageReport(args.dataFile, args.calcUnloaded, cf, args.mergeData);
            report.setSourceMapFile(args.sourceMap);
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(this, report, data){
                final /* synthetic */ CoverageReport val$report;
                final /* synthetic */ ProjectData val$data;
                final /* synthetic */ Instrumentator this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$report = coverageReport;
                    this.val$data = projectData;
                }

                public void run() {
                    this.val$report.save(this.val$data);
                }
            }));
            boolean shouldSaveSource = args.sourceMap != null;
            CoverageTransformer transformer = new CoverageTransformer(data, (boolean)var3_6, cf, testTrackingMode);
            this.addTransformer((Instrumentation)var2_4, (CoverageTransformer)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createDataFile(File dataFile) throws IOException {
        if (dataFile != null && !dataFile.exists()) {
            void var1_1;
            File parentDir = dataFile.getParentFile();
            if (parentDir != null && !parentDir.exists()) {
                void var2_2;
                var2_2.mkdirs();
            }
            var1_1.createNewFile();
        }
    }

    private void logPatterns(List<Pattern> patterns, String name) {
        Iterator iterator;
        Pattern pattern;
        if (patterns.isEmpty()) {
            return;
        }
        ErrorReporter.printInfo((String)((Object)pattern) + " patterns:");
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            pattern = (Pattern)iterator.next();
            ErrorReporter.printInfo(pattern.pattern());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addTransformer(Instrumentation instrumentation, CoverageTransformer transformer) {
        try {
            Method method = Instrumentation.class.getMethod("addTransformer", ClassFileTransformer.class, Boolean.TYPE);
            method.invoke((Object)instrumentation, transformer, Boolean.TRUE);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            void var2_2;
            void var1_1;
            var1_1.addTransformer((ClassFileTransformer)var2_2);
            return;
        }
        catch (Exception e) {
            void var3_4;
            ErrorReporter.error("Adding transformer failed.", (Throwable)var3_4);
            System.exit(1);
            return;
        }
    }

    private TestTrackingMode createTestTrackingMode(boolean traceLines) {
        if (!traceLines) {
            return null;
        }
        if (OptionsUtil.NEW_TEST_TRACKING_ENABLED) {
            return new TestTrackingArrayMode();
        }
        return new TestTrackingClassDataMode();
    }
}

