/*
 * Copyright 2000-2021 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.rt.coverage.instrumentation.testTracking;

import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.data.InstrumentationData;
import com.intellij.rt.coverage.util.TestTrackingCallback;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;

import java.io.File;

/**
 * Test tracking strategy.
 * <p>
 * Test tracking is an extra ability of coverage engine to track per test coverage.
 * To do that, coverage engine listens to test start/end event and resets test specific coverage.
 *
 * @see ProjectData#testStarted
 * @see ProjectData#testEnded
 */
public interface TestTrackingMode {
  TestTrackingCallback createTestTrackingCallback(File file);

  ClassVisitor createInstrumenter(ClassVisitor classVisitor, InstrumentationData data);
}
