/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.pluginRepository.internal.instances;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.pluginRepository.PluginUploader;
import org.jetbrains.intellij.pluginRepository.internal.Messages;
import org.jetbrains.intellij.pluginRepository.internal.api.PluginRepositoryInstanceKt;
import org.jetbrains.intellij.pluginRepository.internal.api.PluginRepositoryService;
import org.jetbrains.intellij.pluginRepository.internal.utils.RequestHelperKt;
import org.jetbrains.intellij.pluginRepository.internal.utils.UploadPluginHelperKt;
import org.jetbrains.intellij.pluginRepository.model.PluginBean;
import org.jetbrains.intellij.pluginRepository.model.PluginUpdateBean;
import org.jetbrains.intellij.pluginRepository.model.ProductFamily;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J0\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\nj\u0002`\u00122\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\fH\u0016J0\u0010\u000f\u001a\u00020\u00102\n\u0010\u0015\u001a\u00060\fj\u0002`\u00162\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\fH\u0016JQ\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0010\b\u0002\u0010\u0018\u001a\n\u0018\u00010\nj\u0004\u0018\u0001`\u00122\u0010\b\u0002\u0010\u0019\u001a\n\u0018\u00010\fj\u0004\u0018\u0001`\u00162\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/intellij/pluginRepository/internal/instances/PluginUploaderInstance;", "Lorg/jetbrains/intellij/pluginRepository/PluginUploader;", "service", "Lorg/jetbrains/intellij/pluginRepository/internal/api/PluginRepositoryService;", "(Lorg/jetbrains/intellij/pluginRepository/internal/api/PluginRepositoryService;)V", "uploadNewPlugin", "Lorg/jetbrains/intellij/pluginRepository/model/PluginBean;", "file", "Ljava/io/File;", "categoryId", "", "licenseUrl", "", "family", "Lorg/jetbrains/intellij/pluginRepository/model/ProductFamily;", "uploadPlugin", "", "id", "Lorg/jetbrains/intellij/pluginRepository/model/PluginId;", "channel", "notes", "xmlId", "Lorg/jetbrains/intellij/pluginRepository/model/PluginXmlId;", "uploadPluginInternal", "pluginId", "pluginXmlId", "(Ljava/io/File;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "Companion", "rest"})
public final class PluginUploaderInstance
implements PluginUploader {
    private final PluginRepositoryService service;
    public static final long MAX_FILE_SIZE = 0x19000000L;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public PluginBean uploadNewPlugin(@NotNull File file, int categoryId, @NotNull String licenseUrl, @NotNull ProductFamily family) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)licenseUrl, (String)"licenseUrl");
        Intrinsics.checkNotNullParameter((Object)((Object)family), (String)"family");
        if (file.length() > 0x19000000L) {
            throw (Throwable)new IllegalArgumentException(Messages.INSTANCE.getMessage("max.file.size", new Object[0]));
        }
        PluginRepositoryInstanceKt.getLOG().info("Uploading new plugin from " + file.getAbsolutePath());
        PluginBean plugin = (PluginBean)UploadPluginHelperKt.uploadOrFail$default(this.service.uploadNewPlugin(RequestHelperKt.toMultipartBody(file), family.getId(), RequestHelperKt.toRequestBody(licenseUrl), categoryId), null, 2, null);
        PluginRepositoryInstanceKt.getLOG().info(plugin.getName() + " was successfully uploaded with id " + plugin.getId());
        return plugin;
    }

    @Override
    public void uploadPlugin(int id, @NotNull File file, @Nullable String channel, @Nullable String notes) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PluginUploaderInstance.uploadPluginInternal$default(this, file, id, null, channel, notes, 4, null);
    }

    @Override
    public void uploadPlugin(@NotNull String xmlId, @NotNull File file, @Nullable String channel, @Nullable String notes) {
        Intrinsics.checkNotNullParameter((Object)xmlId, (String)"xmlId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PluginUploaderInstance.uploadPluginInternal$default(this, file, null, xmlId, channel, notes, 2, null);
    }

    private final void uploadPluginInternal(File file, Integer pluginId, String pluginXmlId, String channel, String notes) {
        PluginUpdateBean pluginUpdateBean;
        if (pluginXmlId == null && pluginId == null) {
            throw (Throwable)new IllegalArgumentException(Messages.INSTANCE.getMessage("missing.plugins.parameters", new Object[0]));
        }
        if (file.length() > 0x19000000L) {
            throw (Throwable)new IllegalArgumentException(Messages.INSTANCE.getMessage("max.file.size", new Object[0]));
        }
        String string = channel;
        RequestBody channelAsRequestBody = string != null ? RequestHelperKt.toRequestBody(string) : null;
        String string2 = notes;
        RequestBody notesAsRequestBody = string2 != null ? RequestHelperKt.toRequestBody(string2) : null;
        MultipartBody.Part multipartFile = RequestHelperKt.toMultipartBody(file);
        if (pluginXmlId != null) {
            pluginUpdateBean = UploadPluginHelperKt.uploadOrFail(this.service.uploadByXmlId(RequestHelperKt.toRequestBody(pluginXmlId), channelAsRequestBody, notesAsRequestBody, multipartFile), pluginXmlId);
        } else {
            Integer n = pluginId;
            Intrinsics.checkNotNull((Object)n);
            pluginUpdateBean = UploadPluginHelperKt.uploadOrFail(this.service.upload(n, channelAsRequestBody, notesAsRequestBody, multipartFile), String.valueOf(pluginId));
        }
        PluginUpdateBean message = pluginUpdateBean;
        PluginRepositoryInstanceKt.getLOG().info("Uploading of plugin is done");
    }

    static /* synthetic */ void uploadPluginInternal$default(PluginUploaderInstance pluginUploaderInstance, File file, Integer n, String string, String string2, String string3, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        if ((n2 & 4) != 0) {
            string = null;
        }
        if ((n2 & 8) != 0) {
            string2 = null;
        }
        if ((n2 & 0x10) != 0) {
            string3 = null;
        }
        pluginUploaderInstance.uploadPluginInternal(file, n, string, string2, string3);
    }

    public PluginUploaderInstance(@NotNull PluginRepositoryService service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        this.service = service;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/intellij/pluginRepository/internal/instances/PluginUploaderInstance$Companion;", "", "()V", "MAX_FILE_SIZE", "", "rest"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

