/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.pluginRepository.internal.instances;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.pluginRepository.PluginUpdateManager;
import org.jetbrains.intellij.pluginRepository.internal.api.PluginRepositoryService;
import org.jetbrains.intellij.pluginRepository.internal.utils.RequestHelperKt;
import org.jetbrains.intellij.pluginRepository.model.IntellijUpdateMetadata;
import org.jetbrains.intellij.pluginRepository.model.PluginUpdateBean;
import org.jetbrains.intellij.pluginRepository.model.ProductFamily;
import retrofit2.Response;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\t2\n\u0010\n\u001a\u00060\bj\u0002`\u000bH\u0016J:\u0010\f\u001a\u0012\u0012\b\u0012\u00060\bj\u0002`\u000b\u0012\u0004\u0012\u00020\u00060\r2 \u0010\u000e\u001a\u001c\u0012\u0018\u0012\u0016\u0012\b\u0012\u00060\bj\u0002`\t\u0012\b\u0012\u00060\bj\u0002`\u000b0\u00100\u000fH\u0016J\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\u0010\u0013\u001a\u00060\bj\u0002`\u000bH\u0016J*\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f2\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u00172\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/intellij/pluginRepository/internal/instances/PluginUpdateManagerInstance;", "Lorg/jetbrains/intellij/pluginRepository/PluginUpdateManager;", "service", "Lorg/jetbrains/intellij/pluginRepository/internal/api/PluginRepositoryService;", "(Lorg/jetbrains/intellij/pluginRepository/internal/api/PluginRepositoryService;)V", "getIntellijUpdateMetadata", "Lorg/jetbrains/intellij/pluginRepository/model/IntellijUpdateMetadata;", "pluginId", "", "Lorg/jetbrains/intellij/pluginRepository/model/PluginId;", "updateId", "Lorg/jetbrains/intellij/pluginRepository/model/UpdateId;", "getIntellijUpdateMetadataBatch", "", "updateIds", "", "Lkotlin/Pair;", "getUpdateById", "Lorg/jetbrains/intellij/pluginRepository/model/PluginUpdateBean;", "id", "getUpdatesByVersionAndFamily", "xmlId", "", "Lorg/jetbrains/intellij/pluginRepository/model/StringPluginId;", "version", "family", "Lorg/jetbrains/intellij/pluginRepository/model/ProductFamily;", "rest"})
public final class PluginUpdateManagerInstance
implements PluginUpdateManager {
    @NotNull
    private final PluginRepositoryService service;

    public PluginUpdateManagerInstance(@NotNull PluginRepositoryService service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        this.service = service;
    }

    @Override
    @NotNull
    public List<PluginUpdateBean> getUpdatesByVersionAndFamily(@NotNull String xmlId, @NotNull String version, @NotNull ProductFamily family) {
        Intrinsics.checkNotNullParameter((Object)xmlId, (String)"xmlId");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)((Object)family), (String)"family");
        List list = RequestHelperKt.executeAndParseBody(this.service.getUpdatesByVersionAndFamily(xmlId, version, family.getId()), true);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @Nullable
    public PluginUpdateBean getUpdateById(int id) {
        return RequestHelperKt.executeAndParseBody(this.service.getUpdateById(id), true);
    }

    @Override
    @Nullable
    public IntellijUpdateMetadata getIntellijUpdateMetadata(int pluginId, int updateId) {
        return RequestHelperKt.executeAndParseBody(this.service.getIntelliJUpdateMeta(pluginId, updateId), true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<Integer, IntellijUpdateMetadata> getIntellijUpdateMetadataBatch(@NotNull List<Pair<Integer, Integer>> updateIds) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(updateIds, (String)"updateIds");
        Iterable $this$map$iv = updateIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $dstr$pluginId$updateId;
            Pair pair = (Pair)item$iv$iv;
            Collection collection2 = collection;
            boolean bl = false;
            int pluginId = ((Number)$dstr$pluginId$updateId.component1()).intValue();
            int updateId = ((Number)$dstr$pluginId$updateId.component2()).intValue();
            collection2.add(this.service.getIntelliJUpdateMeta(pluginId, updateId));
        }
        List calls = (List)collection;
        Collection responses = RequestHelperKt.executeExceptionallyBatch(calls).values();
        HashMap result = new HashMap();
        for (Response response : responses) {
            IntellijUpdateMetadata metadata;
            if (!response.isSuccessful() || (metadata = (IntellijUpdateMetadata)response.body()) == null) continue;
            Map map = result;
            Integer n = metadata.getId();
            map.put(n, metadata);
        }
        return result;
    }
}

