/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.pluginRepository.internal.api;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Cache;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.pluginRepository.PluginDownloader;
import org.jetbrains.intellij.pluginRepository.PluginManager;
import org.jetbrains.intellij.pluginRepository.PluginRepository;
import org.jetbrains.intellij.pluginRepository.PluginUpdateManager;
import org.jetbrains.intellij.pluginRepository.PluginUploader;
import org.jetbrains.intellij.pluginRepository.internal.Messages;
import org.jetbrains.intellij.pluginRepository.internal.api.PluginRepositoryService;
import org.jetbrains.intellij.pluginRepository.internal.instances.PluginDownloaderInstance;
import org.jetbrains.intellij.pluginRepository.internal.instances.PluginManagerInstance;
import org.jetbrains.intellij.pluginRepository.internal.instances.PluginUpdateManagerInstance;
import org.jetbrains.intellij.pluginRepository.internal.instances.PluginUploaderInstance;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;
import retrofit2.converter.jaxb.JaxbConverterFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001(B/\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0002\u0010\nJ\b\u0010&\u001a\u00020'H\u0002R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0018\u0010 \u001a\n \u0013*\u0004\u0018\u00018\u00008\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010!R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006)"}, d2={"Lorg/jetbrains/intellij/pluginRepository/internal/api/PluginRepositoryInstance;", "T", "Lorg/jetbrains/intellij/pluginRepository/internal/api/PluginRepositoryService;", "Lorg/jetbrains/intellij/pluginRepository/PluginRepository;", "siteUrl", "", "token", "authScheme", "serviceClass", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Class;)V", "dispatcher", "Lokhttp3/Dispatcher;", "downloader", "Lorg/jetbrains/intellij/pluginRepository/PluginDownloader;", "getDownloader", "()Lorg/jetbrains/intellij/pluginRepository/PluginDownloader;", "executorService", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "maxParallelConnection", "", "okHttpClient", "Lokhttp3/OkHttpClient;", "pluginManager", "Lorg/jetbrains/intellij/pluginRepository/PluginManager;", "getPluginManager", "()Lorg/jetbrains/intellij/pluginRepository/PluginManager;", "pluginUpdateManager", "Lorg/jetbrains/intellij/pluginRepository/PluginUpdateManager;", "getPluginUpdateManager", "()Lorg/jetbrains/intellij/pluginRepository/PluginUpdateManager;", "service", "Lorg/jetbrains/intellij/pluginRepository/internal/api/PluginRepositoryService;", "uploader", "Lorg/jetbrains/intellij/pluginRepository/PluginUploader;", "getUploader", "()Lorg/jetbrains/intellij/pluginRepository/PluginUploader;", "ensureCredentialsAreSet", "", "DaemonThreadFactory", "rest"})
public final class PluginRepositoryInstance<T extends PluginRepositoryService>
implements PluginRepository {
    @Nullable
    private final String token;
    @NotNull
    private final String authScheme;
    private final int maxParallelConnection;
    private final ExecutorService executorService;
    @NotNull
    private final Dispatcher dispatcher;
    @NotNull
    private final OkHttpClient okHttpClient;
    private final T service;
    @NotNull
    private final PluginDownloader downloader;
    @NotNull
    private final PluginManager pluginManager;
    @NotNull
    private final PluginUpdateManager pluginUpdateManager;

    /*
     * WARNING - void declaration
     */
    public PluginRepositoryInstance(@NotNull String siteUrl, @Nullable String token, @NotNull String authScheme, @NotNull Class<T> serviceClass) {
        void $this$dispatcher_u24lambda_u240;
        Dispatcher dispatcher;
        Intrinsics.checkNotNullParameter((Object)siteUrl, (String)"siteUrl");
        Intrinsics.checkNotNullParameter((Object)authScheme, (String)"authScheme");
        Intrinsics.checkNotNullParameter(serviceClass, (String)"serviceClass");
        this.token = token;
        this.authScheme = authScheme;
        String string = System.getProperty("MARKETPLACE_MAX_PARALLEL_CONNECTIONS", "16");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"MARKETPLACE\u2026ALLEL_CONNECTIONS\", \"16\")");
        this.maxParallelConnection = Integer.parseInt(string);
        ExecutorService executorService = this.executorService = Executors.newFixedThreadPool(this.maxParallelConnection, new DaemonThreadFactory("retrofit-thread"));
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"executorService");
        Dispatcher dispatcher2 = dispatcher = new Dispatcher(executorService);
        PluginRepositoryInstance pluginRepositoryInstance = this;
        boolean bl = false;
        $this$dispatcher_u24lambda_u240.setMaxRequestsPerHost(this.maxParallelConnection);
        $this$dispatcher_u24lambda_u240.setMaxRequests(this.maxParallelConnection);
        pluginRepositoryInstance.dispatcher = dispatcher;
        this.okHttpClient = new OkHttpClient().newBuilder().dispatcher(this.dispatcher).connectTimeout(5L, TimeUnit.MINUTES).readTimeout(5L, TimeUnit.MINUTES).writeTimeout(5L, TimeUnit.MINUTES).addInterceptor(new Interceptor(this){
            final /* synthetic */ PluginRepositoryInstance<T> this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public Response intercept(@NotNull Interceptor.Chain chain) {
                Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
                Request request = PluginRepositoryInstance.access$getToken$p(this.this$0) != null ? chain.request().newBuilder().addHeader("Authorization", PluginRepositoryInstance.access$getAuthScheme$p(this.this$0) + " " + PluginRepositoryInstance.access$getToken$p(this.this$0)).build() : chain.request();
                return chain.proceed(request);
            }
        }).build();
        this.service = (PluginRepositoryService)new Retrofit.Builder().baseUrl(siteUrl).client(this.okHttpClient).addConverterFactory((Converter.Factory)JaxbConverterFactory.create()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)ExtensionsKt.jacksonObjectMapper().configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true))).build().create(serviceClass);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> PluginRepositoryInstance._init_$lambda$1(this)));
        T t = this.service;
        Intrinsics.checkNotNullExpressionValue(t, (String)"service");
        this.downloader = new PluginDownloaderInstance((PluginRepositoryService)t);
        T t2 = this.service;
        Intrinsics.checkNotNullExpressionValue(t2, (String)"service");
        this.pluginManager = new PluginManagerInstance((PluginRepositoryService)t2);
        T t3 = this.service;
        Intrinsics.checkNotNullExpressionValue(t3, (String)"service");
        this.pluginUpdateManager = new PluginUpdateManagerInstance((PluginRepositoryService)t3);
    }

    public /* synthetic */ PluginRepositoryInstance(String string, String string2, String string3, Class clazz, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        this(string, string2, string3, clazz);
    }

    @Override
    @NotNull
    public PluginDownloader getDownloader() {
        return this.downloader;
    }

    @Override
    @NotNull
    public PluginUploader getUploader() {
        this.ensureCredentialsAreSet();
        T t = this.service;
        Intrinsics.checkNotNullExpressionValue(t, (String)"service");
        return new PluginUploaderInstance((PluginRepositoryService)t);
    }

    @Override
    @NotNull
    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    @Override
    @NotNull
    public PluginUpdateManager getPluginUpdateManager() {
        return this.pluginUpdateManager;
    }

    private final void ensureCredentialsAreSet() {
        if (this.token == null) {
            throw new RuntimeException(Messages.INSTANCE.getMessage("missing.token", new Object[0]));
        }
    }

    private static final void _init_$lambda$1(PluginRepositoryInstance this$0) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this$0.dispatcher.executorService().shutdownNow();
            this$0.okHttpClient.connectionPool().evictAll();
            Cache cache = this$0.okHttpClient.cache();
            if (cache == null) break block0;
            cache.close();
        }
    }

    public static final /* synthetic */ String access$getToken$p(PluginRepositoryInstance $this) {
        return $this.token;
    }

    public static final /* synthetic */ String access$getAuthScheme$p(PluginRepositoryInstance $this) {
        return $this.authScheme;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0016\u0010\u0005\u001a\n \u0006*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/intellij/pluginRepository/internal/api/PluginRepositoryInstance$DaemonThreadFactory;", "Ljava/util/concurrent/ThreadFactory;", "threadNamePrefix", "", "(Ljava/lang/String;)V", "defaultThreadFactory", "kotlin.jvm.PlatformType", "nameCount", "Ljava/util/concurrent/atomic/AtomicLong;", "newThread", "Ljava/lang/Thread;", "r", "Ljava/lang/Runnable;", "rest"})
    private static final class DaemonThreadFactory
    implements ThreadFactory {
        @NotNull
        private final String threadNamePrefix;
        private final ThreadFactory defaultThreadFactory;
        @NotNull
        private final AtomicLong nameCount;

        public DaemonThreadFactory(@NotNull String threadNamePrefix) {
            Intrinsics.checkNotNullParameter((Object)threadNamePrefix, (String)"threadNamePrefix");
            this.threadNamePrefix = threadNamePrefix;
            this.defaultThreadFactory = Executors.defaultThreadFactory();
            this.nameCount = new AtomicLong();
        }

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            Thread thread;
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            Thread $this$newThread_u24lambda_u240 = thread = this.defaultThreadFactory.newThread(r);
            boolean bl = false;
            $this$newThread_u24lambda_u240.setName(this.threadNamePrefix + "-" + this.nameCount.getAndIncrement());
            $this$newThread_u24lambda_u240.setDaemon(true);
            Thread thread2 = thread;
            Intrinsics.checkNotNullExpressionValue((Object)thread2, (String)"defaultThreadFactory.new\u2026    isDaemon = true\n    }");
            return thread2;
        }
    }
}

