/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.pluginRepository.internal.instances;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.pluginRepository.PluginManager;
import org.jetbrains.intellij.pluginRepository.internal.api.PluginRepositoryService;
import org.jetbrains.intellij.pluginRepository.internal.api.PluginUpdateVersion;
import org.jetbrains.intellij.pluginRepository.internal.api.XmlCategoryBean;
import org.jetbrains.intellij.pluginRepository.internal.api.XmlPluginRepositoryBean;
import org.jetbrains.intellij.pluginRepository.internal.utils.CompatibleUpdateRequest;
import org.jetbrains.intellij.pluginRepository.internal.utils.RequestHelperKt;
import org.jetbrains.intellij.pluginRepository.internal.utils.XmlToPluginBeanConverterKt;
import org.jetbrains.intellij.pluginRepository.model.PluginBean;
import org.jetbrains.intellij.pluginRepository.model.PluginUserBean;
import org.jetbrains.intellij.pluginRepository.model.PluginXmlBean;
import org.jetbrains.intellij.pluginRepository.model.ProductEnum;
import org.jetbrains.intellij.pluginRepository.model.ProductFamily;
import org.jetbrains.intellij.pluginRepository.model.UpdateBean;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J.\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0007H\u0016J\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\u0010\u0010\u001a\u00060\u000bj\u0002`\u0011H\u0016J\u001e\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\n\u0010\u0013\u001a\u00060\u0007j\u0002`\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\n\u0010\u0010\u001a\u00060\u000bj\u0002`\u0011H\u0016J\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00062\n\u0010\u0010\u001a\u00060\u000bj\u0002`\u0011H\u0016J\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00062\n\u0010\u0010\u001a\u00060\u000bj\u0002`\u0011H\u0016J\"\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00062\u0006\u0010\t\u001a\u00020\u00072\n\u0010\u0013\u001a\u00060\u0007j\u0002`\u0014H\u0016J\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00062\n\u0010\u0010\u001a\u00060\u000bj\u0002`\u0011H\u0016J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"H\u0016J0\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00062\u0006\u0010%\u001a\u00020\u00072\b\u0010&\u001a\u0004\u0018\u00010\u00072\u000e\u0010'\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\u0014H\u0016J8\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00062\u0010\u0010)\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\u00140\u00062\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/intellij/pluginRepository/internal/instances/PluginManagerInstance;", "Lorg/jetbrains/intellij/pluginRepository/PluginManager;", "service", "Lorg/jetbrains/intellij/pluginRepository/internal/api/PluginRepositoryService;", "(Lorg/jetbrains/intellij/pluginRepository/internal/api/PluginRepositoryService;)V", "getAllPluginsIds", "", "", "getCompatiblePluginsXmlIds", "build", "max", "", "offset", "query", "getPlugin", "Lorg/jetbrains/intellij/pluginRepository/model/PluginBean;", "id", "Lorg/jetbrains/intellij/pluginRepository/model/PluginId;", "getPluginByXmlId", "xmlId", "Lorg/jetbrains/intellij/pluginRepository/model/StringPluginId;", "family", "Lorg/jetbrains/intellij/pluginRepository/model/ProductFamily;", "getPluginChannels", "getPluginCompatibleProducts", "Lorg/jetbrains/intellij/pluginRepository/model/ProductEnum;", "getPluginDevelopers", "Lorg/jetbrains/intellij/pluginRepository/model/PluginUserBean;", "getPluginLastCompatibleUpdates", "Lorg/jetbrains/intellij/pluginRepository/model/UpdateBean;", "getPluginVersions", "getPluginXmlIdByDependency", "dependency", "includeOptional", "", "listPlugins", "Lorg/jetbrains/intellij/pluginRepository/model/PluginXmlBean;", "ideBuild", "channel", "pluginId", "searchCompatibleUpdates", "xmlIds", "module", "rest"})
@SourceDebugExtension(value={"SMAP\nPluginManagerInstance.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginManagerInstance.kt\norg/jetbrains/intellij/pluginRepository/internal/instances/PluginManagerInstance\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n1360#2:58\n1446#2,5:59\n1549#2:64\n1620#2,3:65\n*S KotlinDebug\n*F\n+ 1 PluginManagerInstance.kt\norg/jetbrains/intellij/pluginRepository/internal/instances/PluginManagerInstance\n*L\n14#1:58\n14#1:59,5\n39#1:64\n39#1:65,3\n*E\n"})
public final class PluginManagerInstance
implements PluginManager {
    @NotNull
    private final PluginRepositoryService service;

    public PluginManagerInstance(@NotNull PluginRepositoryService service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        this.service = service;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<PluginXmlBean> listPlugins(@NotNull String ideBuild, @Nullable String channel, @Nullable String pluginId) {
        List list;
        Intrinsics.checkNotNullParameter((Object)ideBuild, (String)"ideBuild");
        XmlPluginRepositoryBean response = RequestHelperKt.executeAndParseBody(this.service.listPlugins(ideBuild, channel, pluginId), true);
        Object object = response;
        if (object != null && (object = ((XmlPluginRepositoryBean)object).getCategories()) != null) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = (Iterable)object;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                XmlCategoryBean it = (XmlCategoryBean)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = XmlToPluginBeanConverterKt.convertCategory(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> getCompatiblePluginsXmlIds(@NotNull String build, int max, int offset, @NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)build, (String)"build");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        List list = (List)RequestHelperKt.executeAndParseBody$default(this.service.searchPluginsXmlIds(build, max, offset, query), false, 2, null);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<UpdateBean> getPluginLastCompatibleUpdates(@NotNull String build, @NotNull String xmlId) {
        Intrinsics.checkNotNullParameter((Object)build, (String)"build");
        Intrinsics.checkNotNullParameter((Object)xmlId, (String)"xmlId");
        List list = (List)RequestHelperKt.executeAndParseBody$default(this.service.searchUpdates(build, xmlId), false, 2, null);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> getAllPluginsIds() {
        List list = (List)RequestHelperKt.executeAndParseBody$default(this.service.getPluginsXmlIds(), false, 2, null);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<UpdateBean> searchCompatibleUpdates(@NotNull List<String> xmlIds, @NotNull String build, @NotNull String channel, @NotNull String module) {
        Intrinsics.checkNotNullParameter(xmlIds, (String)"xmlIds");
        Intrinsics.checkNotNullParameter((Object)build, (String)"build");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        List list = (List)RequestHelperKt.executeAndParseBody$default(this.service.searchLastCompatibleUpdate(new CompatibleUpdateRequest(xmlIds, build, channel, module)), false, 2, null);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @Nullable
    public PluginBean getPluginByXmlId(@NotNull String xmlId, @NotNull ProductFamily family) {
        Intrinsics.checkNotNullParameter((Object)xmlId, (String)"xmlId");
        Intrinsics.checkNotNullParameter((Object)((Object)family), (String)"family");
        return RequestHelperKt.executeAndParseBody(this.service.getPluginByXmlId(family.getId(), xmlId), true);
    }

    @Override
    @Nullable
    public PluginBean getPlugin(int id) {
        return RequestHelperKt.executeAndParseBody(this.service.getPluginById(id), true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<UpdateBean> getPluginVersions(int id) {
        void $this$mapTo$iv$iv;
        PluginBean pluginBean = RequestHelperKt.executeAndParseBody(this.service.getPluginById(id), true);
        if (pluginBean == null) {
            return CollectionsKt.emptyList();
        }
        PluginBean pluginBean2 = pluginBean;
        List list = RequestHelperKt.executeAndParseBody(this.service.getPluginVersions(id), true);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PluginUpdateVersion pluginUpdateVersion = (PluginUpdateVersion)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new UpdateBean(it.getId(), pluginBean2.getId(), pluginBean2.getXmlId(), it.getVersion(), it.getChannel()));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public List<PluginUserBean> getPluginDevelopers(int id) {
        List list = RequestHelperKt.executeAndParseBody(this.service.getPluginDevelopers(id), true);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> getPluginChannels(int id) {
        List list = RequestHelperKt.executeAndParseBody(this.service.getPluginChannels(id), true);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<ProductEnum> getPluginCompatibleProducts(int id) {
        List list = RequestHelperKt.executeAndParseBody(this.service.getPluginCompatibleProducts(id), true);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> getPluginXmlIdByDependency(@NotNull String dependency, boolean includeOptional) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        List list = RequestHelperKt.executeAndParseBody(this.service.getPluginXmlIdByDependency(dependency, includeOptional), true);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

