/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.blockmap.core;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0019\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/plugin/blockmap/core/FileHash;", "", "source", "Ljava/io/InputStream;", "algorithm", "", "(Ljava/io/InputStream;Ljava/lang/String;)V", "hash", "(Ljava/lang/String;Ljava/lang/String;)V", "getAlgorithm", "()Ljava/lang/String;", "getHash", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "blockmap"})
public final class FileHash {
    @NotNull
    private final String hash;
    @NotNull
    private final String algorithm;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getHash() {
        return this.hash;
    }

    @NotNull
    public final String getAlgorithm() {
        return this.algorithm;
    }

    public FileHash(@NotNull String hash, @NotNull String algorithm) {
        Intrinsics.checkNotNullParameter(hash, "hash");
        Intrinsics.checkNotNullParameter(algorithm, "algorithm");
        this.hash = hash;
        this.algorithm = algorithm;
    }

    public /* synthetic */ FileHash(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        this(string, string2);
    }

    public FileHash() {
        this((String)null, (String)null, 3, (DefaultConstructorMarker)null);
    }

    public FileHash(@NotNull InputStream source2, @NotNull String algorithm) {
        Intrinsics.checkNotNullParameter(source2, "source");
        Intrinsics.checkNotNullParameter(algorithm, "algorithm");
        this(Companion.makeFileHash(source2, algorithm), algorithm);
    }

    public /* synthetic */ FileHash(InputStream inputStream2, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "SHA-256";
        }
        this(inputStream2, string);
    }

    @NotNull
    public final String component1() {
        return this.hash;
    }

    @NotNull
    public final String component2() {
        return this.algorithm;
    }

    @NotNull
    public final FileHash copy(@NotNull String hash, @NotNull String algorithm) {
        Intrinsics.checkNotNullParameter(hash, "hash");
        Intrinsics.checkNotNullParameter(algorithm, "algorithm");
        return new FileHash(hash, algorithm);
    }

    public static /* synthetic */ FileHash copy$default(FileHash fileHash, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = fileHash.hash;
        }
        if ((n & 2) != 0) {
            string2 = fileHash.algorithm;
        }
        return fileHash.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "FileHash(hash=" + this.hash + ", algorithm=" + this.algorithm + ")";
    }

    public int hashCode() {
        String string = this.hash;
        String string2 = this.algorithm;
        return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof FileHash)) break block3;
                FileHash fileHash = (FileHash)object;
                if (!Intrinsics.areEqual(this.hash, fileHash.hash) || !Intrinsics.areEqual(this.algorithm, fileHash.algorithm)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004\u00a8\u0006\b"}, d2={"Lcom/jetbrains/plugin/blockmap/core/FileHash$Companion;", "", "()V", "makeFileHash", "", "source", "Ljava/io/InputStream;", "algorithm", "blockmap"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final String makeFileHash(@NotNull InputStream source2, @NotNull String algorithm) {
            Intrinsics.checkNotNullParameter(source2, "source");
            Intrinsics.checkNotNullParameter(algorithm, "algorithm");
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            Closeable closeable = source2;
            int n = 8192;
            boolean bl = false;
            closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
            n = 0;
            bl = false;
            Throwable throwable = null;
            try {
                BufferedInputStream input = (BufferedInputStream)closeable;
                boolean bl2 = false;
                Closeable closeable2 = new DigestInputStream(input, digest);
                boolean bl3 = false;
                boolean bl4 = false;
                Throwable throwable2 = null;
                try {
                    DigestInputStream digestInputStream = (DigestInputStream)closeable2;
                    boolean bl5 = false;
                    byte[] buffer = new byte[8192];
                    while (digestInputStream.read(buffer) != -1) {
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally(closeable2, throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            String string = Base64.getEncoder().encodeToString(digest.digest());
            Intrinsics.checkNotNullExpressionValue(string, "Base64.getEncoder().enco\u2026ToString(digest.digest())");
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

