/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.converter.jaxb;

import java.io.IOException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import okhttp3.ResponseBody;
import retrofit2.Converter;

final class JaxbResponseConverter<T>
implements Converter<ResponseBody, T> {
    final XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
    final JAXBContext context;
    final Class<T> type;

    JaxbResponseConverter(JAXBContext context, Class<T> type2) {
        this.context = context;
        this.type = type2;
        this.xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        this.xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
    }

    @Override
    public T convert(ResponseBody value) throws IOException {
        try {
            Unmarshaller unmarshaller = this.context.createUnmarshaller();
            XMLStreamReader streamReader = this.xmlInputFactory.createXMLStreamReader(value.charStream());
            T t = unmarshaller.unmarshal(streamReader, this.type).getValue();
            return t;
        }
        catch (JAXBException | XMLStreamException e) {
            throw new RuntimeException(e);
        }
        finally {
            value.close();
        }
    }
}

