/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.kotlin;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.fasterxml.jackson.module.kotlin.SequenceSerializer;
import com.fasterxml.jackson.module.kotlin.UByteSerializer;
import com.fasterxml.jackson.module.kotlin.UIntSerializer;
import com.fasterxml.jackson.module.kotlin.ULongSerializer;
import com.fasterxml.jackson.module.kotlin.UShortSerializer;
import com.fasterxml.jackson.module.kotlin.ValueClassSerializer;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/fasterxml/jackson/module/kotlin/KotlinSerializers;", "Lcom/fasterxml/jackson/databind/ser/Serializers$Base;", "()V", "findSerializer", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "config", "Lcom/fasterxml/jackson/databind/SerializationConfig;", "type", "Lcom/fasterxml/jackson/databind/JavaType;", "beanDesc", "Lcom/fasterxml/jackson/databind/BeanDescription;", "jackson-module-kotlin"})
public final class KotlinSerializers
extends Serializers.Base {
    @Override
    @Nullable
    public JsonSerializer<?> findSerializer(@Nullable SerializationConfig config, @NotNull JavaType type, @Nullable BeanDescription beanDesc) {
        JsonSerializer jsonSerializer;
        Intrinsics.checkNotNullParameter(type, "type");
        Class<?> rawClass = type.getRawClass();
        if (Sequence.class.isAssignableFrom(rawClass)) {
            jsonSerializer = SequenceSerializer.INSTANCE;
        } else if (UByte.class.isAssignableFrom(rawClass)) {
            jsonSerializer = UByteSerializer.INSTANCE;
        } else if (UShort.class.isAssignableFrom(rawClass)) {
            jsonSerializer = UShortSerializer.INSTANCE;
        } else if (UInt.class.isAssignableFrom(rawClass)) {
            jsonSerializer = UIntSerializer.INSTANCE;
        } else if (ULong.class.isAssignableFrom(rawClass)) {
            jsonSerializer = ULongSerializer.INSTANCE;
        } else {
            Intrinsics.checkNotNullExpressionValue(rawClass, "rawClass");
            jsonSerializer = ExtensionsKt.isUnboxableValueClass(rawClass) ? (JsonSerializer)ValueClassSerializer.Companion.from(rawClass) : null;
        }
        return jsonSerializer;
    }
}

