/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.pluginRepository;

import com.sampullara.cli.Args;
import com.sampullara.cli.Argument;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.pluginRepository.PluginDownloader;
import org.jetbrains.intellij.pluginRepository.PluginManager;
import org.jetbrains.intellij.pluginRepository.PluginRepositoryFactory;
import org.jetbrains.intellij.pluginRepository.PluginUploader;
import org.jetbrains.intellij.pluginRepository.model.LicenseUrl;
import org.jetbrains.intellij.pluginRepository.model.PluginBean;
import org.jetbrains.intellij.pluginRepository.model.PluginVendorBean;
import org.jetbrains.intellij.pluginRepository.model.ProductFamily;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\u0018\u0000 \u00042\u00020\u0001:\u0006\u0003\u0004\u0005\u0006\u0007\bB\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/intellij/pluginRepository/Client;", "", "()V", "BaseOptions", "Companion", "DownloadOptions", "InfoOptions", "ListOptions", "UploadOptions", "cli"})
public final class Client {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    public static final void main(@NotNull String[] args2) {
        Companion.main(args2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R(\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR$\u0010\n\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lorg/jetbrains/intellij/pluginRepository/Client$BaseOptions;", "", "()V", "<set-?>", "", "channel", "getChannel", "()Ljava/lang/String;", "setChannel", "(Ljava/lang/String;)V", "host", "getHost", "setHost", "cli"})
    public static class BaseOptions {
        @NotNull
        private String host = "https://plugins.jetbrains.com";
        @Nullable
        private String channel;

        @NotNull
        public final String getHost() {
            return this.host;
        }

        @Argument(description="Plugins repository host")
        public final void setHost(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.host = string;
        }

        @Nullable
        public final String getChannel() {
            return this.channel;
        }

        @Argument(description="Plugin channel")
        public final void setChannel(@Nullable String string) {
            this.channel = string;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0002\u0010\bJ\u001b\u0010\t\u001a\u00020\n2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0002\u0010\u000bJ\u001b\u0010\f\u001a\u00020\n2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\r\u001a\u0004\u0018\u00010\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u0007H\u0002J\u001b\u0010\u000f\u001a\u00020\n2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/intellij/pluginRepository/Client$Companion;", "", "()V", "download", "Ljava/io/File;", "args", "", "", "([Ljava/lang/String;)Ljava/io/File;", "info", "", "([Ljava/lang/String;)V", "main", "parseChannel", "channel", "upload", "cli"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args2) {
            Intrinsics.checkNotNullParameter(args2, "args");
            if (args2.length == 0) {
                System.err.println("Command is not specified: `upload`, `download`, `list` or `info` commands are supported.");
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            String command = args2[0];
            Object object = args2;
            int n = 1;
            int n2 = args2.length;
            String[] restParameters = ArraysKt.copyOfRange(object, n, n2);
            switch (command) {
                case "upload": {
                    this.upload(restParameters);
                    break;
                }
                case "download": {
                    System.exit(this.download(restParameters) != null ? 0 : 1);
                    throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                }
                case "info": {
                    this.info(restParameters);
                    break;
                }
                default: {
                    System.err.println("Unknown command `" + command + "`: `upload`, `download`, `list` or `info` commands are supported.");
                    System.exit(1);
                    throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                }
            }
        }

        private final File download(String[] args2) {
            File file;
            DownloadOptions options2 = new DownloadOptions();
            Args.parseOrExit(options2, args2);
            CharSequence charSequence = options2.getVersion();
            if ((charSequence == null || StringsKt.isBlank(charSequence)) && ((charSequence = (CharSequence)options2.getIdeBuild()) == null || StringsKt.isBlank(charSequence))) {
                System.err.print("`version` or `ide-build` must be specified");
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            PluginDownloader pluginRepository = PluginRepositoryFactory.create$default(options2.getHost(), null, null, 6, null).getDownloader();
            String channel = this.parseChannel(options2.getChannel());
            CharSequence charSequence2 = options2.getVersion();
            if (!(charSequence2 == null || StringsKt.isBlank(charSequence2))) {
                if (StringsKt.isBlank(options2.getOldFile())) {
                    String string = options2.getPluginId();
                    Intrinsics.checkNotNull(string);
                    String string2 = options2.getVersion();
                    Intrinsics.checkNotNull(string2);
                    file = pluginRepository.download(string, string2, new File(options2.getDestination()), channel);
                } else {
                    String string = options2.getPluginId();
                    Intrinsics.checkNotNull(string);
                    String string3 = options2.getVersion();
                    Intrinsics.checkNotNull(string3);
                    file = pluginRepository.downloadViaBlockMap(string, string3, new File(options2.getDestination()), new File(options2.getOldFile()), channel);
                }
            } else if (StringsKt.isBlank(options2.getOldFile())) {
                String string = options2.getPluginId();
                Intrinsics.checkNotNull(string);
                String string4 = options2.getIdeBuild();
                Intrinsics.checkNotNull(string4);
                file = pluginRepository.downloadLatestCompatiblePlugin(string, string4, new File(options2.getDestination()), channel);
            } else {
                String string = options2.getPluginId();
                Intrinsics.checkNotNull(string);
                String string5 = options2.getIdeBuild();
                Intrinsics.checkNotNull(string5);
                file = pluginRepository.downloadLatestCompatiblePluginViaBlockMap(string, string5, new File(options2.getDestination()), new File(options2.getOldFile()), channel);
            }
            return file;
        }

        private final void upload(String[] args2) {
            UploadOptions options2 = new UploadOptions();
            Args.parseOrExit(options2, args2);
            PluginUploader pluginRepository = PluginRepositoryFactory.create$default(options2.getHost(), options2.getToken(), null, 4, null).getUploader();
            String pluginId = options2.getPluginId();
            if (pluginId == null) {
                String string = options2.getPluginPath();
                Intrinsics.checkNotNull(string);
                File file = new File(string);
                List<String> list = ArraysKt.toList(options2.getTags());
                LicenseUrl licenseUrl = LicenseUrl.Companion.fromString(options2.getLicenseUrl());
                ProductFamily productFamily = options2.getFamily();
                Intrinsics.checkNotNull((Object)productFamily);
                pluginRepository.uploadNewPlugin(file, list, licenseUrl, productFamily, options2.getVendor(), this.parseChannel(options2.getChannel()), options2.isHidden());
            } else {
                CharSequence charSequence = pluginId;
                if (new Regex("\\d+").matches(charSequence)) {
                    int n = Integer.parseInt(pluginId);
                    String string = options2.getPluginPath();
                    Intrinsics.checkNotNull(string);
                    pluginRepository.upload(n, new File(string), this.parseChannel(options2.getChannel()), options2.getNotes(), options2.isHidden());
                } else {
                    String string = options2.getPluginPath();
                    Intrinsics.checkNotNull(string);
                    pluginRepository.upload(pluginId, new File(string), this.parseChannel(options2.getChannel()), options2.getNotes(), options2.isHidden());
                }
            }
        }

        private final void info(String[] args2) {
            InfoOptions options2 = new InfoOptions();
            Args.parseOrExit(options2, args2);
            PluginManager pluginRepository = PluginRepositoryFactory.create$default(options2.getHost(), null, null, 6, null).getPluginManager();
            String string = options2.getPluginId();
            Intrinsics.checkNotNull(string);
            ProductFamily productFamily = options2.getFamily();
            Intrinsics.checkNotNull((Object)productFamily);
            PluginBean plugin = pluginRepository.getPluginByXmlId(string, productFamily);
            if (plugin != null) {
                PluginVendorBean pluginVendorBean = plugin.getVendor();
                System.out.println((Object)(plugin.getName() + " " + plugin.getId() + " made by " + (pluginVendorBean != null ? pluginVendorBean.getName() : null)));
            } else {
                System.out.println((Object)"Plugin is not found!");
            }
        }

        private final String parseChannel(String channel) {
            CharSequence charSequence = channel;
            return !(charSequence == null || charSequence.length() == 0) && !Intrinsics.areEqual(channel, "_default_") ? channel : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR(\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR$\u0010\r\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR(\u0010\u0010\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR(\u0010\u0013\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0007\"\u0004\b\u0015\u0010\t\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/intellij/pluginRepository/Client$DownloadOptions;", "Lorg/jetbrains/intellij/pluginRepository/Client$BaseOptions;", "()V", "<set-?>", "", "destination", "getDestination", "()Ljava/lang/String;", "setDestination", "(Ljava/lang/String;)V", "ideBuild", "getIdeBuild", "setIdeBuild", "oldFile", "getOldFile", "setOldFile", "pluginId", "getPluginId", "setPluginId", "version", "getVersion", "setVersion", "cli"})
    public static final class DownloadOptions
    extends BaseOptions {
        @Nullable
        private String pluginId;
        @Nullable
        private String version;
        @Nullable
        private String ideBuild;
        @NotNull
        private String oldFile = "";
        @NotNull
        private String destination = ".";

        @Nullable
        public final String getPluginId() {
            return this.pluginId;
        }

        @Argument(value="plugin", required=true, description="Plugin ID defined in plugin.xml")
        public final void setPluginId(@Nullable String string) {
            this.pluginId = string;
        }

        @Nullable
        public final String getVersion() {
            return this.version;
        }

        @Argument(value="version", description="Plugin version to download")
        public final void setVersion(@Nullable String string) {
            this.version = string;
        }

        @Nullable
        public final String getIdeBuild() {
            return this.ideBuild;
        }

        @Argument(value="ide-build", description="IDE build number with product code to download plugin compatible with (e.g. IC-145.184)")
        public final void setIdeBuild(@Nullable String string) {
            this.ideBuild = string;
        }

        @NotNull
        public final String getOldFile() {
            return this.oldFile;
        }

        @Argument(value="prev", description="Previous plugin's version archive file path")
        public final void setOldFile(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.oldFile = string;
        }

        @NotNull
        public final String getDestination() {
            return this.destination;
        }

        @Argument(value="to", description="Target filepath")
        public final void setDestination(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.destination = string;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R(\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR(\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\u0003\u001a\u0004\u0018\u00010\n@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/intellij/pluginRepository/Client$InfoOptions;", "Lorg/jetbrains/intellij/pluginRepository/Client$BaseOptions;", "()V", "<set-?>", "Lorg/jetbrains/intellij/pluginRepository/model/ProductFamily;", "family", "getFamily", "()Lorg/jetbrains/intellij/pluginRepository/model/ProductFamily;", "setFamily", "(Lorg/jetbrains/intellij/pluginRepository/model/ProductFamily;)V", "", "pluginId", "getPluginId", "()Ljava/lang/String;", "setPluginId", "(Ljava/lang/String;)V", "cli"})
    public static final class InfoOptions
    extends BaseOptions {
        @Nullable
        private String pluginId;
        @Nullable
        private ProductFamily family = ProductFamily.INTELLIJ;

        @Nullable
        public final String getPluginId() {
            return this.pluginId;
        }

        @Argument(value="plugin", required=true, description="Plugin ID defined in plugin.xml")
        public final void setPluginId(@Nullable String string) {
            this.pluginId = string;
        }

        @Nullable
        public final ProductFamily getFamily() {
            return this.family;
        }

        @Argument(value="family", description="Plugin's family")
        public final void setFamily(@Nullable ProductFamily productFamily) {
            this.family = productFamily;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R(\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR(\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lorg/jetbrains/intellij/pluginRepository/Client$ListOptions;", "Lorg/jetbrains/intellij/pluginRepository/Client$BaseOptions;", "()V", "<set-?>", "", "ideBuild", "getIdeBuild", "()Ljava/lang/String;", "setIdeBuild", "(Ljava/lang/String;)V", "pluginId", "getPluginId", "setPluginId", "cli"})
    public static final class ListOptions
    extends BaseOptions {
        @Nullable
        private String ideBuild;
        @Nullable
        private String pluginId;

        @Nullable
        public final String getIdeBuild() {
            return this.ideBuild;
        }

        @Argument(value="ide-build", required=true, description="IDE build number with product code to list plugins compatible with (e.g. IC-145.184)")
        public final void setIdeBuild(@Nullable String string) {
            this.ideBuild = string;
        }

        @Nullable
        public final String getPluginId() {
            return this.pluginId;
        }

        @Argument(value="plugin", description="Plugin ID defined in plugin.xml")
        public final void setPluginId(@Nullable String string) {
            this.pluginId = string;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u0011\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R(\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR$\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\n@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u000f@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R(\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0003\u001a\u0004\u0018\u00010\u000f@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R(\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0003\u001a\u0004\u0018\u00010\u000f@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R(\u0010\u001b\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0003\u001a\u0004\u0018\u00010\u000f@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0012\"\u0004\b\u001d\u0010\u0014R2\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001e2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001e@GX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010$\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R(\u0010%\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0003\u001a\u0004\u0018\u00010\u000f@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0012\"\u0004\b'\u0010\u0014R(\u0010(\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0003\u001a\u0004\u0018\u00010\u000f@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0012\"\u0004\b*\u0010\u0014\u00a8\u0006+"}, d2={"Lorg/jetbrains/intellij/pluginRepository/Client$UploadOptions;", "Lorg/jetbrains/intellij/pluginRepository/Client$BaseOptions;", "()V", "<set-?>", "Lorg/jetbrains/intellij/pluginRepository/model/ProductFamily;", "family", "getFamily", "()Lorg/jetbrains/intellij/pluginRepository/model/ProductFamily;", "setFamily", "(Lorg/jetbrains/intellij/pluginRepository/model/ProductFamily;)V", "", "isHidden", "()Z", "setHidden", "(Z)V", "", "licenseUrl", "getLicenseUrl", "()Ljava/lang/String;", "setLicenseUrl", "(Ljava/lang/String;)V", "notes", "getNotes", "setNotes", "pluginId", "getPluginId", "setPluginId", "pluginPath", "getPluginPath", "setPluginPath", "", "tags", "getTags", "()[Ljava/lang/String;", "setTags", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "token", "getToken", "setToken", "vendor", "getVendor", "setVendor", "cli"})
    @SourceDebugExtension(value={"SMAP\nclient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 client.kt\norg/jetbrains/intellij/pluginRepository/Client$UploadOptions\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,170:1\n26#2:171\n*S KotlinDebug\n*F\n+ 1 client.kt\norg/jetbrains/intellij/pluginRepository/Client$UploadOptions\n*L\n114#1:171\n*E\n"})
    public static final class UploadOptions
    extends BaseOptions {
        @Nullable
        private String pluginId;
        @Nullable
        private String token;
        @Nullable
        private String pluginPath;
        @NotNull
        private String licenseUrl = "";
        @NotNull
        private String[] tags;
        @Nullable
        private ProductFamily family;
        @Nullable
        private String notes;
        @Nullable
        private String vendor;
        private boolean isHidden;

        public UploadOptions() {
            boolean $i$f$emptyArray = false;
            this.tags = new String[0];
            this.family = ProductFamily.INTELLIJ;
        }

        @Nullable
        public final String getPluginId() {
            return this.pluginId;
        }

        @Argument(value="plugin", required=false, description="Plugin ID in the plugins repository or ID defined in plugin.xml")
        public final void setPluginId(@Nullable String string) {
            this.pluginId = string;
        }

        @Nullable
        public final String getToken() {
            return this.token;
        }

        @Argument(required=true, description="Hub permanent token")
        public final void setToken(@Nullable String string) {
            this.token = string;
        }

        @Nullable
        public final String getPluginPath() {
            return this.pluginPath;
        }

        @Argument(value="file", required=true, description="Path to plugin zip/jar file")
        public final void setPluginPath(@Nullable String string) {
            this.pluginPath = string;
        }

        @NotNull
        public final String getLicenseUrl() {
            return this.licenseUrl;
        }

        @Argument(value="license", description="Url to plugin license")
        public final void setLicenseUrl(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.licenseUrl = string;
        }

        @NotNull
        public final String[] getTags() {
            return this.tags;
        }

        @Argument(value="tags", description="Tags for the plugin")
        public final void setTags(@NotNull String[] stringArray) {
            Intrinsics.checkNotNullParameter(stringArray, "<set-?>");
            this.tags = stringArray;
        }

        @Nullable
        public final ProductFamily getFamily() {
            return this.family;
        }

        @Argument(value="family", description="Plugin's family")
        public final void setFamily(@Nullable ProductFamily productFamily) {
            this.family = productFamily;
        }

        @Nullable
        public final String getNotes() {
            return this.notes;
        }

        @Argument(description="Change notes (may include HTML tags). The argument is ignored when uploading updates for IntelliJ-based IDEs")
        public final void setNotes(@Nullable String string) {
            this.notes = string;
        }

        @Nullable
        public final String getVendor() {
            return this.vendor;
        }

        @Argument(description="Id of vendor under which the new plugin should be uploaded")
        public final void setVendor(@Nullable String string) {
            this.vendor = string;
        }

        public final boolean isHidden() {
            return this.isHidden;
        }

        @Argument(value="isHidden", required=false, description="Should the new uploading plugin or update be hidden")
        public final void setHidden(boolean bl) {
            this.isHidden = bl;
        }
    }
}

