/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.pluginRepository.internal.instances;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.pluginRepository.PluginUploader;
import org.jetbrains.intellij.pluginRepository.internal.Messages;
import org.jetbrains.intellij.pluginRepository.internal.api.PluginRepositoryInstanceKt;
import org.jetbrains.intellij.pluginRepository.internal.api.PluginRepositoryService;
import org.jetbrains.intellij.pluginRepository.internal.utils.RequestHelperKt;
import org.jetbrains.intellij.pluginRepository.internal.utils.UploadPluginHelperKt;
import org.jetbrains.intellij.pluginRepository.model.LicenseUrl;
import org.jetbrains.intellij.pluginRepository.model.PluginBean;
import org.jetbrains.intellij.pluginRepository.model.PluginUpdateBean;
import org.jetbrains.intellij.pluginRepository.model.ProductFamily;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JJ\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001e\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0017H\u0002J8\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001c2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\f2\b\u0010\u001d\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J8\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\fj\u0002`\u001e2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\f2\b\u0010\u001d\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J@\u0010\u001f\u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\fj\u0002`\u001e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\f2\b\u0010\u001d\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/intellij/pluginRepository/internal/instances/PluginUploaderInstance;", "Lorg/jetbrains/intellij/pluginRepository/PluginUploader;", "service", "Lorg/jetbrains/intellij/pluginRepository/internal/api/PluginRepositoryService;", "<init>", "(Lorg/jetbrains/intellij/pluginRepository/internal/api/PluginRepositoryService;)V", "uploadNewPlugin", "Lorg/jetbrains/intellij/pluginRepository/model/PluginBean;", "file", "Ljava/io/File;", "tags", "", "", "licenseUrl", "Lorg/jetbrains/intellij/pluginRepository/model/LicenseUrl;", "family", "Lorg/jetbrains/intellij/pluginRepository/model/ProductFamily;", "vendor", "channel", "isHidden", "", "baseUploadPlugin", "block", "Lkotlin/Function0;", "upload", "Lorg/jetbrains/intellij/pluginRepository/model/PluginUpdateBean;", "id", "", "Lorg/jetbrains/intellij/pluginRepository/model/PluginId;", "notes", "Lorg/jetbrains/intellij/pluginRepository/model/StringPluginId;", "uploadUpdateByXmlIdAndFamily", "rest"})
@SourceDebugExtension(value={"SMAP\nPluginUploaderInstance.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginUploaderInstance.kt\norg/jetbrains/intellij/pluginRepository/internal/instances/PluginUploaderInstance\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n1#2:101\n1557#3:102\n1628#3,3:103\n*S KotlinDebug\n*F\n+ 1 PluginUploaderInstance.kt\norg/jetbrains/intellij/pluginRepository/internal/instances/PluginUploaderInstance\n*L\n29#1:102\n29#1:103,3\n*E\n"})
public final class PluginUploaderInstance
implements PluginUploader {
    @NotNull
    private final PluginRepositoryService service;

    public PluginUploaderInstance(@NotNull PluginRepositoryService service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        this.service = service;
    }

    @Override
    @NotNull
    public PluginBean uploadNewPlugin(@NotNull File file, @NotNull List<String> tags, @NotNull LicenseUrl licenseUrl, @NotNull ProductFamily family, @Nullable String vendor, @Nullable String channel, boolean isHidden) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        Intrinsics.checkNotNullParameter((Object)licenseUrl, (String)"licenseUrl");
        Intrinsics.checkNotNullParameter((Object)((Object)family), (String)"family");
        return this.baseUploadPlugin(file, (Function0<PluginBean>)((Function0)() -> PluginUploaderInstance.uploadNewPlugin$lambda$4(vendor, tags, licenseUrl, this, file, family, channel, isHidden)));
    }

    private final PluginBean baseUploadPlugin(File file, Function0<PluginBean> block) {
        PluginRepositoryInstanceKt.getLOG().info("Uploading new plugin from " + file.getAbsolutePath());
        PluginBean plugin = (PluginBean)block.invoke();
        PluginRepositoryInstanceKt.getLOG().info(plugin.getName() + " was successfully uploaded with id " + plugin.getId());
        return plugin;
    }

    @Override
    @NotNull
    public PluginUpdateBean upload(int id, @NotNull File file, @Nullable String channel, @Nullable String notes, boolean isHidden) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = channel;
        String string2 = notes;
        return (PluginUpdateBean)UploadPluginHelperKt.uploadOrFail$default(this.service.uploadById(id, (RequestBody)(string != null ? RequestHelperKt.toRequestBody(string) : null), (RequestBody)(string2 != null ? RequestHelperKt.toRequestBody(string2) : null), isHidden, RequestHelperKt.toMultipartBody(file)), null, 2, null);
    }

    @Override
    @Deprecated(message="Use uploadUpdateByXmlIdAndFamily(id, file, channel, notes, isHidden, family)")
    @NotNull
    public PluginUpdateBean upload(@NotNull String id, @NotNull File file, @Nullable String channel, @Nullable String notes, boolean isHidden) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = channel;
        String string2 = notes;
        return (PluginUpdateBean)UploadPluginHelperKt.uploadOrFail$default(this.service.uploadByStringId(RequestHelperKt.toRequestBody(id), (RequestBody)(string != null ? RequestHelperKt.toRequestBody(string) : null), (RequestBody)(string2 != null ? RequestHelperKt.toRequestBody(string2) : null), isHidden, RequestHelperKt.toMultipartBody(file)), null, 2, null);
    }

    @Override
    @NotNull
    public PluginUpdateBean uploadUpdateByXmlIdAndFamily(@NotNull String id, @NotNull ProductFamily family, @NotNull File file, @Nullable String channel, @Nullable String notes, boolean isHidden) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)((Object)family), (String)"family");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = channel;
        String string2 = notes;
        return (PluginUpdateBean)UploadPluginHelperKt.uploadOrFail$default(this.service.uploadByStringIdAndFamily(RequestHelperKt.toRequestBody(id), RequestHelperKt.toRequestBody(family.getId()), (RequestBody)(string != null ? RequestHelperKt.toRequestBody(string) : null), (RequestBody)(string2 != null ? RequestHelperKt.toRequestBody(string2) : null), isHidden, RequestHelperKt.toMultipartBody(file)), null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final PluginBean uploadNewPlugin$lambda$4(String $vendor, List $tags, LicenseUrl $licenseUrl, PluginUploaderInstance this$0, File $file, ProductFamily $family, String $channel, boolean $isHidden) {
        void $this$mapTo$iv$iv;
        if (!($vendor == null || !StringsKt.isBlank((CharSequence)$vendor))) {
            boolean $i$a$-require-PluginUploaderInstance$uploadNewPlugin$1$42 = false;
            String $i$a$-require-PluginUploaderInstance$uploadNewPlugin$1$42 = Messages.INSTANCE.getMessage("empty.vendor", new Object[0]);
            throw new IllegalArgumentException($i$a$-require-PluginUploaderInstance$uploadNewPlugin$1$42.toString());
        }
        if (!(!((Collection)$tags).isEmpty())) {
            boolean $i$a$-require-PluginUploaderInstance$uploadNewPlugin$1$52 = false;
            String $i$a$-require-PluginUploaderInstance$uploadNewPlugin$1$52 = Messages.INSTANCE.getMessage("empty.tags", new Object[0]);
            throw new IllegalArgumentException($i$a$-require-PluginUploaderInstance$uploadNewPlugin$1$52.toString());
        }
        if (!(((CharSequence)$licenseUrl.getUrl()).length() > 0)) {
            boolean $i$a$-require-PluginUploaderInstance$uploadNewPlugin$1$62 = false;
            String $i$a$-require-PluginUploaderInstance$uploadNewPlugin$1$62 = Messages.INSTANCE.getMessage("empty.license.url", new Object[0]);
            throw new IllegalArgumentException($i$a$-require-PluginUploaderInstance$uploadNewPlugin$1$62.toString());
        }
        String string = new URL($licenseUrl.getUrl()).toExternalForm();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toExternalForm(...)");
        RequestBody license = RequestHelperKt.toRequestBody(string);
        Iterable $this$map$iv = $tags;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(RequestHelperKt.toRequestBody((String)it));
        }
        List requestTags = (List)destination$iv$iv;
        String string3 = $vendor;
        String string4 = $channel;
        return (PluginBean)UploadPluginHelperKt.uploadOrFail$default(this$0.service.uploadNewPlugin(RequestHelperKt.toMultipartBody($file), $family.getId(), license, new ArrayList<RequestBody>(requestTags), (RequestBody)(string3 != null ? RequestHelperKt.toRequestBody(string3) : null), (RequestBody)(string4 != null ? RequestHelperKt.toRequestBody(string4) : null), $isHidden), null, 2, null);
    }
}

