/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.fs;

import com.jetbrains.plugin.structure.base.fs.FileSystemsKt;
import com.jetbrains.plugin.structure.fs.FsHandlerPath;
import com.jetbrains.plugin.structure.jar.FsHandleFileSystem;
import com.jetbrains.plugin.structure.jar.JarFileSystemProvider;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J)\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010\"\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J1\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t2\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0010\"\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J5\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\t2\u001e\u0010\u001b\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u001c0\u0010\"\b\u0012\u0002\b\u0003\u0018\u00010\u001cH\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0016JE\u0010\u001f\u001a\u0004\u0018\u0001H \"\n\b\u0000\u0010 *\u0004\u0018\u00010!2\u0006\u0010\u000e\u001a\u00020\t2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H 0#2\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0\u0010\"\u00020$H\u0016\u00a2\u0006\u0002\u0010%J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u000e\u001a\u00020\tH\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\t2\u0006\u0010*\u001a\u00020+H\u0016J\n\u0010-\u001a\u0004\u0018\u00010.H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u0010\u000e\u001a\u00020\tH\u0016J\u0018\u00101\u001a\u0002002\u0006\u0010\u000e\u001a\u00020\t2\u0006\u00102\u001a\u00020\tH\u0016J1\u00103\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t2\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0010\"\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J?\u00104\u001a\u0002052\u0006\u0010\u000e\u001a\u00020\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u000207062\u001a\u0010\u001b\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001c0\u0010\"\u0006\u0012\u0002\b\u00030\u001cH\u0016\u00a2\u0006\u0002\u00108J&\u00109\u001a\b\u0012\u0004\u0012\u00020\t0:2\u0006\u0010\u001a\u001a\u00020\t2\u000e\u0010;\u001a\n\u0012\u0006\b\u0000\u0012\u00020\t0<H\u0016J\"\u0010=\u001a\u00020>2\u0006\u0010*\u001a\u00020+2\u0010\u0010?\u001a\f\u0012\u0004\u0012\u00020.\u0012\u0002\b\u00030@H\u0016JA\u0010A\u001a\u0002HB\"\b\b\u0000\u0010B*\u00020C2\u0006\u0010\u000e\u001a\u00020\t2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002HB0#2\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0\u0010\"\u00020$H\u0016\u00a2\u0006\u0002\u0010DJ=\u0010A\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020E0@2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010F\u001a\u00020.2\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0\u0010\"\u00020$H\u0016\u00a2\u0006\u0002\u0010GJ9\u0010H\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010I\u001a\u00020.2\u0006\u0010J\u001a\u00020E2\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0\u0010\"\u00020$H\u0016\u00a2\u0006\u0002\u0010KJ\u0014\u0010L\u001a\n M*\u0004\u0018\u00010\t0\t*\u00020NH\u0002J\f\u0010O\u001a\u00020\t*\u00020+H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00020\t*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006P"}, d2={"Lcom/jetbrains/plugin/structure/fs/FsHandlerFileSystemProvider;", "Ljava/nio/file/spi/FileSystemProvider;", "delegateProvider", "delegateJarFileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "(Ljava/nio/file/spi/FileSystemProvider;Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;)V", "getDelegateProvider", "()Ljava/nio/file/spi/FileSystemProvider;", "unwrapped", "Ljava/nio/file/Path;", "getUnwrapped", "(Ljava/nio/file/Path;)Ljava/nio/file/Path;", "checkAccess", "", "path", "modes", "", "Ljava/nio/file/AccessMode;", "(Ljava/nio/file/Path;[Ljava/nio/file/AccessMode;)V", "copy", "source", "target", "options", "Ljava/nio/file/CopyOption;", "(Ljava/nio/file/Path;Ljava/nio/file/Path;[Ljava/nio/file/CopyOption;)V", "createDirectory", "dir", "attrs", "Ljava/nio/file/attribute/FileAttribute;", "(Ljava/nio/file/Path;[Ljava/nio/file/attribute/FileAttribute;)V", "delete", "getFileAttributeView", "V", "Ljava/nio/file/attribute/FileAttributeView;", "type", "Ljava/lang/Class;", "Ljava/nio/file/LinkOption;", "(Ljava/nio/file/Path;Ljava/lang/Class;[Ljava/nio/file/LinkOption;)Ljava/nio/file/attribute/FileAttributeView;", "getFileStore", "Ljava/nio/file/FileStore;", "getFileSystem", "Lcom/jetbrains/plugin/structure/jar/FsHandleFileSystem;", "uri", "Ljava/net/URI;", "getPath", "getScheme", "", "isHidden", "", "isSameFile", "path2", "move", "newByteChannel", "Ljava/nio/channels/SeekableByteChannel;", "", "Ljava/nio/file/OpenOption;", "(Ljava/nio/file/Path;Ljava/util/Set;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/channels/SeekableByteChannel;", "newDirectoryStream", "Ljava/nio/file/DirectoryStream;", "filter", "Ljava/nio/file/DirectoryStream$Filter;", "newFileSystem", "Ljava/nio/file/FileSystem;", "env", "", "readAttributes", "A", "Ljava/nio/file/attribute/BasicFileAttributes;", "(Ljava/nio/file/Path;Ljava/lang/Class;[Ljava/nio/file/LinkOption;)Ljava/nio/file/attribute/BasicFileAttributes;", "", "attributes", "(Ljava/nio/file/Path;Ljava/lang/String;[Ljava/nio/file/LinkOption;)Ljava/util/Map;", "setAttribute", "attribute", "value", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/Object;[Ljava/nio/file/LinkOption;)V", "reopen", "kotlin.jvm.PlatformType", "Lcom/jetbrains/plugin/structure/fs/FsHandlerPath;", "toPath", "structure-base"})
public final class FsHandlerFileSystemProvider
extends FileSystemProvider {
    @NotNull
    private final FileSystemProvider delegateProvider;
    @NotNull
    private final JarFileSystemProvider delegateJarFileSystemProvider;

    public FsHandlerFileSystemProvider(@NotNull FileSystemProvider delegateProvider, @NotNull JarFileSystemProvider delegateJarFileSystemProvider2) {
        Intrinsics.checkNotNullParameter((Object)delegateProvider, (String)"delegateProvider");
        Intrinsics.checkNotNullParameter((Object)delegateJarFileSystemProvider2, (String)"delegateJarFileSystemProvider");
        this.delegateProvider = delegateProvider;
        this.delegateJarFileSystemProvider = delegateJarFileSystemProvider2;
    }

    @NotNull
    public final FileSystemProvider getDelegateProvider() {
        return this.delegateProvider;
    }

    @Override
    @Nullable
    public String getScheme() {
        return this.delegateProvider.getScheme();
    }

    @Override
    @NotNull
    public FileSystem newFileSystem(@NotNull URI uri, @NotNull Map<String, ?> env) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(env, (String)"env");
        FileSystem fileSystem = this.delegateProvider.newFileSystem(uri, env);
        Intrinsics.checkNotNullExpressionValue((Object)fileSystem, (String)"delegateProvider.newFileSystem(uri, env)");
        return new FsHandleFileSystem(fileSystem, this.delegateJarFileSystemProvider, this.toPath(uri));
    }

    @Override
    @NotNull
    public FsHandleFileSystem getFileSystem(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        FileSystem fileSystem = this.delegateProvider.getFileSystem(uri);
        Intrinsics.checkNotNullExpressionValue((Object)fileSystem, (String)"delegateProvider.getFileSystem(uri)");
        return new FsHandleFileSystem(fileSystem, this.delegateJarFileSystemProvider, this.toPath(uri));
    }

    @Override
    @NotNull
    public Path getPath(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return new FsHandlerPath(this.getFileSystem(uri), this.toPath(uri));
    }

    @Override
    @NotNull
    public SeekableByteChannel newByteChannel(@NotNull Path path, @NotNull Set<? extends OpenOption> options, FileAttribute<?> ... attrs) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
        SeekableByteChannel seekableByteChannel = this.delegateProvider.newByteChannel(this.getUnwrapped(path), options, Arrays.copyOf(attrs, attrs.length));
        Intrinsics.checkNotNullExpressionValue((Object)seekableByteChannel, (String)"delegateProvider.newByte\u2026wrapped, options, *attrs)");
        return seekableByteChannel;
    }

    @Override
    @NotNull
    public DirectoryStream<Path> newDirectoryStream(@NotNull Path dir2, @NotNull DirectoryStream.Filter<? super Path> filter) {
        Intrinsics.checkNotNullParameter((Object)dir2, (String)"dir");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        DirectoryStream<Path> directoryStream = this.delegateProvider.newDirectoryStream(this.getUnwrapped(dir2), filter);
        Intrinsics.checkNotNullExpressionValue(directoryStream, (String)"delegateProvider.newDire\u2026am(dir.unwrapped, filter)");
        return directoryStream;
    }

    @Override
    public void createDirectory(@NotNull Path dir2, FileAttribute<?> ... attrs) {
        Intrinsics.checkNotNullParameter((Object)dir2, (String)"dir");
        Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
        this.delegateProvider.createDirectory(this.getUnwrapped(dir2), Arrays.copyOf(attrs, attrs.length));
    }

    @Override
    public void delete(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.delegateProvider.delete(this.getUnwrapped(path));
    }

    @Override
    public void copy(@NotNull Path source, @NotNull Path target, CopyOption ... options) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.delegateProvider.copy(this.getUnwrapped(source), this.getUnwrapped(target), Arrays.copyOf(options, options.length));
    }

    @Override
    public void move(@NotNull Path source, @NotNull Path target, CopyOption ... options) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.delegateProvider.move(this.getUnwrapped(source), this.getUnwrapped(target), Arrays.copyOf(options, options.length));
    }

    @Override
    public boolean isSameFile(@NotNull Path path, @NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path2");
        return path instanceof FsHandlerPath && path2 instanceof FsHandlerPath ? ((FsHandlerPath)path).getDelegatePath().getFileSystem().provider().isSameFile(((FsHandlerPath)path).getDelegatePath(), ((FsHandlerPath)path2).getDelegatePath()) : this.delegateProvider.isSameFile(this.getUnwrapped(path), this.getUnwrapped(path2));
    }

    @Override
    public boolean isHidden(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.delegateProvider.isHidden(this.getUnwrapped(path));
    }

    @Override
    @NotNull
    public FileStore getFileStore(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        FileStore fileStore = this.delegateProvider.getFileStore(this.getUnwrapped(path));
        Intrinsics.checkNotNullExpressionValue((Object)fileStore, (String)"delegateProvider.getFileStore(path.unwrapped)");
        return fileStore;
    }

    @Override
    public void checkAccess(@NotNull Path path, AccessMode ... modes) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)modes, (String)"modes");
        this.delegateProvider.checkAccess(this.getUnwrapped(path), Arrays.copyOf(modes, modes.length));
    }

    @Override
    @Nullable
    public <V extends FileAttributeView> V getFileAttributeView(@NotNull Path path, @NotNull Class<V> type, LinkOption ... options) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return this.delegateProvider.getFileAttributeView(this.getUnwrapped(path), type, Arrays.copyOf(options, options.length));
    }

    @Override
    @NotNull
    public <A extends BasicFileAttributes> A readAttributes(@NotNull Path path, @NotNull Class<A> type, LinkOption ... options) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        A a = this.delegateProvider.readAttributes(this.getUnwrapped(path), type, Arrays.copyOf(options, options.length));
        Intrinsics.checkNotNullExpressionValue(a, (String)"delegateProvider.readAtt\u2026nwrapped, type, *options)");
        return a;
    }

    @Override
    @NotNull
    public Map<String, Object> readAttributes(@NotNull Path path, @NotNull String attributes, LinkOption ... options) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Map<String, Object> map = this.delegateProvider.readAttributes(this.getUnwrapped(path), attributes, Arrays.copyOf(options, options.length));
        Intrinsics.checkNotNullExpressionValue(map, (String)"delegateProvider.readAtt\u2026ed, attributes, *options)");
        return map;
    }

    @Override
    public void setAttribute(@NotNull Path path, @NotNull String attribute, @NotNull Object value, LinkOption ... options) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.delegateProvider.setAttribute(this.getUnwrapped(path), attribute, value, Arrays.copyOf(options, options.length));
    }

    private final Path toPath(URI $this$toPath) {
        Path path = this.delegateProvider.getPath($this$toPath);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"delegateProvider.getPath(this)");
        return path;
    }

    private final Path reopen(FsHandlerPath $this$reopen) {
        return $this$reopen.getFileSystem().getPath(((Object)$this$reopen.getDelegatePath()).toString(), new String[0]);
    }

    private final Path getUnwrapped(Path $this$unwrapped) {
        Path path;
        if ($this$unwrapped instanceof FsHandlerPath) {
            FileSystem fileSystem = ((FsHandlerPath)$this$unwrapped).getDelegatePath().getFileSystem();
            Intrinsics.checkNotNullExpressionValue((Object)fileSystem, (String)"delegatePath.fileSystem");
            if (FileSystemsKt.isClosed(fileSystem)) {
                Path path2 = this.reopen((FsHandlerPath)$this$unwrapped);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"reopen()");
                path = this.getUnwrapped(path2);
            } else {
                path = ((FsHandlerPath)$this$unwrapped).getDelegatePath();
            }
        } else {
            path = $this$unwrapped;
        }
        return path;
    }
}

