/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.jar;

import com.jetbrains.plugin.structure.jar.JarArchiveException;
import java.net.URI;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tB\u0017\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB\u001f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000eB\u0017\b\u0012\u0012\u0006\u0010\u000f\u001a\u00020\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/plugin/structure/jar/JarArchiveCannotBeOpenException;", "Lcom/jetbrains/plugin/structure/jar/JarArchiveException;", "jarUri", "Ljava/net/URI;", "cause", "", "(Ljava/net/URI;Ljava/lang/Throwable;)V", "jarPath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;Ljava/lang/Throwable;)V", "additionalMessage", "", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "resolvedJarUri", "(Ljava/nio/file/Path;Ljava/net/URI;Ljava/lang/Throwable;)V", "message", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "structure-base"})
public final class JarArchiveCannotBeOpenException
extends JarArchiveException {
    public JarArchiveCannotBeOpenException(@NotNull URI jarUri, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)jarUri, (String)"jarUri");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        this("JAR file cannot be open at [" + jarUri + "]", cause);
    }

    public JarArchiveCannotBeOpenException(@NotNull Path jarPath, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)jarPath, (String)"jarPath");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        this("JAR file cannot be open at [" + jarPath + "]", cause);
    }

    public JarArchiveCannotBeOpenException(@NotNull Path jarPath, @NotNull String additionalMessage) {
        Intrinsics.checkNotNullParameter((Object)jarPath, (String)"jarPath");
        Intrinsics.checkNotNullParameter((Object)additionalMessage, (String)"additionalMessage");
        super("JAR file cannot be open at [" + jarPath + "]: " + additionalMessage);
    }

    public JarArchiveCannotBeOpenException(@NotNull Path jarPath, @NotNull URI resolvedJarUri, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)jarPath, (String)"jarPath");
        Intrinsics.checkNotNullParameter((Object)resolvedJarUri, (String)"resolvedJarUri");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        super("JAR file cannot be open at [" + jarPath + "] (resolved URI: <" + resolvedJarUri + ">)", cause);
    }

    private JarArchiveCannotBeOpenException(String message, Throwable cause) {
        super(message, cause);
    }
}

