/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.jar;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import java.net.URI;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0002\u001a\u0014\u0010\u0007\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a\n\u0010\t\u001a\u00020\u0005*\u00020\u0006\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"FILE_SCHEMA", "", "JAR_FILE_SCHEMA", "JAR_SCHEME", "asJarFileUri", "Ljava/net/URI;", "Ljava/nio/file/Path;", "replaceSchema", "newSchema", "toJarFileUri", "structure-base"})
public final class JarsKt {
    @NotNull
    public static final String JAR_FILE_SCHEMA = "jar:file";
    @NotNull
    public static final String FILE_SCHEMA = "file";
    @NotNull
    public static final String JAR_SCHEME = "jar";

    @NotNull
    public static final URI toJarFileUri(@NotNull Path $this$toJarFileUri) {
        URI uRI;
        Intrinsics.checkNotNullParameter((Object)$this$toJarFileUri, (String)"<this>");
        if (Intrinsics.areEqual((Object)$this$toJarFileUri.toUri().getScheme(), (Object)FILE_SCHEMA)) {
            Path $this$toJarFileUri_u24lambda_u240 = $this$toJarFileUri.toAbsolutePath();
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$toJarFileUri_u24lambda_u240, (String)"toJarFileUri$lambda$0");
            Path path = FileUtilKt.exists($this$toJarFileUri_u24lambda_u240) ? $this$toJarFileUri_u24lambda_u240.toRealPath(new LinkOption[0]) : $this$toJarFileUri_u24lambda_u240.normalize();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath().run {\n \u2026th() else normalize()\n  }");
            uRI = JarsKt.asJarFileUri(path);
        } else {
            URI uRI2 = $this$toJarFileUri.toUri();
            uRI = uRI2;
            Intrinsics.checkNotNullExpressionValue((Object)uRI2, (String)"{\n  toUri()\n}");
        }
        return uRI;
    }

    private static final URI asJarFileUri(Path $this$asJarFileUri) {
        URI uRI = $this$asJarFileUri.toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toUri()");
        return JarsKt.replaceSchema(uRI, JAR_FILE_SCHEMA);
    }

    private static final URI replaceSchema(URI $this$replaceSchema, String newSchema) {
        return new URI(newSchema, $this$replaceSchema.getUserInfo(), $this$replaceSchema.getHost(), $this$replaceSchema.getPort(), $this$replaceSchema.getPath(), $this$replaceSchema.getQuery(), $this$replaceSchema.getFragment());
    }
}

