/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.ide;

import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.PluginProvider;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Ide
implements PluginProvider {
    @NotNull
    public abstract IdeVersion getVersion();

    @NotNull
    public abstract List<IdePlugin> getBundledPlugins();

    @Nullable
    public final IdePlugin findPluginById(@NotNull String pluginId) {
        for (IdePlugin plugin : this.getBundledPlugins()) {
            String id = plugin.getPluginId() != null ? plugin.getPluginId() : plugin.getPluginName();
            if (!Objects.equals(id, pluginId)) continue;
            return plugin;
        }
        return null;
    }

    @Nullable
    public final IdePlugin findPluginByModule(@NotNull String moduleId) {
        for (IdePlugin plugin : this.getBundledPlugins()) {
            if (!plugin.getDefinedModules().contains(moduleId)) continue;
            return plugin;
        }
        return null;
    }

    @NotNull
    public abstract Path getIdePath();
}

