/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.ide.layout;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0013\u0010\r\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/plugin/structure/ide/layout/IdeRelativePath;", "", "idePath", "Ljava/nio/file/Path;", "relativePath", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "exists", "", "getExists", "()Z", "getIdePath", "()Ljava/nio/file/Path;", "getRelativePath", "resolvedPath", "getResolvedPath", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toList", "", "toString", "", "structure-ide"})
public final class IdeRelativePath {
    @NotNull
    private final Path idePath;
    @NotNull
    private final Path relativePath;
    @Nullable
    private final Path resolvedPath;

    public IdeRelativePath(@NotNull Path idePath, @NotNull Path relativePath) {
        Intrinsics.checkNotNullParameter((Object)idePath, (String)"idePath");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        this.idePath = idePath;
        this.relativePath = relativePath;
        this.resolvedPath = this.idePath.resolve(this.relativePath);
    }

    @NotNull
    public final Path getIdePath() {
        return this.idePath;
    }

    @NotNull
    public final Path getRelativePath() {
        return this.relativePath;
    }

    @Nullable
    public final Path getResolvedPath() {
        return this.resolvedPath;
    }

    public final boolean getExists() {
        Path path = this.resolvedPath;
        return path != null ? FileUtilKt.exists((Path)path) : false;
    }

    @NotNull
    public final List<Path> toList() {
        return this.resolvedPath != null ? CollectionsKt.listOf((Object)this.resolvedPath) : CollectionsKt.emptyList();
    }

    @NotNull
    public final Path component1() {
        return this.idePath;
    }

    @NotNull
    public final Path component2() {
        return this.relativePath;
    }

    @NotNull
    public final IdeRelativePath copy(@NotNull Path idePath, @NotNull Path relativePath) {
        Intrinsics.checkNotNullParameter((Object)idePath, (String)"idePath");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        return new IdeRelativePath(idePath, relativePath);
    }

    public static /* synthetic */ IdeRelativePath copy$default(IdeRelativePath ideRelativePath, Path path, Path path2, int n, Object object) {
        if ((n & 1) != 0) {
            path = ideRelativePath.idePath;
        }
        if ((n & 2) != 0) {
            path2 = ideRelativePath.relativePath;
        }
        return ideRelativePath.copy(path, path2);
    }

    @NotNull
    public String toString() {
        return "IdeRelativePath(idePath=" + this.idePath + ", relativePath=" + this.relativePath + ")";
    }

    public int hashCode() {
        int result = ((Object)this.idePath).hashCode();
        result = result * 31 + ((Object)this.relativePath).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IdeRelativePath)) {
            return false;
        }
        IdeRelativePath ideRelativePath = (IdeRelativePath)other;
        if (!Intrinsics.areEqual((Object)this.idePath, (Object)ideRelativePath.idePath)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.relativePath, (Object)ideRelativePath.relativePath);
    }
}

