/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.extractor;

import com.jetbrains.plugin.structure.base.decompress.DecompressorSizeLimitExceededException;
import com.jetbrains.plugin.structure.base.plugin.PluginProblem;
import com.jetbrains.plugin.structure.base.plugin.Settings;
import com.jetbrains.plugin.structure.base.problems.PluginFileSizeIsTooLarge;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.ZipUtilKt;
import com.jetbrains.plugin.structure.intellij.extractor.ExtractedPlugin;
import com.jetbrains.plugin.structure.intellij.extractor.ExtractorResult;
import com.jetbrains.plugin.structure.intellij.problems.PluginZipContainsMultipleFiles;
import com.jetbrains.plugin.structure.intellij.problems.PluginZipContainsUnknownFile;
import com.jetbrains.plugin.structure.intellij.problems.PluginZipIsEmpty;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/plugin/structure/intellij/extractor/PluginExtractor;", "", "()V", "extractPlugin", "Lcom/jetbrains/plugin/structure/intellij/extractor/ExtractorResult;", "pluginFile", "Ljava/nio/file/Path;", "extractDirectory", "fail", "problem", "Lcom/jetbrains/plugin/structure/base/plugin/PluginProblem;", "extractedPlugin", "getExtractorResult", "success", "actualFile", "fileToDelete", "structure-intellij"})
public final class PluginExtractor {
    public static final PluginExtractor INSTANCE;

    @NotNull
    public final ExtractorResult extractPlugin(@NotNull Path pluginFile, @NotNull Path extractDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)pluginFile, (String)"pluginFile");
        Intrinsics.checkParameterIsNotNull((Object)extractDirectory, (String)"extractDirectory");
        Files.createDirectories(extractDirectory, new FileAttribute[0]);
        Path extractedPlugin = Files.createTempDirectory(extractDirectory, "plugin_", new FileAttribute[0]);
        try {
            Path path = extractedPlugin;
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"extractedPlugin");
            ZipUtilKt.extractZip((Path)pluginFile, (Path)path, (Long)Settings.INTELLIJ_PLUGIN_SIZE_LIMIT.getAsLong());
        }
        catch (DecompressorSizeLimitExceededException e) {
            PluginProblem pluginProblem = (PluginProblem)new PluginFileSizeIsTooLarge(e.getSizeLimit());
            Path path = extractedPlugin;
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"extractedPlugin");
            return this.fail(pluginProblem, path);
        }
        catch (Throwable e) {
            Path path = extractedPlugin;
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"extractedPlugin");
            FileUtilKt.deleteQuietly((Path)path);
            throw e;
        }
        return this.getExtractorResult(extractedPlugin);
    }

    private final ExtractorResult success(Path actualFile, Path fileToDelete) {
        return new ExtractorResult.Success(new ExtractedPlugin(actualFile, fileToDelete));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ExtractorResult fail(PluginProblem problem, Path extractedPlugin) {
        try {
            ExtractorResult extractorResult = new ExtractorResult.Fail(problem);
            return extractorResult;
        }
        finally {
            FileUtilKt.deleteQuietly((Path)extractedPlugin);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ExtractorResult getExtractorResult(Path extractedPlugin) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List rootFiles = FileUtilKt.listFiles((Path)extractedPlugin);
        switch (rootFiles.size()) {
            case 0: {
                return this.fail((PluginProblem)new PluginZipIsEmpty(), extractedPlugin);
            }
            case 1: {
                Path singleFile = (Path)rootFiles.get(0);
                return FileUtilKt.isJar((Path)singleFile) ? this.success(singleFile, extractedPlugin) : (FileUtilKt.isDirectory((Path)singleFile) ? (Intrinsics.areEqual((Object)FileUtilKt.getSimpleName((Path)singleFile), (Object)"lib") ? this.success(extractedPlugin, extractedPlugin) : this.success(singleFile, extractedPlugin)) : this.fail((PluginProblem)new PluginZipContainsUnknownFile(FileUtilKt.getSimpleName((Path)singleFile)), extractedPlugin));
            }
        }
        Iterable singleFile = rootFiles;
        PluginExtractor pluginExtractor = this;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path = (Path)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = FileUtilKt.getSimpleName((Path)it);
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        List list = CollectionsKt.sorted((Iterable)collection);
        return pluginExtractor.fail((PluginProblem)new PluginZipContainsMultipleFiles(list), extractedPlugin);
    }

    private PluginExtractor() {
    }

    static {
        PluginExtractor pluginExtractor;
        INSTANCE = pluginExtractor = new PluginExtractor();
    }
}

