/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.jetbrains.plugin.structure.base.plugin.Plugin;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationFail;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationSuccess;
import com.jetbrains.plugin.structure.base.plugin.PluginIcon;
import com.jetbrains.plugin.structure.base.plugin.PluginProblem;
import com.jetbrains.plugin.structure.base.plugin.ThirdPartyDependency;
import com.jetbrains.plugin.structure.base.problems.ContainsNewlines;
import com.jetbrains.plugin.structure.base.problems.NotBoolean;
import com.jetbrains.plugin.structure.base.problems.NotNumber;
import com.jetbrains.plugin.structure.base.problems.PropertyNotSpecified;
import com.jetbrains.plugin.structure.base.problems.UnableToReadDescriptor;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.intellij.beans.IdeaVersionBean;
import com.jetbrains.plugin.structure.intellij.beans.PluginBean;
import com.jetbrains.plugin.structure.intellij.beans.PluginContentBean;
import com.jetbrains.plugin.structure.intellij.beans.PluginDependenciesModuleBean;
import com.jetbrains.plugin.structure.intellij.beans.PluginDependenciesPluginBean;
import com.jetbrains.plugin.structure.intellij.beans.PluginDependencyBean;
import com.jetbrains.plugin.structure.intellij.beans.PluginVendorBean;
import com.jetbrains.plugin.structure.intellij.beans.ProductDescriptorBean;
import com.jetbrains.plugin.structure.intellij.extractor.PluginBeanExtractor;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.IdePluginContentDescriptor;
import com.jetbrains.plugin.structure.intellij.plugin.IdePluginImpl;
import com.jetbrains.plugin.structure.intellij.plugin.IdeTheme;
import com.jetbrains.plugin.structure.intellij.plugin.MutableIdePluginContentDescriptor;
import com.jetbrains.plugin.structure.intellij.plugin.OptionalPluginDescriptor;
import com.jetbrains.plugin.structure.intellij.plugin.PluginDependency;
import com.jetbrains.plugin.structure.intellij.plugin.PluginDependencyImpl;
import com.jetbrains.plugin.structure.intellij.plugin.ProductDescriptor;
import com.jetbrains.plugin.structure.intellij.problems.DefaultChangeNotes;
import com.jetbrains.plugin.structure.intellij.problems.DuplicatedDependencyWarning;
import com.jetbrains.plugin.structure.intellij.problems.ElementAvailableOnlySinceNewerVersion;
import com.jetbrains.plugin.structure.intellij.problems.ElementMissingAttribute;
import com.jetbrains.plugin.structure.intellij.problems.ErroneousSinceBuild;
import com.jetbrains.plugin.structure.intellij.problems.ErroneousUntilBuild;
import com.jetbrains.plugin.structure.intellij.problems.HttpLinkInDescription;
import com.jetbrains.plugin.structure.intellij.problems.InvalidDependencyId;
import com.jetbrains.plugin.structure.intellij.problems.InvalidModuleBean;
import com.jetbrains.plugin.structure.intellij.problems.InvalidSinceBuild;
import com.jetbrains.plugin.structure.intellij.problems.InvalidUntilBuild;
import com.jetbrains.plugin.structure.intellij.problems.NoModuleDependencies;
import com.jetbrains.plugin.structure.intellij.problems.NonLatinDescription;
import com.jetbrains.plugin.structure.intellij.problems.OptionalDependencyConfigFileNotSpecified;
import com.jetbrains.plugin.structure.intellij.problems.OptionalDependencyDescriptorCycleProblem;
import com.jetbrains.plugin.structure.intellij.problems.OptionalDependencyDescriptorResolutionProblem;
import com.jetbrains.plugin.structure.intellij.problems.ProductCodePrefixInBuild;
import com.jetbrains.plugin.structure.intellij.problems.PropertyWithDefaultValue;
import com.jetbrains.plugin.structure.intellij.problems.ReleaseDateWrongFormat;
import com.jetbrains.plugin.structure.intellij.problems.ShortDescription;
import com.jetbrains.plugin.structure.intellij.problems.SinceBuildGreaterThanUntilBuild;
import com.jetbrains.plugin.structure.intellij.problems.SinceBuildNotSpecified;
import com.jetbrains.plugin.structure.intellij.problems.SuperfluousNonOptionalDependencyDeclaration;
import com.jetbrains.plugin.structure.intellij.problems.SuspiciousUntilBuild;
import com.jetbrains.plugin.structure.intellij.problems.TemplateWordInPluginName;
import com.jetbrains.plugin.structure.intellij.problems.TooLongPropertyValue;
import com.jetbrains.plugin.structure.intellij.problems.UnableToFindTheme;
import com.jetbrains.plugin.structure.intellij.problems.UnableToReadTheme;
import com.jetbrains.plugin.structure.intellij.problems.XIncludeResolutionErrors;
import com.jetbrains.plugin.structure.intellij.resources.ResourceResolver;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import com.jetbrains.plugin.structure.intellij.xinclude.XIncluder;
import com.jetbrains.plugin.structure.intellij.xinclude.XIncluderException;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jdom2.Attribute;
import org.jdom2.Namespace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u0093\u00012\u00020\u0001:\u0002\u0093\u0001B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0000J\u0010\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020&H\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010\u00032\u0006\u0010(\u001a\u00020&H\u0002J\b\u0010)\u001a\u00020\nH\u0002J\u0018\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020&2\u0006\u0010,\u001a\u00020\u0012H\u0002J \u0010-\u001a\u00020 2\u0006\u0010+\u001a\u00020&2\u0006\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u000200H\u0002J\u0012\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u000204H\u0002J\u0018\u00105\u001a\u00020 2\u0006\u0010+\u001a\u00020&2\u0006\u0010,\u001a\u00020\u0012H\u0002J\u0018\u00106\u001a\u00020 2\u0006\u0010+\u001a\u00020&2\u0006\u0010,\u001a\u00020\u0012H\u0002J \u00107\u001a\u00020 2\u0006\u0010+\u001a\u00020&2\u0006\u00108\u001a\u00020\u00032\u0006\u0010/\u001a\u000200H\u0002J(\u00109\u001a\n\u0012\u0004\u0012\u00020;\u0018\u00010:2\u0006\u0010\u0011\u001a\u00020\u00152\u0006\u00103\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0002J\u0018\u0010?\u001a\u00020@2\u0006\u0010%\u001a\u00020&2\u0006\u0010A\u001a\u00020\u0003H\u0002J\u0014\u0010B\u001a\u00020 2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00030:J\u0010\u0010D\u001a\u00020 2\u0006\u0010E\u001a\u00020\u001dH\u0002J0\u0010F\u001a\u00020 2\u0006\u0010G\u001a\u0002042\u0006\u0010H\u001a\u00020<2\u0006\u0010I\u001a\u00020\u00032\u0006\u0010=\u001a\u00020>2\u0006\u0010J\u001a\u00020\nH\u0002J*\u0010K\u001a\u0004\u0018\u0001042\u0006\u00103\u001a\u0002042\u0006\u0010L\u001a\u00020\u00032\u0006\u0010=\u001a\u00020>2\u0006\u0010H\u001a\u00020<H\u0002J\u0014\u0010M\u001a\u00020 2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020O0:J\u000e\u0010P\u001a\u00020 2\u0006\u0010Q\u001a\u00020<J\u000e\u0010R\u001a\u00020 2\u0006\u0010S\u001a\u00020\u0003J\u0014\u0010T\u001a\u00020 2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020V0:J\u0012\u0010W\u001a\u00020 2\b\u0010X\u001a\u0004\u0018\u00010\u0003H\u0002J\u0018\u0010Y\u001a\u00020 2\u0006\u0010Z\u001a\u00020\u00032\u0006\u0010[\u001a\u00020\u0003H\u0002J\u0012\u0010\\\u001a\u00020 2\b\u0010]\u001a\u0004\u0018\u00010\u0003H\u0002J\u0016\u0010^\u001a\u00020 2\f\u0010_\u001a\b\u0012\u0004\u0012\u00020`0:H\u0002J\u001a\u0010a\u001a\u00020 2\b\u0010b\u001a\u0004\u0018\u00010\u00032\u0006\u0010J\u001a\u00020\nH\u0002J\u0010\u0010c\u001a\u00020 2\u0006\u0010d\u001a\u00020\u0003H\u0002J\u0012\u0010e\u001a\u00020 2\b\u0010f\u001a\u0004\u0018\u00010\u0003H\u0002J\u0012\u0010g\u001a\u00020 2\b\u0010h\u001a\u0004\u0018\u00010iH\u0002J\u0012\u0010j\u001a\u00020 2\b\u0010[\u001a\u0004\u0018\u00010\u0003H\u0002J\u0018\u0010k\u001a\u00020 2\u0006\u0010l\u001a\u00020\u00032\u0006\u0010m\u001a\u00020\u0003H\u0002J\u0010\u0010n\u001a\u00020 2\u0006\u0010o\u001a\u00020\u0003H\u0002J\u0010\u0010p\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010q\u001a\u00020 2\u0006\u0010r\u001a\u0002022\u0006\u0010J\u001a\u00020\nH\u0002J\u0012\u0010s\u001a\u00020 2\b\u0010t\u001a\u0004\u0018\u00010\u0003H\u0002J\u0012\u0010u\u001a\u00020 2\b\u0010v\u001a\u0004\u0018\u00010wH\u0002J \u0010x\u001a\u00020 2\u0006\u0010l\u001a\u00020\u00032\u0006\u0010m\u001a\u00020\u00032\u0006\u0010y\u001a\u00020zH\u0002J\u0012\u0010{\u001a\u00020 2\b\u0010|\u001a\u0004\u0018\u00010\u0003H\u0002J\u0012\u0010}\u001a\u00020 2\b\u0010~\u001a\u0004\u0018\u00010\u0003H\u0002J\u0013\u0010\u007f\u001a\u00020 2\t\u0010\u0080\u0001\u001a\u0004\u0018\u00010\u0003H\u0002J\u0012\u0010\u0081\u0001\u001a\u00020 2\u0007\u0010\u0082\u0001\u001a\u00020\u0003H\u0002J\u0015\u0010\u0083\u0001\u001a\u00020 2\n\u0010\u0084\u0001\u001a\u0005\u0018\u00010\u0085\u0001H\u0002J\u001b\u0010\u0086\u0001\u001a\u00020 2\b\u0010S\u001a\u0004\u0018\u00010\u00032\u0006\u0010J\u001a\u00020\nH\u0002J\u001d\u0010\u0087\u0001\u001a\u00020\n*\u00020&2\u0007\u0010\u0088\u0001\u001a\u00020\u00032\u0007\u0010\u0089\u0001\u001a\u00020\nJ\u0016\u0010\u008a\u0001\u001a\u00020 *\u0002002\u0007\u0010\u008b\u0001\u001a\u000200H\u0002J\u0010\u0010\u008c\u0001\u001a\u0005\u0018\u00010\u008d\u0001*\u00020&H\u0002J\u0010\u0010\u008e\u0001\u001a\u0005\u0018\u00010\u008f\u0001*\u00020&H\u0002J\u000e\u0010\u0090\u0001\u001a\u00030\u0091\u0001*\u00020&H\u0002J\u001d\u0010\u0092\u0001\u001a\u00020 *\u00020\u00122\u0006\u0010r\u001a\u0002022\u0006\u00103\u001a\u000204H\u0002R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00030\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\bR\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\bR\u001e\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u001d0\u001cj\b\u0012\u0004\u0012\u00020\u001d`\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0094\u0001"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;", "", "pluginFileName", "", "descriptorPath", "parentPlugin", "(Ljava/lang/String;Ljava/lang/String;Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;)V", "getDescriptorPath", "()Ljava/lang/String;", "isSuccess", "", "()Z", "optionalDependenciesConfigFiles", "", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDependency;", "getOptionalDependenciesConfigFiles", "()Ljava/util/Map;", "plugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePluginImpl;", "pluginCreationResult", "Lcom/jetbrains/plugin/structure/base/plugin/PluginCreationResult;", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "getPluginCreationResult", "()Lcom/jetbrains/plugin/structure/base/plugin/PluginCreationResult;", "getPluginFileName", "pluginId", "getPluginId", "problems", "Ljava/util/ArrayList;", "Lcom/jetbrains/plugin/structure/base/plugin/PluginProblem;", "Lkotlin/collections/ArrayList;", "addOptionalDescriptor", "", "pluginDependency", "configurationFile", "optionalDependencyCreator", "extractEPName", "extensionElement", "Lorg/jdom2/Element;", "getExtensionPointName", "extensionPoint", "hasErrors", "readActions", "rootElement", "idePlugin", "readComponents", "componentsArea", "containerDescriptor", "Lcom/jetbrains/plugin/structure/intellij/plugin/MutableIdePluginContentDescriptor;", "readDocumentIntoXmlBean", "Lcom/jetbrains/plugin/structure/intellij/beans/PluginBean;", "document", "Lorg/jdom2/Document;", "readExtensionPoints", "readExtensions", "readListeners", "listenersName", "readPluginThemes", "", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdeTheme;", "Ljava/nio/file/Path;", "pathResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "readServiceDescriptor", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePluginContentDescriptor$ServiceDescriptor;", "epName", "registerOptionalDependenciesConfigurationFilesCycleProblem", "configurationFileCycle", "registerProblem", "problem", "resolveDocumentAndValidateBean", "originalDocument", "documentPath", "documentName", "validateDescriptor", "resolveXIncludesOfDocument", "presentablePath", "setIcons", "icons", "Lcom/jetbrains/plugin/structure/base/plugin/PluginIcon;", "setOriginalFile", "originalFile", "setPluginVersion", "pluginVersion", "setThirdPartyDependencies", "thirdPartyDependencies", "Lcom/jetbrains/plugin/structure/base/plugin/ThirdPartyDependency;", "validateBeanUrl", "beanUrl", "validateBooleanFlag", "flag", "name", "validateChangeNotes", "changeNotes", "validateDependencies", "dependencies", "Lcom/jetbrains/plugin/structure/intellij/beans/PluginDependencyBean;", "validateDescription", "htmlDescription", "validateEapFlag", "eapFlag", "validateId", "id", "validateIdeaVersion", "versionBean", "Lcom/jetbrains/plugin/structure/intellij/beans/IdeaVersionBean;", "validateName", "validateNewlines", "propertyName", "propertyValue", "validateOptionalFlag", "optionalFlag", "validatePlugin", "validatePluginBean", "bean", "validateProductCode", "productCode", "validateProductDescriptor", "productDescriptor", "Lcom/jetbrains/plugin/structure/intellij/beans/ProductDescriptorBean;", "validatePropertyLength", "maxLength", "", "validateReleaseDate", "releaseDate", "validateReleaseVersion", "releaseVersion", "validateSinceBuild", "sinceBuild", "validateUntilBuild", "untilBuild", "validateVendor", "vendorBean", "Lcom/jetbrains/plugin/structure/intellij/beans/PluginVendorBean;", "validateVersion", "getAttributeBooleanValue", "attname", "default", "mergeWith", "other", "readOs", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePluginContentDescriptor$Os;", "readServiceClient", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePluginContentDescriptor$ClientKind;", "readServicePreloadMode", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePluginContentDescriptor$PreloadMode;", "setInfoFromBean", "Companion", "structure-intellij"})
public final class PluginCreator {
    @NotNull
    private final Map<PluginDependency, String> optionalDependenciesConfigFiles;
    private final IdePluginImpl plugin;
    private final ArrayList<PluginProblem> problems;
    @NotNull
    private final String pluginFileName;
    @NotNull
    private final String descriptorPath;
    private final PluginCreator parentPlugin;
    private static final Logger LOG;
    private static final int MAX_PRODUCT_CODE_LENGTH = 15;
    private static final int MAX_VERSION_LENGTH = 64;
    private static final int MAX_PROPERTY_LENGTH = 255;
    private static final int MAX_LONG_PROPERTY_LENGTH = 65535;
    private static final String INTELLIJ_THEME_EXTENSION = "com.intellij.themeProvider";
    private static final Set<String> DEFAULT_TEMPLATE_NAMES;
    private static final Set<String> PLUGIN_NAME_RESTRICTED_WORDS;
    private static final Set<String> DEFAULT_TEMPLATE_DESCRIPTIONS;
    @NotNull
    private static final Regex v2ModulePrefix;
    private static final Regex latinSymbolsRegex;
    private static final ObjectMapper json;
    private static final DateTimeFormatter releaseDateFormatter;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final Map<PluginDependency, String> getOptionalDependenciesConfigFiles() {
        return this.optionalDependenciesConfigFiles;
    }

    @Nullable
    public final String getPluginId() {
        String string = this.plugin.getPluginId();
        if (string == null) {
            PluginCreator pluginCreator = this.parentPlugin;
            string = pluginCreator != null ? pluginCreator.getPluginId() : null;
        }
        return string;
    }

    public final boolean isSuccess() {
        return !this.hasErrors();
    }

    @NotNull
    public final PluginCreationResult<IdePlugin> getPluginCreationResult() {
        return this.hasErrors() ? (PluginCreationResult)new PluginCreationFail((List)this.problems) : (PluginCreationResult)new PluginCreationSuccess((Plugin)this.plugin, (List)this.problems);
    }

    /*
     * WARNING - void declaration
     */
    public final void addOptionalDescriptor(@NotNull PluginDependency pluginDependency, @NotNull String configurationFile, @NotNull PluginCreator optionalDependencyCreator) {
        Intrinsics.checkNotNullParameter((Object)pluginDependency, (String)"pluginDependency");
        Intrinsics.checkNotNullParameter((Object)configurationFile, (String)"configurationFile");
        Intrinsics.checkNotNullParameter((Object)optionalDependencyCreator, (String)"optionalDependencyCreator");
        PluginCreationResult<IdePlugin> pluginCreationResult = optionalDependencyCreator.getPluginCreationResult();
        if (pluginCreationResult instanceof PluginCreationSuccess) {
            IdePlugin optionalPlugin = (IdePlugin)((PluginCreationSuccess)pluginCreationResult).getPlugin();
            Collection collection = this.plugin.getOptionalDescriptors();
            OptionalPluginDescriptor optionalPluginDescriptor = new OptionalPluginDescriptor(pluginDependency, optionalPlugin, configurationFile);
            collection.add(optionalPluginDescriptor);
            Map<String, List<org.jdom2.Element>> $this$forEach$iv = optionalPlugin.getExtensions();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, List<org.jdom2.Element>>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                List list;
                void extensionPointName;
                Map.Entry<String, List<org.jdom2.Element>> element$iv;
                Map.Entry<String, List<org.jdom2.Element>> $dstr$extensionPointName$extensionElement = element$iv = iterator.next();
                boolean bl = false;
                Map.Entry<String, List<org.jdom2.Element>> entry = $dstr$extensionPointName$extensionElement;
                String string = entry.getKey();
                entry = $dstr$extensionPointName$extensionElement;
                List<org.jdom2.Element> extensionElement = entry.getValue();
                Map<String, List<org.jdom2.Element>> $this$getOrPut$iv = this.plugin.getExtensions();
                boolean $i$f$getOrPut = false;
                List value$iv = $this$getOrPut$iv.get(extensionPointName);
                if (value$iv == null) {
                    boolean bl2 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put((String)extensionPointName, answer$iv);
                    list = answer$iv;
                } else {
                    list = value$iv;
                }
                list.addAll((Collection<org.jdom2.Element>)extensionElement);
            }
            if (optionalPlugin instanceof IdePluginImpl) {
                this.mergeWith(this.plugin.getAppContainerDescriptor(), ((IdePluginImpl)optionalPlugin).getAppContainerDescriptor());
                this.mergeWith(this.plugin.getProjectContainerDescriptor(), ((IdePluginImpl)optionalPlugin).getProjectContainerDescriptor());
                this.mergeWith(this.plugin.getModuleContainerDescriptor(), ((IdePluginImpl)optionalPlugin).getModuleContainerDescriptor());
            }
        } else {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            PluginCreationResult<IdePlugin> pluginCreationResult2 = pluginCreationResult;
            if (pluginCreationResult2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.plugin.structure.base.plugin.PluginCreationFail<com.jetbrains.plugin.structure.intellij.plugin.IdePlugin>");
            }
            Iterable $this$forEach$iv = ((PluginCreationFail)pluginCreationResult2).getErrorsAndWarnings();
            boolean $i$f$filter = false;
            void var8_13 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PluginProblem e = (PluginProblem)element$iv$iv;
                boolean bl = false;
                if (!(e.getLevel() == PluginProblem.Level.ERROR)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List errors = (List)destination$iv$iv;
            String string = pluginDependency.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluginDependency.id");
            this.registerProblem(new OptionalDependencyDescriptorResolutionProblem(string, configurationFile, errors));
        }
    }

    private final void mergeWith(MutableIdePluginContentDescriptor $this$mergeWith, MutableIdePluginContentDescriptor other) {
        Collection collection = $this$mergeWith.getServices();
        Iterable iterable = other.getServices();
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        collection = $this$mergeWith.getComponents();
        iterable = other.getComponents();
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        collection = $this$mergeWith.getListeners();
        iterable = other.getListeners();
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        collection = $this$mergeWith.getExtensionPoints();
        iterable = other.getExtensionPoints();
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
    }

    public final void registerOptionalDependenciesConfigurationFilesCycleProblem(@NotNull List<String> configurationFileCycle) {
        Intrinsics.checkNotNullParameter(configurationFileCycle, (String)"configurationFileCycle");
        this.registerProblem((PluginProblem)new OptionalDependencyDescriptorCycleProblem(this.descriptorPath, configurationFileCycle));
    }

    public final void setIcons(@NotNull List<PluginIcon> icons) {
        Intrinsics.checkNotNullParameter(icons, (String)"icons");
        this.plugin.setIcons(icons);
    }

    public final void setThirdPartyDependencies(@NotNull List<ThirdPartyDependency> thirdPartyDependencies) {
        Intrinsics.checkNotNullParameter(thirdPartyDependencies, (String)"thirdPartyDependencies");
        this.plugin.setThirdPartyDependencies(thirdPartyDependencies);
    }

    public final void setPluginVersion(@NotNull String pluginVersion) {
        Intrinsics.checkNotNullParameter((Object)pluginVersion, (String)"pluginVersion");
        this.plugin.setPluginVersion(pluginVersion);
    }

    public final void setOriginalFile(@NotNull Path originalFile) {
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        this.plugin.setOriginalFile(originalFile);
    }

    /*
     * WARNING - void declaration
     */
    private final void setInfoFromBean(IdePluginImpl $this$setInfoFromBean, PluginBean bean, org.jdom2.Document document) {
        org.jdom2.Element rootElement;
        ProductDescriptorBean productDescriptorBean;
        Object it;
        boolean bl;
        Object dependency;
        boolean isModule;
        String string;
        String string2;
        String string3;
        String string4;
        String string5 = bean.name;
        if (string5 != null) {
            string4 = string5;
            string3 = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        } else {
            string3 = null;
        }
        $this$setInfoFromBean.setPluginName(string3);
        String string6 = bean.id;
        if (string6 == null || (string6 = ((Object)StringsKt.trim((CharSequence)(string4 = string6))).toString()) == null) {
            string6 = $this$setInfoFromBean.getPluginName();
        }
        $this$setInfoFromBean.setPluginId(string6);
        String string7 = bean.url;
        if (string7 != null) {
            string4 = string7;
            string2 = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        } else {
            string2 = null;
        }
        $this$setInfoFromBean.setUrl(string2);
        if (bean.pluginVersion != null) {
            String string8 = bean.pluginVersion;
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"bean.pluginVersion");
            string4 = string8;
            string = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        } else {
            string = null;
        }
        $this$setInfoFromBean.setPluginVersion(string);
        Set<String> set = $this$setInfoFromBean.getDefinedModules();
        List<String> list = bean.modules;
        Intrinsics.checkNotNullExpressionValue(list, (String)"bean.modules");
        set.addAll((Collection<String>)list);
        $this$setInfoFromBean.setUseIdeClassLoader(Intrinsics.areEqual((Object)bean.useIdeaClassLoader, (Object)true));
        $this$setInfoFromBean.setImplementationDetail(Intrinsics.areEqual((Object)bean.implementationDetail, (Object)true));
        IdeaVersionBean ideaVersionBean = bean.ideaVersion;
        if (ideaVersionBean != null) {
            CharSequence charSequence;
            $this$setInfoFromBean.setSinceBuild(ideaVersionBean.sinceBuild != null ? IdeVersion.createIdeVersion(ideaVersionBean.sinceBuild) : null);
            String untilBuild = ideaVersionBean.untilBuild;
            if (untilBuild != null && (charSequence = (CharSequence)untilBuild).length() > 0) {
                if (StringsKt.endsWith$default((String)untilBuild, (String)".*", (boolean)false, (int)2, null)) {
                    int n = StringsKt.lastIndexOf$default((CharSequence)untilBuild, (char)'.', (int)0, (boolean)false, (int)6, null);
                    StringBuilder stringBuilder = new StringBuilder();
                    String string9 = untilBuild;
                    int n2 = 0;
                    int n3 = n + 1;
                    String string10 = string9.substring(n2, n3);
                    Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    untilBuild = stringBuilder.append(string10).append(Integer.MAX_VALUE).toString();
                }
                $this$setInfoFromBean.setUntilBuild(IdeVersion.createIdeVersion(untilBuild));
            }
        }
        String modulePrefix = "com.intellij.modules.";
        if (bean.dependencies != null) {
            for (PluginDependencyBean pluginDependencyBean : bean.dependencies) {
                if (pluginDependencyBean.dependencyId == null) continue;
                String string11 = pluginDependencyBean.dependencyId;
                Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"dependencyBean.dependencyId");
                isModule = StringsKt.startsWith$default((String)string11, (String)modulePrefix, (boolean)false, (int)2, null);
                boolean isOptional = Intrinsics.areEqual((Object)Boolean.TRUE, (Object)pluginDependencyBean.optional);
                dependency = new PluginDependencyImpl(pluginDependencyBean.dependencyId, isOptional, isModule);
                Collection collection = $this$setInfoFromBean.getDependencies();
                collection.add(dependency);
                if (!((PluginDependencyImpl)dependency).isOptional() || pluginDependencyBean.configFile == null) continue;
                String string12 = pluginDependencyBean.configFile;
                Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"dependencyBean.configFile");
                String string13 = v2ModulePrefix.matches((CharSequence)string12) ? "../" + pluginDependencyBean.configFile : pluginDependencyBean.configFile;
                Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"if (v2ModulePrefix.match\u2026dependencyBean.configFile");
                this.optionalDependenciesConfigFiles.put((PluginDependency)dependency, string13);
            }
        }
        if (bean.dependenciesV2 != null) {
            for (PluginDependenciesModuleBean pluginDependenciesModuleBean : bean.dependenciesV2.modules) {
                if (pluginDependenciesModuleBean.dependencyId == null) continue;
                PluginDependencyImpl dependency2 = new PluginDependencyImpl(pluginDependenciesModuleBean.dependencyId, false, false);
                Collection isOptional = $this$setInfoFromBean.getDependencies();
                dependency = new PluginDependencyImpl("unresolved", true, false);
                isOptional.add(dependency);
                StringBuilder stringBuilder = new StringBuilder().append("../");
                String string14 = pluginDependenciesModuleBean.dependencyId;
                Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"dependencyBeanV2.dependencyId");
                this.optionalDependenciesConfigFiles.put(dependency2, stringBuilder.append(StringsKt.replace$default((String)string14, (String)"/", (String)".", (boolean)false, (int)4, null)).append(".xml").toString());
            }
            for (PluginDependenciesPluginBean pluginDependenciesPluginBean : bean.dependenciesV2.plugins) {
                if (pluginDependenciesPluginBean.dependencyId == null) continue;
                String string15 = pluginDependenciesPluginBean.dependencyId;
                Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"dependencyBeanV2.dependencyId");
                isModule = StringsKt.startsWith$default((String)string15, (String)modulePrefix, (boolean)false, (int)2, null);
                PluginDependencyImpl dependency3 = new PluginDependencyImpl(pluginDependenciesPluginBean.dependencyId, false, isModule);
                dependency = $this$setInfoFromBean.getDependencies();
                dependency.add(dependency3);
            }
        }
        if (bean.contentDependencies != null) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMapTo$iv$iv2;
            List<PluginContentBean> list2 = bean.contentDependencies;
            Intrinsics.checkNotNullExpressionValue(list2, (String)"bean.contentDependencies");
            Iterable $this$flatMap$iv = list2;
            boolean $i$f$flatMap = false;
            Iterable dependency3 = $this$flatMap$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
                PluginContentBean it2 = (PluginContentBean)element$iv$iv;
                boolean bl2 = false;
                Iterable list$iv$iv = it2.modules;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List list3 = (List)destination$iv$iv;
            List<PluginContentBean> list4 = bean.contentDependencies;
            Intrinsics.checkNotNullExpressionValue(list4, (String)"bean.contentDependencies");
            Iterable $this$flatMap$iv2 = list4;
            boolean $i$f$flatMap2 = false;
            destination$iv$iv = $this$flatMap$iv2;
            Object destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo222 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                PluginContentBean it3 = (PluginContentBean)element$iv$iv;
                bl = false;
                Iterable list$iv$iv = it3.plugins;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List plugins = (List)destination$iv$iv2;
            for (Object dependencyBeanContent : list3) {
                if (((PluginDependenciesModuleBean)dependencyBeanContent).dependencyId == null) continue;
                dependency = new PluginDependencyImpl(((PluginDependenciesModuleBean)dependencyBeanContent).dependencyId, true, false);
                destination$iv$iv2 = $this$setInfoFromBean.getDependencies();
                PluginDependencyImpl $i$f$flatMapTo222 = new PluginDependencyImpl("unresolved", true, false);
                destination$iv$iv2.add($i$f$flatMapTo222);
                StringBuilder stringBuilder = new StringBuilder().append("../");
                String string16 = ((PluginDependenciesModuleBean)dependencyBeanContent).dependencyId;
                Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"dependencyBeanContent.dependencyId");
                this.optionalDependenciesConfigFiles.put((PluginDependency)dependency, stringBuilder.append(StringsKt.replace$default((String)string16, (String)"/", (String)".", (boolean)false, (int)4, null)).append(".xml").toString());
            }
            for (Object dependencyBeanContent : plugins) {
                if (((PluginDependenciesPluginBean)dependencyBeanContent).dependencyId == null) continue;
                dependency = new PluginDependencyImpl(((PluginDependenciesPluginBean)dependencyBeanContent).dependencyId, true, false);
                destination$iv$iv2 = $this$setInfoFromBean.getDependencies();
                destination$iv$iv2.add(dependency);
            }
        }
        List<String> list5 = bean.incompatibleModules;
        if (list5 != null) {
            void $this$filterTo$iv$iv;
            Iterable iterable = list5;
            boolean $i$f$filter = false;
            Iterable dependencyBeanContent = iterable;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it4 = (String)element$iv$iv;
                boolean bl3 = false;
                String string17 = it4;
                if (!(string17 != null ? StringsKt.startsWith$default((String)string17, (String)modulePrefix, (boolean)false, (int)2, null) : false)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list6 = (List)destination$iv$iv;
            it = list6;
            boolean bl4 = false;
            destination$iv$iv = $this$setInfoFromBean.getIncompatibleModules();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)((Iterable)it));
        }
        PluginVendorBean pluginVendorBean = bean.vendor;
        if (pluginVendorBean != null) {
            String string18;
            IdePluginImpl idePluginImpl = $this$setInfoFromBean;
            if (pluginVendorBean.name != null) {
                void $this$trim$iv;
                String string19 = pluginVendorBean.name;
                Intrinsics.checkNotNullExpressionValue((Object)string19, (String)"vendorBean.name");
                it = string19;
                IdePluginImpl idePluginImpl2 = idePluginImpl;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it5 = $this$trim$iv$iv.charAt(index$iv$iv);
                    bl = false;
                    boolean bl5 = match$iv$iv = Intrinsics.compare((int)it5, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                String string20 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                idePluginImpl = idePluginImpl2;
                string18 = string20;
            } else {
                string18 = null;
            }
            idePluginImpl.setVendor(string18);
            $this$setInfoFromBean.setVendorUrl(pluginVendorBean.url);
            $this$setInfoFromBean.setVendorEmail(pluginVendorBean.email);
        }
        if ((productDescriptorBean = bean.productDescriptor) != null) {
            String string21 = productDescriptorBean.code;
            Intrinsics.checkNotNullExpressionValue((Object)string21, (String)"productDescriptorBean.code");
            LocalDate localDate = LocalDate.parse(productDescriptorBean.releaseDate, releaseDateFormatter);
            Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"LocalDate.parse(productD\u2026te, releaseDateFormatter)");
            $this$setInfoFromBean.setProductDescriptor(new ProductDescriptor(string21, localDate, Integer.parseInt(productDescriptorBean.releaseVersion), Intrinsics.areEqual((Object)productDescriptorBean.eap, (Object)"true"), Intrinsics.areEqual((Object)productDescriptorBean.optional, (Object)"true")));
        }
        $this$setInfoFromBean.setChangeNotes(bean.changeNotes);
        $this$setInfoFromBean.setDescription(bean.description);
        org.jdom2.Element element = rootElement = document.getRootElement();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"rootElement");
        this.readActions(element, $this$setInfoFromBean);
        this.readExtensions(rootElement, $this$setInfoFromBean);
        this.readExtensionPoints(rootElement, $this$setInfoFromBean);
        this.readListeners(rootElement, "applicationListeners", $this$setInfoFromBean.getAppContainerDescriptor());
        this.readListeners(rootElement, "projectListeners", $this$setInfoFromBean.getProjectContainerDescriptor());
        this.readComponents(rootElement, "application-components", $this$setInfoFromBean.getAppContainerDescriptor());
        this.readComponents(rootElement, "project-components", $this$setInfoFromBean.getProjectContainerDescriptor());
        this.readComponents(rootElement, "module-components", $this$setInfoFromBean.getModuleContainerDescriptor());
    }

    private final void readActions(org.jdom2.Element rootElement, IdePluginImpl idePlugin) {
        for (org.jdom2.Element actionsRoot : rootElement.getChildren("actions")) {
            Collection collection = idePlugin.getActions();
            org.jdom2.Element element = actionsRoot;
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"actionsRoot");
            List list = element.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"actionsRoot.children");
            Iterable iterable = list;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void readExtensions(org.jdom2.Element rootElement, IdePluginImpl idePlugin) {
        var4_3 = rootElement.getChildren("extensions").iterator();
        while (var4_3.hasNext()) {
            v0 = extensionsRoot = (org.jdom2.Element)var4_3.next();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"extensionsRoot");
            var6_6 = v0.getChildren().iterator();
            block6: while (var6_6.hasNext()) {
                block9: {
                    v1 = extensionElement = (org.jdom2.Element)var6_6.next();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"extensionElement");
                    var8_8 = var7_7 = this.extractEPName(v1);
                    switch (var8_8.hashCode()) {
                        case -698444602: {
                            if (!var8_8.equals("com.intellij.projectService")) ** break;
                            break;
                        }
                        case -1286155777: {
                            if (!var8_8.equals("com.intellij.moduleService")) ** break;
                            break block9;
                        }
                        case -1947960913: {
                            if (!var8_8.equals("com.intellij.applicationService")) ** break;
                            var9_9 = idePlugin.getAppContainerDescriptor().getServices();
                            var10_10 = this.readServiceDescriptor(extensionElement, (String)epName);
                            var9_9.add(var10_10);
                            continue block6;
                        }
                    }
                    var9_9 = idePlugin.getProjectContainerDescriptor().getServices();
                    var10_11 = this.readServiceDescriptor(extensionElement, (String)epName);
                    var9_9.add(var10_11);
                    continue;
                }
                var9_9 = idePlugin.getModuleContainerDescriptor().getServices();
                var10_12 = this.readServiceDescriptor(extensionElement, (String)epName);
                var9_9.add(var10_12);
                continue;
                $this$getOrPut$iv = idePlugin.getExtensions();
                $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(epName);
                if (value$iv == null) {
                    $i$a$-getOrPut-PluginCreator$readExtensions$1 = false;
                    answer$iv = new ArrayList<E>();
                    $this$getOrPut$iv.put((String)epName, answer$iv);
                    v2 = answer$iv;
                } else {
                    v2 = value$iv;
                }
                v2.add((org.jdom2.Element)extensionElement);
            }
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    private final void readExtensionPoints(org.jdom2.Element rootElement, IdePluginImpl idePlugin) {
        Iterator iterator = rootElement.getChildren("extensionPoints").iterator();
        block10: while (iterator.hasNext()) {
            org.jdom2.Element extensionPointsRoot;
            org.jdom2.Element element = extensionPointsRoot = (org.jdom2.Element)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"extensionPointsRoot");
            Iterator iterator2 = element.getChildren().iterator();
            while (true) {
                String extensionPointName;
                boolean bl;
                Object object;
                MutableIdePluginContentDescriptor mutableIdePluginContentDescriptor;
                org.jdom2.Element extensionPoint;
                if (!iterator2.hasNext()) continue block10;
                org.jdom2.Element element2 = extensionPoint = (org.jdom2.Element)iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"extensionPoint");
                if (this.getExtensionPointName(element2) == null) continue;
                if (extensionPoint.getAttributeValue("area") == null) {
                    mutableIdePluginContentDescriptor = idePlugin.getAppContainerDescriptor();
                } else {
                    String string;
                    int n = -1;
                    switch (string.hashCode()) {
                        case -660214604: {
                            if (string.equals("IDEA_MODULE")) {
                                n = 1;
                            }
                            break;
                        }
                        case 1490056168: {
                            if (string.equals("IDEA_APPLICATION")) {
                                n = 2;
                            }
                            break;
                        }
                        case -528560719: {
                            if (string.equals("IDEA_PROJECT")) {
                                n = 3;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 2: {
                            mutableIdePluginContentDescriptor = idePlugin.getAppContainerDescriptor();
                            break;
                        }
                        case 3: {
                            mutableIdePluginContentDescriptor = idePlugin.getProjectContainerDescriptor();
                            break;
                        }
                        case 1: {
                            mutableIdePluginContentDescriptor = idePlugin.getModuleContainerDescriptor();
                            break;
                        }
                        default: {
                            mutableIdePluginContentDescriptor = null;
                        }
                    }
                }
                if (mutableIdePluginContentDescriptor == null) continue;
                MutableIdePluginContentDescriptor containerDescriptor = mutableIdePluginContentDescriptor;
                String string = extensionPoint.getAttributeValue("dynamic");
                if (string != null) {
                    object = string;
                    bl = Boolean.parseBoolean((String)object);
                } else {
                    bl = false;
                }
                boolean isDynamic = bl;
                object = containerDescriptor.getExtensionPoints();
                IdePluginContentDescriptor.ExtensionPoint extensionPoint2 = new IdePluginContentDescriptor.ExtensionPoint(extensionPointName, isDynamic);
                object.add(extensionPoint2);
            }
            break;
        }
        return;
    }

    private final String getExtensionPointName(org.jdom2.Element extensionPoint) {
        String string = extensionPoint.getAttributeValue("qualifiedName");
        if (string != null) {
            String string2;
            String it = string2 = string;
            boolean bl = false;
            return it;
        }
        String string3 = extensionPoint.getAttributeValue("name");
        if (string3 == null) {
            return null;
        }
        String name = string3;
        String string4 = this.getPluginId();
        if (string4 == null) {
            return null;
        }
        String pluginId = string4;
        return pluginId + '.' + name;
    }

    public final boolean getAttributeBooleanValue(@NotNull org.jdom2.Element $this$getAttributeBooleanValue, @NotNull String attname, boolean bl) {
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)$this$getAttributeBooleanValue, (String)"$this$getAttributeBooleanValue");
        Intrinsics.checkNotNullParameter((Object)attname, (String)"attname");
        String string = $this$getAttributeBooleanValue.getAttributeValue(attname);
        if (string != null) {
            String string2 = string;
            bl2 = Boolean.parseBoolean(string2);
        } else {
            bl2 = bl;
        }
        return bl2;
    }

    /*
     * Unable to fully structure code
     */
    private final IdePluginContentDescriptor.PreloadMode readServicePreloadMode(org.jdom2.Element $this$readServicePreloadMode) {
        v0 = $this$readServicePreloadMode.getAttributeValue("preload");
        if (v0 == null) ** GOTO lbl36
        var2_2 = v0;
        tmp = -1;
        switch (var2_2.hashCode()) {
            case 789548717: {
                if (!var2_2.equals("notLightEdit")) break;
                tmp = 1;
                break;
            }
            case 3569038: {
                if (!var2_2.equals("true")) break;
                tmp = 2;
                break;
            }
            case 93223254: {
                if (!var2_2.equals("await")) break;
                tmp = 3;
                break;
            }
            case -696054932: {
                if (!var2_2.equals("notHeadless")) break;
                tmp = 4;
                break;
            }
        }
        switch (tmp) {
            case 2: {
                v1 = IdePluginContentDescriptor.PreloadMode.TRUE;
                break;
            }
            case 3: {
                v1 = IdePluginContentDescriptor.PreloadMode.AWAIT;
                break;
            }
            case 4: {
                v1 = IdePluginContentDescriptor.PreloadMode.NOT_HEADLESS;
                break;
            }
            case 1: {
                v1 = IdePluginContentDescriptor.PreloadMode.NOT_LIGHT_EDIT;
                break;
            }
lbl36:
            // 1 sources

            v1 = IdePluginContentDescriptor.PreloadMode.FALSE;
            break;
            default: {
                it = var3_3 = IdePluginContentDescriptor.PreloadMode.FALSE;
                $i$a$-also-PluginCreator$readServicePreloadMode$1 = false;
                PluginCreator.LOG.error("Unknown preload mode value '" + $this$readServicePreloadMode.getAttributeValue("preload") + '\'');
                v1 = var3_3;
            }
        }
        return v1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final IdePluginContentDescriptor.ClientKind readServiceClient(org.jdom2.Element $this$readServiceClient) {
        IdePluginContentDescriptor.ClientKind clientKind;
        String string = $this$readServiceClient.getAttributeValue("client");
        if (string == null) return null;
        switch (string) {
            case "all": {
                clientKind = IdePluginContentDescriptor.ClientKind.ALL;
                return clientKind;
            }
            case "local": {
                clientKind = IdePluginContentDescriptor.ClientKind.LOCAL;
                return clientKind;
            }
            case "guest": {
                clientKind = IdePluginContentDescriptor.ClientKind.GUEST;
                return clientKind;
            }
            default: {
                Object var3_3 = null;
                Void it = var3_3;
                boolean bl = false;
                LOG.error("Unknown client value: '" + $this$readServiceClient.getAttributeValue("client") + '\'');
                clientKind = var3_3;
            }
        }
        return clientKind;
    }

    private final IdePluginContentDescriptor.ServiceDescriptor readServiceDescriptor(org.jdom2.Element extensionElement, String epName) {
        String serviceInterface = extensionElement.getAttributeValue("serviceInterface");
        String serviceImplementation = extensionElement.getAttributeValue("serviceImplementation");
        CharSequence charSequence = epName;
        String string = "(Service)|(com.intellij.)";
        string = new Regex(string);
        String string2 = "";
        charSequence = string.replace(charSequence, string2);
        String string3 = ((String)charSequence).toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase()");
        IdePluginContentDescriptor.ServiceType serviceType = IdePluginContentDescriptor.ServiceType.valueOf(string3);
        String testServiceImplementation = extensionElement.getAttributeValue("testServiceImplementation");
        String headlessImplementation = extensionElement.getAttributeValue("headlessImplementation");
        String configurationSchemaKey = extensionElement.getAttributeValue("configurationSchemaKey");
        boolean overrides = this.getAttributeBooleanValue(extensionElement, "overrides", false);
        IdePluginContentDescriptor.PreloadMode preload = this.readServicePreloadMode(extensionElement);
        IdePluginContentDescriptor.ClientKind client = this.readServiceClient(extensionElement);
        IdePluginContentDescriptor.Os os = null;
        return new IdePluginContentDescriptor.ServiceDescriptor(serviceInterface, serviceImplementation, serviceType, testServiceImplementation, headlessImplementation, overrides, configurationSchemaKey, preload, client, os);
    }

    private final String extractEPName(org.jdom2.Element extensionElement) {
        String string;
        String parentNs;
        String point = extensionElement.getAttributeValue("point");
        if (point != null) {
            return point;
        }
        org.jdom2.Element element = extensionElement.getParentElement();
        String string2 = parentNs = element != null ? element.getAttributeValue("defaultExtensionNs") : null;
        if (parentNs != null) {
            string = parentNs + '.' + extensionElement.getName();
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            Namespace namespace = extensionElement.getNamespace();
            Intrinsics.checkNotNullExpressionValue((Object)namespace, (String)"extensionElement.namespace");
            string = stringBuilder.append(namespace.getURI()).append('.').append(extensionElement.getName()).toString();
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final IdePluginContentDescriptor.Os readOs(org.jdom2.Element $this$readOs) {
        IdePluginContentDescriptor.Os os;
        String string = $this$readOs.getAttributeValue("os");
        if (string == null) return null;
        switch (string) {
            case "mac": {
                os = IdePluginContentDescriptor.Os.mac;
                return os;
            }
            case "linux": {
                os = IdePluginContentDescriptor.Os.linux;
                return os;
            }
            case "windows": {
                os = IdePluginContentDescriptor.Os.windows;
                return os;
            }
            case "unix": {
                os = IdePluginContentDescriptor.Os.unix;
                return os;
            }
            case "freebsd": {
                os = IdePluginContentDescriptor.Os.freebsd;
                return os;
            }
            default: {
                Object var3_3 = null;
                Void it = var3_3;
                boolean bl = false;
                LOG.error("Unknown OS: " + $this$readOs.getAttributeValue("os"));
                os = var3_3;
            }
        }
        return os;
    }

    private final void readListeners(org.jdom2.Element rootElement, String listenersName, MutableIdePluginContentDescriptor containerDescriptor) {
        Iterator iterator = rootElement.getChildren(listenersName).iterator();
        while (iterator.hasNext()) {
            org.jdom2.Element listenersRoot;
            org.jdom2.Element element = listenersRoot = (org.jdom2.Element)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"listenersRoot");
            for (org.jdom2.Element listener : element.getChildren()) {
                String className = listener.getAttributeValue("class");
                String topicName = listener.getAttributeValue("topic");
                org.jdom2.Element element2 = listener;
                Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"listener");
                boolean isActiveInTestMode = this.getAttributeBooleanValue(element2, "activeInTestMode", true);
                boolean isActiveInHeadlessMode = this.getAttributeBooleanValue(listener, "activeInHeadlessMode", true);
                IdePluginContentDescriptor.Os os = this.readOs(listener);
                if (className == null) {
                    this.registerProblem(new ElementMissingAttribute("listener", "class"));
                }
                if (topicName == null) {
                    this.registerProblem(new ElementMissingAttribute("listener", "topic"));
                }
                if (className == null || topicName == null) continue;
                Object object = StringsKt.replace$default((String)listenersName, (String)"Listeners", (String)"", (boolean)false, (int)4, null);
                String string = ((String)object).toUpperCase();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase()");
                IdePluginContentDescriptor.ListenerType listenerType = IdePluginContentDescriptor.ListenerType.valueOf(string);
                object = containerDescriptor.getListeners();
                IdePluginContentDescriptor.ListenerDescriptor listenerDescriptor = new IdePluginContentDescriptor.ListenerDescriptor(topicName, className, listenerType, isActiveInTestMode, isActiveInHeadlessMode, os);
                object.add(listenerDescriptor);
            }
        }
    }

    private final void readComponents(org.jdom2.Element rootElement, String componentsArea, MutableIdePluginContentDescriptor containerDescriptor) {
        for (org.jdom2.Element componentsRoot : rootElement.getChildren(componentsArea)) {
            for (org.jdom2.Element component : componentsRoot.getChildren("component")) {
                org.jdom2.Element element = component.getChild("interface-class");
                String interfaceClass = element != null ? element.getText() : null;
                org.jdom2.Element element2 = component.getChild("implementation-class");
                String implementationClass = element2 != null ? element2.getText() : null;
                if (implementationClass == null) continue;
                Collection collection = containerDescriptor.getComponents();
                IdePluginContentDescriptor.ComponentConfig componentConfig = new IdePluginContentDescriptor.ComponentConfig(interfaceClass, implementationClass);
                collection.add(componentConfig);
            }
        }
    }

    private final void validatePluginBean(PluginBean bean, boolean validateDescriptor) {
        if (validateDescriptor || bean.url != null) {
            this.validateBeanUrl(bean.url);
        }
        if (validateDescriptor || bean.id != null) {
            this.validateId(bean.id);
        }
        if (validateDescriptor || bean.name != null) {
            this.validateName(bean.name);
        }
        if (validateDescriptor || bean.pluginVersion != null) {
            this.validateVersion(bean.pluginVersion, validateDescriptor);
        }
        if (validateDescriptor || bean.description != null) {
            this.validateDescription(bean.description, validateDescriptor);
        }
        if (validateDescriptor || bean.changeNotes != null) {
            this.validateChangeNotes(bean.changeNotes);
        }
        if (validateDescriptor || bean.vendor != null) {
            this.validateVendor(bean.vendor);
        }
        if (validateDescriptor || bean.ideaVersion != null) {
            this.validateIdeaVersion(bean.ideaVersion);
        }
        if (validateDescriptor || bean.productDescriptor != null) {
            this.validateProductDescriptor(bean.productDescriptor);
        }
        if (bean.dependencies != null) {
            List<PluginDependencyBean> list = bean.dependencies;
            Intrinsics.checkNotNullExpressionValue(list, (String)"bean.dependencies");
            this.validateDependencies(list);
        }
        List<String> list = bean.modules;
        if (list != null) {
            boolean bl;
            block15: {
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        String string = it;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it");
                        CharSequence charSequence = string;
                        boolean bl3 = charSequence.length() == 0;
                        if (!bl3) continue;
                        bl = true;
                        break block15;
                    }
                    bl = false;
                }
            }
            if (bl) {
                this.registerProblem((PluginProblem)new InvalidModuleBean(this.descriptorPath));
            }
        }
    }

    private final void validateDependencies(List<? extends PluginDependencyBean> dependencies) {
        for (PluginDependencyBean pluginDependencyBean : dependencies) {
            block6: {
                block5: {
                    CharSequence charSequence = pluginDependencyBean.dependencyId;
                    if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) break block5;
                    String string = pluginDependencyBean.dependencyId;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dependencyBean.dependencyId");
                    if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null)) break block6;
                }
                String string = pluginDependencyBean.dependencyId;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dependencyBean.dependencyId");
                this.registerProblem((PluginProblem)new InvalidDependencyId(this.descriptorPath, string));
                continue;
            }
            if (Intrinsics.areEqual((Object)pluginDependencyBean.optional, (Object)true) && pluginDependencyBean.configFile == null) {
                String string = pluginDependencyBean.dependencyId;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dependencyBean.dependencyId");
                this.registerProblem(new OptionalDependencyConfigFileNotSpecified(string));
                continue;
            }
            if (!Intrinsics.areEqual((Object)pluginDependencyBean.optional, (Object)false)) continue;
            String string = pluginDependencyBean.dependencyId;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dependencyBean.dependencyId");
            this.registerProblem(new SuperfluousNonOptionalDependencyDeclaration(string));
        }
    }

    private final void validateProductDescriptor(ProductDescriptorBean productDescriptor) {
        block2: {
            String it;
            String string;
            if (productDescriptor == null) break block2;
            this.validateProductCode(productDescriptor.code);
            this.validateReleaseDate(productDescriptor.releaseDate);
            this.validateReleaseVersion(productDescriptor.releaseVersion);
            String string2 = productDescriptor.eap;
            if (string2 != null) {
                it = string = string2;
                boolean bl = false;
                this.validateEapFlag(it);
            }
            String string3 = productDescriptor.optional;
            if (string3 != null) {
                it = string = string3;
                boolean bl = false;
                this.validateOptionalFlag(it);
            }
        }
    }

    private final void validateProductCode(String productCode) {
        CharSequence charSequence = productCode;
        if (charSequence == null || charSequence.length() == 0) {
            this.registerProblem((PluginProblem)new PropertyNotSpecified("code", this.descriptorPath));
        } else {
            this.validatePropertyLength("Product code", productCode, 15);
        }
    }

    private final void validateReleaseDate(String releaseDate) {
        CharSequence charSequence = releaseDate;
        if (charSequence == null || charSequence.length() == 0) {
            this.registerProblem((PluginProblem)new PropertyNotSpecified("release-date", this.descriptorPath));
        } else {
            try {
                LocalDate.parse(releaseDate, releaseDateFormatter);
            }
            catch (DateTimeParseException e) {
                this.registerProblem(ReleaseDateWrongFormat.INSTANCE);
            }
        }
    }

    private final void validateReleaseVersion(String releaseVersion) {
        CharSequence charSequence = releaseVersion;
        if (charSequence == null || charSequence.length() == 0) {
            this.registerProblem((PluginProblem)new PropertyNotSpecified("release-version", this.descriptorPath));
        } else {
            try {
                Integer.valueOf(releaseVersion);
            }
            catch (NumberFormatException e) {
                this.registerProblem((PluginProblem)new NotNumber("release-version", this.descriptorPath));
            }
        }
    }

    private final void validateEapFlag(String eapFlag) {
        this.validateBooleanFlag(eapFlag, "eap");
    }

    private final void validateOptionalFlag(String optionalFlag) {
        this.validateBooleanFlag(optionalFlag, "optional");
    }

    private final void validateBooleanFlag(String flag, String name) {
        if (Intrinsics.areEqual((Object)flag, (Object)"true") ^ true && Intrinsics.areEqual((Object)flag, (Object)"false") ^ true) {
            this.registerProblem((PluginProblem)new NotBoolean(name, this.descriptorPath));
        }
    }

    private final void validateBeanUrl(String beanUrl) {
        if (beanUrl != null) {
            this.validatePropertyLength("plugin url", beanUrl, 255);
        }
    }

    private final void validateVersion(String pluginVersion, boolean validateDescriptor) {
        if (!validateDescriptor && pluginVersion == null) {
            return;
        }
        CharSequence charSequence = pluginVersion;
        if (charSequence == null || charSequence.length() == 0) {
            this.registerProblem((PluginProblem)new PropertyNotSpecified("version", this.descriptorPath));
        } else {
            this.validatePropertyLength("version", pluginVersion, 64);
        }
    }

    private final void validatePlugin(IdePluginImpl plugin) {
        int n;
        String string;
        Map.Entry it;
        boolean bl;
        Object object;
        Iterator $this$mapTo$iv$iv;
        List<PluginDependency> dependencies = plugin.getDependencies();
        Object $this$map$iv = dependencies;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean bl2 = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv = iterator.next();
            PluginDependency pluginDependency = (PluginDependency)item$iv$iv;
            object = destination$iv$iv;
            bl = false;
            string = it.getId();
            object.add(string);
        }
        Iterable $this$groupingBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupingBy = false;
        Map $this$filterValues$iv = GroupingKt.eachCount((Grouping)((Grouping)new Grouping<String, String>($this$groupingBy$iv){
            final /* synthetic */ Iterable $this_groupingBy;
            {
                this.$this_groupingBy = $receiver;
            }

            @NotNull
            public Iterator<String> sourceIterator() {
                return this.$this_groupingBy.iterator();
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public Object keyOf(Object element) {
                void var2_2;
                String it = (String)element;
                boolean bl = false;
                return var2_2;
            }
        }));
        boolean $i$f$filterValues = false;
        Object result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
            int it2 = ((Number)entry.getValue()).intValue();
            boolean bl3 = false;
            if (!(it2 > 1)) continue;
            ((HashMap)result$iv).put(entry.getKey(), entry.getValue());
        }
        $this$map$iv = (Map)result$iv;
        $i$f$map = false;
        result$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean bl4 = false;
        Iterator it2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (it2.hasNext()) {
            Map.Entry item$iv$iv;
            it = item$iv$iv = it2.next();
            object = destination$iv$iv;
            bl = false;
            string = (String)it.getKey();
            object.add(string);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string2 = (String)element$iv;
            boolean bl5 = false;
            String string3 = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"duplicatedDependencyId");
            this.registerProblem(new DuplicatedDependencyWarning(string3));
        }
        Iterable $this$count$iv = dependencies;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object t : $this$count$iv) {
                int n2;
                PluginDependency it3 = (PluginDependency)t;
                boolean bl6 = false;
                if (!it3.isModule() || (n2 = ++count$iv) >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        if (n == 0) {
            this.registerProblem(new NoModuleDependencies(this.descriptorPath));
        }
        IdeVersion sinceBuild = plugin.getSinceBuild();
        IdeVersion untilBuild = plugin.getUntilBuild();
        if (sinceBuild != null && untilBuild != null && sinceBuild.compareTo(untilBuild) > 0) {
            this.registerProblem((PluginProblem)new SinceBuildGreaterThanUntilBuild(this.descriptorPath, sinceBuild, untilBuild));
        }
        IdeVersion ideVersion = IdeVersion.createIdeVersion("193");
        Intrinsics.checkNotNullExpressionValue((Object)ideVersion, (String)"IdeVersion.createIdeVersion(\"193\")");
        IdeVersion listenersAvailableSinceBuild = ideVersion;
        if (sinceBuild != null && sinceBuild.compareTo(listenersAvailableSinceBuild) < 0) {
            Object object2 = plugin.getAppContainerDescriptor().getListeners();
            if (!object2.isEmpty()) {
                this.registerProblem(new ElementAvailableOnlySinceNewerVersion("applicationListeners", listenersAvailableSinceBuild, sinceBuild, untilBuild));
            }
            if (!(object2 = (Collection)plugin.getProjectContainerDescriptor().getListeners()).isEmpty()) {
                this.registerProblem(new ElementAvailableOnlySinceNewerVersion("projectListeners", listenersAvailableSinceBuild, sinceBuild, untilBuild));
            }
        }
    }

    private final void resolveDocumentAndValidateBean(org.jdom2.Document originalDocument, Path documentPath, String documentName, ResourceResolver pathResolver, boolean validateDescriptor) {
        org.jdom2.Document document = this.resolveXIncludesOfDocument(originalDocument, documentName, pathResolver, documentPath);
        if (document == null) {
            return;
        }
        org.jdom2.Document document2 = document;
        PluginBean pluginBean = this.readDocumentIntoXmlBean(document2);
        if (pluginBean == null) {
            return;
        }
        PluginBean bean = pluginBean;
        this.validatePluginBean(bean, validateDescriptor);
        if (this.hasErrors()) {
            return;
        }
        this.plugin.setUnderlyingDocument(document2);
        this.setInfoFromBean(this.plugin, bean, document2);
        List<IdeTheme> list = this.readPluginThemes(this.plugin, documentPath, pathResolver);
        if (list == null) {
            return;
        }
        List<IdeTheme> themeFiles = list;
        this.plugin.getDeclaredThemes().addAll((Collection<IdeTheme>)themeFiles);
        this.validatePlugin(this.plugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<IdeTheme> readPluginThemes(IdePlugin plugin, Path document, ResourceResolver pathResolver) {
        List list;
        String string;
        Object element$iv$iv;
        List<org.jdom2.Element> list2 = plugin.getExtensions().get(INTELLIJ_THEME_EXTENSION);
        if (list2 != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = list2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv$iv;
                element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                org.jdom2.Element it = (org.jdom2.Element)element$iv$iv;
                boolean bl2 = false;
                Attribute attribute = it.getAttribute("path");
                String string2 = attribute != null ? attribute.getValue() : null;
                if (string2 == null) continue;
                String it$iv$iv = string = string2;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List themePaths = list;
        ArrayList<IdeTheme> themes = new ArrayList<IdeTheme>();
        for (String themePath : themePaths) {
            String absolutePath = StringsKt.startsWith$default((String)themePath, (String)"/", (boolean)false, (int)2, null) ? themePath : '/' + themePath;
            ResourceResolver.Result resolvedTheme = pathResolver.resolveResource(absolutePath, document);
            if (resolvedTheme instanceof ResourceResolver.Result.Found) {
                Closeable closeable = (Closeable)((Object)resolvedTheme);
                Throwable throwable = null;
                try {
                    IdeTheme ideTheme;
                    ResourceResolver.Result.Found it = (ResourceResolver.Result.Found)closeable;
                    boolean bl = false;
                    try {
                        element$iv$iv = it.getResourceStream();
                        Charset charset = Charsets.UTF_8;
                        String themeJson = TextStreamsKt.readText((Reader)new InputStreamReader((InputStream)element$iv$iv, charset));
                        ideTheme = (IdeTheme)json.readValue(themeJson, IdeTheme.class);
                    }
                    catch (Exception e) {
                        this.registerProblem((PluginProblem)new UnableToReadTheme(this.descriptorPath, themePath, e.getLocalizedMessage()));
                        string = null;
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        return string;
                    }
                    IdeTheme theme = ideTheme;
                    boolean bl4 = themes.add(theme);
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    continue;
                }
            }
            if (resolvedTheme instanceof ResourceResolver.Result.NotFound) {
                this.registerProblem((PluginProblem)new UnableToFindTheme(this.descriptorPath, themePath));
                continue;
            }
            if (!(resolvedTheme instanceof ResourceResolver.Result.Failed)) continue;
            this.registerProblem((PluginProblem)new UnableToReadTheme(this.descriptorPath, themePath, ((ResourceResolver.Result.Failed)resolvedTheme).getException().getLocalizedMessage()));
        }
        return themes;
    }

    private final org.jdom2.Document resolveXIncludesOfDocument(org.jdom2.Document document, String presentablePath, ResourceResolver pathResolver, Path documentPath) {
        org.jdom2.Document document2;
        try {
            document2 = XIncluder.Companion.resolveXIncludes(document, presentablePath, pathResolver, documentPath);
        }
        catch (XIncluderException e) {
            LOG.info("Unable to resolve <xi:include> elements of descriptor '" + this.descriptorPath + "' from '" + this.pluginFileName + '\'', (Throwable)e);
            this.registerProblem((PluginProblem)new XIncludeResolutionErrors(this.descriptorPath, e.getMessage()));
            document2 = null;
        }
        return document2;
    }

    private final PluginBean readDocumentIntoXmlBean(org.jdom2.Document document) {
        PluginBean pluginBean;
        try {
            pluginBean = PluginBeanExtractor.INSTANCE.extractPluginBean(document);
        }
        catch (Exception e) {
            this.registerProblem((PluginProblem)new UnableToReadDescriptor(this.descriptorPath, e.getLocalizedMessage()));
            LOG.info("Unable to read plugin descriptor " + this.descriptorPath + " of " + this.pluginFileName, (Throwable)e);
            pluginBean = null;
        }
        return pluginBean;
    }

    private final void registerProblem(PluginProblem problem) {
        Collection collection = this.problems;
        collection.add(problem);
    }

    private final boolean hasErrors() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.problems;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PluginProblem it = (PluginProblem)element$iv;
                    boolean bl2 = false;
                    if (!(it.getLevel() == PluginProblem.Level.ERROR)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final void validateId(String id) {
        if (id != null) {
            if (StringsKt.isBlank((CharSequence)id)) {
                this.registerProblem((PluginProblem)new PropertyNotSpecified("id", null, 2, null));
            } else if (Intrinsics.areEqual((Object)"com.your.company.unique.plugin.id", (Object)id)) {
                this.registerProblem((PluginProblem)new PropertyWithDefaultValue(this.descriptorPath, PropertyWithDefaultValue.DefaultProperty.ID, id));
            } else {
                this.validatePropertyLength("id", id, 255);
                this.validateNewlines("id", id);
            }
        }
    }

    private final void validateName(String name) {
        CharSequence charSequence = name;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            this.registerProblem((PluginProblem)new PropertyNotSpecified("name", this.descriptorPath));
        } else {
            boolean bl;
            block9: {
                Iterable $this$any$iv = DEFAULT_TEMPLATE_NAMES;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.equals((String)it, (String)name, (boolean)true)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (bl) {
                this.registerProblem((PluginProblem)new PropertyWithDefaultValue(this.descriptorPath, PropertyWithDefaultValue.DefaultProperty.NAME, name));
            } else {
                Object v1;
                block10: {
                    Iterable iterable = PLUGIN_NAME_RESTRICTED_WORDS;
                    Iterable iterable2 = iterable;
                    Iterator iterator = iterable2.iterator();
                    while (iterator.hasNext()) {
                        Object t = iterator.next();
                        String it = (String)t;
                        boolean bl3 = false;
                        if (!StringsKt.contains((CharSequence)name, (CharSequence)it, (boolean)true)) continue;
                        v1 = t;
                        break block10;
                    }
                    v1 = null;
                }
                String templateWord = v1;
                if (templateWord != null) {
                    this.registerProblem(new TemplateWordInPluginName(this.descriptorPath, templateWord));
                }
                this.validatePropertyLength("name", name, 64);
                this.validateNewlines("name", name);
            }
        }
    }

    private final void validateDescription(String htmlDescription, boolean validateDescriptor) {
        Elements links;
        String latinDescriptionPart;
        boolean bl;
        String textDescription;
        Document html;
        block10: {
            if (!validateDescriptor && htmlDescription == null) {
                return;
            }
            CharSequence charSequence = htmlDescription;
            if (charSequence == null || charSequence.length() == 0) {
                this.registerProblem((PluginProblem)new PropertyNotSpecified("description", this.descriptorPath));
                return;
            }
            this.validatePropertyLength("description", htmlDescription, 65535);
            html = Jsoup.parseBodyFragment((String)htmlDescription);
            textDescription = html.text();
            if (textDescription.length() < 40) {
                this.registerProblem((PluginProblem)new ShortDescription());
            }
            Iterable $this$any$iv = DEFAULT_TEMPLATE_DESCRIPTIONS;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    String string = textDescription;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"textDescription");
                    if (!StringsKt.contains$default((CharSequence)string, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (bl) {
            String string = textDescription;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"textDescription");
            this.registerProblem((PluginProblem)new PropertyWithDefaultValue(this.descriptorPath, PropertyWithDefaultValue.DefaultProperty.DESCRIPTION, string));
            return;
        }
        String string = textDescription;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"textDescription");
        MatchResult matchResult = Regex.find$default((Regex)latinSymbolsRegex, (CharSequence)string, (int)0, (int)2, null);
        String string2 = latinDescriptionPart = matchResult != null ? matchResult.getValue() : null;
        if (latinDescriptionPart == null) {
            this.registerProblem((PluginProblem)new NonLatinDescription());
        }
        Elements elements = links = html.select("[href],img[src]");
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"links");
        Iterable $this$forEach$iv = (Iterable)elements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element link = (Element)element$iv;
            boolean bl3 = false;
            String href = link.attr("abs:href");
            String src = link.attr("abs:src");
            String string3 = href;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"href");
            if (StringsKt.startsWith$default((String)string3, (String)"http://", (boolean)false, (int)2, null)) {
                this.registerProblem((PluginProblem)new HttpLinkInDescription(href));
            }
            String string4 = src;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"src");
            if (!StringsKt.startsWith$default((String)string4, (String)"http://", (boolean)false, (int)2, null)) continue;
            this.registerProblem((PluginProblem)new HttpLinkInDescription(src));
        }
    }

    private final void validateChangeNotes(String changeNotes) {
        CharSequence charSequence = changeNotes;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        if (StringsKt.contains$default((CharSequence)changeNotes, (CharSequence)"Add change notes here", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)changeNotes, (CharSequence)"most HTML tags may be used", (boolean)false, (int)2, null)) {
            this.registerProblem(new DefaultChangeNotes(this.descriptorPath));
        }
        this.validatePropertyLength("<change-notes>", changeNotes, 65535);
    }

    private final void validateNewlines(String propertyName, String propertyValue) {
        String string = propertyValue;
        if (StringsKt.contains$default((CharSequence)((Object)StringsKt.trim((CharSequence)string)).toString(), (CharSequence)"\n", (boolean)false, (int)2, null)) {
            this.registerProblem((PluginProblem)new ContainsNewlines(propertyName, this.descriptorPath));
        }
    }

    private final void validatePropertyLength(String propertyName, String propertyValue, int maxLength) {
        if (propertyValue.length() > maxLength) {
            this.registerProblem((PluginProblem)new TooLongPropertyValue(this.descriptorPath, propertyName, propertyValue.length(), maxLength));
        }
    }

    private final void validateVendor(PluginVendorBean vendorBean) {
        if (vendorBean == null) {
            this.registerProblem((PluginProblem)new PropertyNotSpecified("vendor", this.descriptorPath));
            return;
        }
        CharSequence charSequence = vendorBean.url;
        if ((charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && ((charSequence = (CharSequence)vendorBean.email) == null || StringsKt.isBlank((CharSequence)charSequence)) && ((charSequence = (CharSequence)vendorBean.name) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            this.registerProblem((PluginProblem)new PropertyNotSpecified("vendor", this.descriptorPath));
            return;
        }
        if (Intrinsics.areEqual((Object)"YourCompany", (Object)vendorBean.name)) {
            String string = vendorBean.name;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"vendorBean.name");
            this.registerProblem((PluginProblem)new PropertyWithDefaultValue(this.descriptorPath, PropertyWithDefaultValue.DefaultProperty.VENDOR, string));
        }
        String string = vendorBean.name;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"vendorBean.name");
        this.validatePropertyLength("vendor", string, 255);
        if (Intrinsics.areEqual((Object)"https://www.yourcompany.com", (Object)vendorBean.url)) {
            String string2 = vendorBean.url;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"vendorBean.url");
            this.registerProblem((PluginProblem)new PropertyWithDefaultValue(this.descriptorPath, PropertyWithDefaultValue.DefaultProperty.VENDOR_URL, string2));
        }
        String string3 = vendorBean.url;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"vendorBean.url");
        this.validatePropertyLength("vendor url", string3, 255);
        if (Intrinsics.areEqual((Object)"support@yourcompany.com", (Object)vendorBean.email)) {
            String string4 = vendorBean.email;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"vendorBean.email");
            this.registerProblem((PluginProblem)new PropertyWithDefaultValue(this.descriptorPath, PropertyWithDefaultValue.DefaultProperty.VENDOR_EMAIL, string4));
        }
        String string5 = vendorBean.email;
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"vendorBean.email");
        this.validatePropertyLength("vendor email", string5, 255);
    }

    private final void validateSinceBuild(String sinceBuild) {
        if (sinceBuild == null) {
            this.registerProblem((PluginProblem)new SinceBuildNotSpecified(this.descriptorPath));
        } else {
            IdeVersion sinceBuildParsed = IdeVersion.createIdeVersionIfValid(sinceBuild);
            if (sinceBuildParsed == null) {
                this.registerProblem((PluginProblem)new InvalidSinceBuild(this.descriptorPath, sinceBuild));
            } else {
                CharSequence charSequence;
                if (sinceBuildParsed.getBaselineVersion() < 130 && StringsKt.endsWith$default((String)sinceBuild, (String)".*", (boolean)false, (int)2, null)) {
                    this.registerProblem((PluginProblem)new InvalidSinceBuild(this.descriptorPath, sinceBuild));
                }
                if (sinceBuildParsed.getBaselineVersion() > 999) {
                    this.registerProblem((PluginProblem)new ErroneousSinceBuild(this.descriptorPath, sinceBuildParsed));
                }
                if ((charSequence = (CharSequence)sinceBuildParsed.getProductCode()).length() > 0) {
                    this.registerProblem((PluginProblem)new ProductCodePrefixInBuild(this.descriptorPath));
                }
            }
        }
    }

    private final void validateUntilBuild(String untilBuild) {
        IdeVersion untilBuildParsed = IdeVersion.createIdeVersionIfValid(untilBuild);
        if (untilBuildParsed == null) {
            this.registerProblem((PluginProblem)new InvalidUntilBuild(this.descriptorPath, untilBuild));
        } else {
            if (untilBuildParsed.getBaselineVersion() > 999) {
                this.registerProblem((PluginProblem)new ErroneousUntilBuild(this.descriptorPath, untilBuildParsed));
            } else if (untilBuildParsed.getBaselineVersion() > 400) {
                this.registerProblem(new SuspiciousUntilBuild(untilBuild));
            }
            CharSequence charSequence = untilBuildParsed.getProductCode();
            if (charSequence.length() > 0) {
                this.registerProblem((PluginProblem)new ProductCodePrefixInBuild(this.descriptorPath));
            }
        }
    }

    private final void validateIdeaVersion(IdeaVersionBean versionBean) {
        if (versionBean == null) {
            this.registerProblem((PluginProblem)new PropertyNotSpecified("idea-version", this.descriptorPath));
            return;
        }
        String sinceBuild = versionBean.sinceBuild;
        this.validateSinceBuild(sinceBuild);
        String untilBuild = versionBean.untilBuild;
        if (untilBuild != null) {
            this.validateUntilBuild(untilBuild);
        }
    }

    @NotNull
    public final String getPluginFileName() {
        return this.pluginFileName;
    }

    @NotNull
    public final String getDescriptorPath() {
        return this.descriptorPath;
    }

    private PluginCreator(String pluginFileName, String descriptorPath, PluginCreator parentPlugin) {
        this.pluginFileName = pluginFileName;
        this.descriptorPath = descriptorPath;
        this.parentPlugin = parentPlugin;
        this.optionalDependenciesConfigFiles = new LinkedHashMap();
        this.plugin = new IdePluginImpl();
        this.problems = new ArrayList();
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(PluginCreator.class);
        DEFAULT_TEMPLATE_NAMES = SetsKt.setOf((Object[])new String[]{"Plugin display name here", "My Framework Support", "Template", "Demo"});
        PLUGIN_NAME_RESTRICTED_WORDS = SetsKt.setOf((Object[])new String[]{"plugin", "JetBrains", "IDEA", "PyCharm", "CLion", "AppCode", "DataGrip", "Fleet", "GoLand", "PhpStorm", "WebStorm", "Rider", "ReSharper", "TeamCity", "YouTrack", "RubyMine", "IntelliJ"});
        DEFAULT_TEMPLATE_DESCRIPTIONS = SetsKt.setOf((Object[])new String[]{"Enter short description for your plugin here", "most HTML tags may be used", "example.com/my-framework"});
        v2ModulePrefix = new Regex("^intellij\\..*");
        latinSymbolsRegex = new Regex("[\\w\\s\\p{Punct}]{40,}");
        json = ExtensionsKt.jacksonObjectMapper();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"DateTimeFormatter.ofPattern(\"yyyyMMdd\")");
        releaseDateFormatter = dateTimeFormatter;
    }

    public /* synthetic */ PluginCreator(String pluginFileName, String descriptorPath, PluginCreator parentPlugin, DefaultConstructorMarker $constructor_marker) {
        this(pluginFileName, descriptorPath, parentPlugin);
    }

    @JvmStatic
    @NotNull
    public static final PluginCreator createPlugin(@NotNull Path pluginFile, @NotNull String descriptorPath, @Nullable PluginCreator parentPlugin, boolean validateDescriptor, @NotNull org.jdom2.Document document, @NotNull Path documentPath, @NotNull ResourceResolver pathResolver) {
        return Companion.createPlugin(pluginFile, descriptorPath, parentPlugin, validateDescriptor, document, documentPath, pathResolver);
    }

    @JvmStatic
    @NotNull
    public static final PluginCreator createPlugin(@NotNull String pluginFileName, @NotNull String descriptorPath, @Nullable PluginCreator parentPlugin, boolean validateDescriptor, @NotNull org.jdom2.Document document, @NotNull Path documentPath, @NotNull ResourceResolver pathResolver) {
        return Companion.createPlugin(pluginFileName, descriptorPath, parentPlugin, validateDescriptor, document, documentPath, pathResolver);
    }

    @JvmStatic
    @NotNull
    public static final PluginCreator createInvalidPlugin(@NotNull Path pluginFile, @NotNull String descriptorPath, @NotNull PluginProblem singleProblem) {
        return Companion.createInvalidPlugin(pluginFile, descriptorPath, singleProblem);
    }

    @JvmStatic
    @NotNull
    public static final PluginCreator createInvalidPlugin(@NotNull String pluginFileName, @NotNull String descriptorPath, @NotNull PluginProblem singleProblem) {
        return Companion.createInvalidPlugin(pluginFileName, descriptorPath, singleProblem);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 H\u0007J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 H\u0007JB\u0010\"\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00052\b\u0010#\u001a\u0004\u0018\u00010\u001b2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*H\u0007JB\u0010\"\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\b\u0010#\u001a\u0004\u0018\u00010\u001b2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*H\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006+"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator$Companion;", "", "()V", "DEFAULT_TEMPLATE_DESCRIPTIONS", "", "", "DEFAULT_TEMPLATE_NAMES", "INTELLIJ_THEME_EXTENSION", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "MAX_LONG_PROPERTY_LENGTH", "", "MAX_PRODUCT_CODE_LENGTH", "MAX_PROPERTY_LENGTH", "MAX_VERSION_LENGTH", "PLUGIN_NAME_RESTRICTED_WORDS", "json", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "latinSymbolsRegex", "Lkotlin/text/Regex;", "releaseDateFormatter", "Ljava/time/format/DateTimeFormatter;", "v2ModulePrefix", "getV2ModulePrefix", "()Lkotlin/text/Regex;", "createInvalidPlugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;", "pluginFile", "Ljava/nio/file/Path;", "descriptorPath", "singleProblem", "Lcom/jetbrains/plugin/structure/base/plugin/PluginProblem;", "pluginFileName", "createPlugin", "parentPlugin", "validateDescriptor", "", "document", "Lorg/jdom2/Document;", "documentPath", "pathResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "structure-intellij"})
    public static final class Companion {
        @NotNull
        public final Regex getV2ModulePrefix() {
            return v2ModulePrefix;
        }

        @JvmStatic
        @NotNull
        public final PluginCreator createPlugin(@NotNull Path pluginFile, @NotNull String descriptorPath, @Nullable PluginCreator parentPlugin, boolean validateDescriptor, @NotNull org.jdom2.Document document, @NotNull Path documentPath, @NotNull ResourceResolver pathResolver) {
            Intrinsics.checkNotNullParameter((Object)pluginFile, (String)"pluginFile");
            Intrinsics.checkNotNullParameter((Object)descriptorPath, (String)"descriptorPath");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)documentPath, (String)"documentPath");
            Intrinsics.checkNotNullParameter((Object)pathResolver, (String)"pathResolver");
            return this.createPlugin(FileUtilKt.getSimpleName((Path)pluginFile), descriptorPath, parentPlugin, validateDescriptor, document, documentPath, pathResolver);
        }

        @JvmStatic
        @NotNull
        public final PluginCreator createPlugin(@NotNull String pluginFileName, @NotNull String descriptorPath, @Nullable PluginCreator parentPlugin, boolean validateDescriptor, @NotNull org.jdom2.Document document, @NotNull Path documentPath, @NotNull ResourceResolver pathResolver) {
            Intrinsics.checkNotNullParameter((Object)pluginFileName, (String)"pluginFileName");
            Intrinsics.checkNotNullParameter((Object)descriptorPath, (String)"descriptorPath");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)documentPath, (String)"documentPath");
            Intrinsics.checkNotNullParameter((Object)pathResolver, (String)"pathResolver");
            PluginCreator pluginCreator = new PluginCreator(pluginFileName, descriptorPath, parentPlugin, null);
            pluginCreator.resolveDocumentAndValidateBean(document, documentPath, descriptorPath, pathResolver, validateDescriptor);
            return pluginCreator;
        }

        @JvmStatic
        @NotNull
        public final PluginCreator createInvalidPlugin(@NotNull Path pluginFile, @NotNull String descriptorPath, @NotNull PluginProblem singleProblem) {
            Intrinsics.checkNotNullParameter((Object)pluginFile, (String)"pluginFile");
            Intrinsics.checkNotNullParameter((Object)descriptorPath, (String)"descriptorPath");
            Intrinsics.checkNotNullParameter((Object)singleProblem, (String)"singleProblem");
            return this.createInvalidPlugin(FileUtilKt.getSimpleName((Path)pluginFile), descriptorPath, singleProblem);
        }

        @JvmStatic
        @NotNull
        public final PluginCreator createInvalidPlugin(@NotNull String pluginFileName, @NotNull String descriptorPath, @NotNull PluginProblem singleProblem) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)pluginFileName, (String)"pluginFileName");
            Intrinsics.checkNotNullParameter((Object)descriptorPath, (String)"descriptorPath");
            Intrinsics.checkNotNullParameter((Object)singleProblem, (String)"singleProblem");
            boolean bl2 = bl = singleProblem.getLevel() == PluginProblem.Level.ERROR;
            if (!bl) {
                boolean bl3 = false;
                String string = "Only ERROR problems are allowed here";
                throw new IllegalArgumentException(string.toString());
            }
            PluginCreator pluginCreator = new PluginCreator(pluginFileName, descriptorPath, null, null);
            pluginCreator.registerProblem(singleProblem);
            return pluginCreator;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

