/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.repository;

import com.jetbrains.plugin.structure.intellij.repository.CustomPluginRepositoryListingType;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import java.io.ByteArrayInputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J&\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\"\u0010\u0012\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u000fH\u0002J\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0007*\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u000f*\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u0007H\u0002\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/plugin/structure/intellij/repository/CustomPluginRepositoryListingParser;", "", "()V", "parseListOfPlugins", "", "Lcom/jetbrains/plugin/structure/intellij/repository/CustomPluginRepositoryListingParser$PluginInfo;", "pluginsListXmlContent", "", "pluginsListXmlUrl", "Ljava/net/URL;", "repositoryUrl", "listingType", "Lcom/jetbrains/plugin/structure/intellij/repository/CustomPluginRepositoryListingType;", "parsePluginRepositoryList", "root", "Lorg/w3c/dom/Element;", "xmlUrl", "parseSimpleList", "parseSinceAndUntil", "Lkotlin/Pair;", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "ideaVersionElement", "getAttributeOrNull", "attributeName", "getSingleChild", "tagName", "PluginInfo", "structure-intellij"})
public final class CustomPluginRepositoryListingParser {
    @NotNull
    public static final CustomPluginRepositoryListingParser INSTANCE;

    @NotNull
    public final List<PluginInfo> parseListOfPlugins(@NotNull String pluginsListXmlContent, @NotNull URL pluginsListXmlUrl, @NotNull URL repositoryUrl, @NotNull CustomPluginRepositoryListingType listingType) {
        List<PluginInfo> list;
        Document document;
        Intrinsics.checkNotNullParameter((Object)pluginsListXmlContent, (String)"pluginsListXmlContent");
        Intrinsics.checkNotNullParameter((Object)pluginsListXmlUrl, (String)"pluginsListXmlUrl");
        Intrinsics.checkNotNullParameter((Object)repositoryUrl, (String)"repositoryUrl");
        Intrinsics.checkNotNullParameter((Object)((Object)listingType), (String)"listingType");
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Object object = pluginsListXmlContent;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = ((String)object).getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        object = byArray;
        Document document2 = document = documentBuilder.parse(new ByteArrayInputStream((byte[])object));
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"document");
        Element root = document2.getDocumentElement();
        if (listingType == CustomPluginRepositoryListingType.SIMPLE) {
            Element element = root;
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"root");
            list = this.parseSimpleList(element, pluginsListXmlUrl, repositoryUrl);
        } else {
            Element element = root;
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"root");
            list = this.parsePluginRepositoryList(element, pluginsListXmlUrl, repositoryUrl);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PluginInfo> parseSimpleList(Element root, URL xmlUrl, URL repositoryUrl) {
        if (Intrinsics.areEqual((Object)root.getTagName(), (Object)"plugins") ^ true) {
            return CollectionsKt.emptyList();
        }
        NodeList pluginsList = root.getElementsByTagName("plugin");
        ArrayList result = new ArrayList();
        int n = 0;
        NodeList nodeList = pluginsList;
        Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"pluginsList");
        int n2 = nodeList.getLength();
        while (n < n2) {
            String url;
            String version;
            String id;
            CharSequence charSequence;
            Element pluginElement;
            void i;
            Node node = pluginsList.item((int)i);
            if (!(node instanceof Element)) {
                node = null;
            }
            if ((Element)node != null && !(Intrinsics.areEqual((Object)pluginElement.getTagName(), (Object)"plugin") ^ true) && this.getAttributeOrNull(pluginElement, "id") != null && this.getAttributeOrNull(pluginElement, "url") != null && this.getAttributeOrNull(pluginElement, "version") != null && (charSequence = (CharSequence)id).length() > 0 && (charSequence = (CharSequence)version).length() > 0 && (charSequence = (CharSequence)url).length() > 0) {
                void sinceBuild;
                String string = this.getAttributeOrNull(pluginElement, "name");
                if (string == null) {
                    string = id;
                }
                String pluginName = string;
                String vendor = this.getAttributeOrNull(pluginElement, "vendor");
                URL downloadUrl = new URL(xmlUrl, url);
                Element ideaVersionElement = this.getSingleChild(pluginElement, "idea-version");
                Object object = this.parseSinceAndUntil(ideaVersionElement);
                IdeVersion ideVersion = (IdeVersion)object.component1();
                IdeVersion untilBuild = (IdeVersion)object.component2();
                object = result;
                PluginInfo pluginInfo = new PluginInfo(id, pluginName, version, vendor, repositoryUrl, downloadUrl, repositoryUrl, null, (IdeVersion)sinceBuild, untilBuild);
                object.add(pluginInfo);
            }
            ++i;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PluginInfo> parsePluginRepositoryList(Element root, URL xmlUrl, URL repositoryUrl) {
        if (Intrinsics.areEqual((Object)root.getTagName(), (Object)"plugin-repository") ^ true) {
            return CollectionsKt.emptyList();
        }
        NodeList ideaPluginElements = root.getElementsByTagName("idea-plugin");
        ArrayList result = new ArrayList();
        int n = 0;
        NodeList nodeList = ideaPluginElements;
        Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"ideaPluginElements");
        int n2 = nodeList.getLength();
        while (n < n2) {
            Object object;
            Element ideaPlugin;
            void i;
            Node node = ideaPluginElements.item((int)i);
            if (!(node instanceof Element)) {
                node = null;
            }
            if ((Element)node != null && !(Intrinsics.areEqual((Object)ideaPlugin.getTagName(), (Object)"idea-plugin") ^ true) && (object = this.getSingleChild(ideaPlugin, "name")) != null && (object = object.getTextContent()) != null) {
                Object name = object;
                Object object2 = this.getSingleChild(ideaPlugin, "id");
                if (object2 != null && (object2 = object2.getTextContent()) != null) {
                    Object id = object2;
                    Object object3 = this.getSingleChild(ideaPlugin, "version");
                    if (object3 != null && (object3 = object3.getTextContent()) != null) {
                        Object version = object3;
                        Object object4 = this.getSingleChild(ideaPlugin, "vendor");
                        if (object4 != null && (object4 = object4.getTextContent()) != null) {
                            Object vendor = object4;
                            Object object5 = this.getSingleChild(ideaPlugin, "download-url");
                            if (object5 != null && (object5 = object5.getTextContent()) != null) {
                                void sinceBuild;
                                Object downloadUrlRelative = object5;
                                Element ideaVersionElement = this.getSingleChild(ideaPlugin, "idea-version");
                                Pair<IdeVersion, IdeVersion> pair = this.parseSinceAndUntil(ideaVersionElement);
                                IdeVersion ideVersion = (IdeVersion)pair.component1();
                                IdeVersion untilBuild = (IdeVersion)pair.component2();
                                URL downloadUrl = new URL(xmlUrl, (String)downloadUrlRelative);
                                Collection collection = result;
                                PluginInfo pluginInfo = new PluginInfo((String)id, (String)name, (String)version, (String)vendor, repositoryUrl, downloadUrl, repositoryUrl, null, (IdeVersion)sinceBuild, untilBuild);
                                collection.add(pluginInfo);
                            }
                        }
                    }
                }
            }
            ++i;
        }
        return result;
    }

    private final Pair<IdeVersion, IdeVersion> parseSinceAndUntil(Element ideaVersionElement) {
        IdeVersion ideVersion;
        Object object;
        IdeVersion sinceBuild;
        IdeVersion ideVersion2;
        Object object2 = ideaVersionElement;
        if (object2 != null && (object2 = this.getAttributeOrNull((Element)object2, "since-build")) != null) {
            Object object3;
            Object it = object3 = object2;
            boolean bl = false;
            ideVersion2 = IdeVersion.createIdeVersionIfValid((String)it);
        } else {
            ideVersion2 = sinceBuild = null;
        }
        if ((object = ideaVersionElement) != null && (object = this.getAttributeOrNull((Element)object, "until-build")) != null) {
            Object object4;
            Object it = object4 = object;
            boolean bl = false;
            ideVersion = IdeVersion.createIdeVersionIfValid((String)it);
        } else {
            ideVersion = null;
        }
        IdeVersion untilBuild = ideVersion;
        return TuplesKt.to(sinceBuild, untilBuild);
    }

    private final String getAttributeOrNull(Element $this$getAttributeOrNull, String attributeName) {
        if ($this$getAttributeOrNull.hasAttribute(attributeName)) {
            return $this$getAttributeOrNull.getAttribute(attributeName);
        }
        return null;
    }

    private final Element getSingleChild(Element $this$getSingleChild, String tagName) {
        NodeList elements;
        NodeList nodeList = elements = $this$getSingleChild.getElementsByTagName(tagName);
        Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"elements");
        if (nodeList.getLength() != 1) {
            return null;
        }
        Node node = elements.item(0);
        if (!(node instanceof Element)) {
            node = null;
        }
        return (Element)node;
    }

    private CustomPluginRepositoryListingParser() {
    }

    static {
        CustomPluginRepositoryListingParser customPluginRepositoryListingParser;
        INSTANCE = customPluginRepositoryListingParser = new CustomPluginRepositoryListingParser();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\rH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\bH\u00c6\u0003J\t\u0010#\u001a\u00020\bH\u00c6\u0003J\t\u0010$\u001a\u00020\bH\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u0010&\u001a\u0004\u0018\u00010\rH\u00c6\u0003Ju\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\rH\u00c6\u0001J\u0013\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010+\u001a\u00020,H\u00d6\u0001J\t\u0010-\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0014R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0014\u00a8\u0006."}, d2={"Lcom/jetbrains/plugin/structure/intellij/repository/CustomPluginRepositoryListingParser$PluginInfo;", "", "pluginId", "", "pluginName", "version", "vendor", "repositoryUrl", "Ljava/net/URL;", "downloadUrl", "browserUrl", "sourceCodeUrl", "sinceBuild", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "untilBuild", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/net/URL;Ljava/net/URL;Ljava/net/URL;Ljava/net/URL;Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;)V", "getBrowserUrl", "()Ljava/net/URL;", "getDownloadUrl", "getPluginId", "()Ljava/lang/String;", "getPluginName", "getRepositoryUrl", "getSinceBuild", "()Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "getSourceCodeUrl", "getUntilBuild", "getVendor", "getVersion", "component1", "component10", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "", "toString", "structure-intellij"})
    public static final class PluginInfo {
        @NotNull
        private final String pluginId;
        @NotNull
        private final String pluginName;
        @NotNull
        private final String version;
        @Nullable
        private final String vendor;
        @NotNull
        private final URL repositoryUrl;
        @NotNull
        private final URL downloadUrl;
        @NotNull
        private final URL browserUrl;
        @Nullable
        private final URL sourceCodeUrl;
        @Nullable
        private final IdeVersion sinceBuild;
        @Nullable
        private final IdeVersion untilBuild;

        @NotNull
        public final String getPluginId() {
            return this.pluginId;
        }

        @NotNull
        public final String getPluginName() {
            return this.pluginName;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        @Nullable
        public final String getVendor() {
            return this.vendor;
        }

        @NotNull
        public final URL getRepositoryUrl() {
            return this.repositoryUrl;
        }

        @NotNull
        public final URL getDownloadUrl() {
            return this.downloadUrl;
        }

        @NotNull
        public final URL getBrowserUrl() {
            return this.browserUrl;
        }

        @Nullable
        public final URL getSourceCodeUrl() {
            return this.sourceCodeUrl;
        }

        @Nullable
        public final IdeVersion getSinceBuild() {
            return this.sinceBuild;
        }

        @Nullable
        public final IdeVersion getUntilBuild() {
            return this.untilBuild;
        }

        public PluginInfo(@NotNull String pluginId, @NotNull String pluginName, @NotNull String version, @Nullable String vendor, @NotNull URL repositoryUrl, @NotNull URL downloadUrl, @NotNull URL browserUrl, @Nullable URL sourceCodeUrl, @Nullable IdeVersion sinceBuild, @Nullable IdeVersion untilBuild) {
            Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
            Intrinsics.checkNotNullParameter((Object)pluginName, (String)"pluginName");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)repositoryUrl, (String)"repositoryUrl");
            Intrinsics.checkNotNullParameter((Object)downloadUrl, (String)"downloadUrl");
            Intrinsics.checkNotNullParameter((Object)browserUrl, (String)"browserUrl");
            this.pluginId = pluginId;
            this.pluginName = pluginName;
            this.version = version;
            this.vendor = vendor;
            this.repositoryUrl = repositoryUrl;
            this.downloadUrl = downloadUrl;
            this.browserUrl = browserUrl;
            this.sourceCodeUrl = sourceCodeUrl;
            this.sinceBuild = sinceBuild;
            this.untilBuild = untilBuild;
        }

        @NotNull
        public final String component1() {
            return this.pluginId;
        }

        @NotNull
        public final String component2() {
            return this.pluginName;
        }

        @NotNull
        public final String component3() {
            return this.version;
        }

        @Nullable
        public final String component4() {
            return this.vendor;
        }

        @NotNull
        public final URL component5() {
            return this.repositoryUrl;
        }

        @NotNull
        public final URL component6() {
            return this.downloadUrl;
        }

        @NotNull
        public final URL component7() {
            return this.browserUrl;
        }

        @Nullable
        public final URL component8() {
            return this.sourceCodeUrl;
        }

        @Nullable
        public final IdeVersion component9() {
            return this.sinceBuild;
        }

        @Nullable
        public final IdeVersion component10() {
            return this.untilBuild;
        }

        @NotNull
        public final PluginInfo copy(@NotNull String pluginId, @NotNull String pluginName, @NotNull String version, @Nullable String vendor, @NotNull URL repositoryUrl, @NotNull URL downloadUrl, @NotNull URL browserUrl, @Nullable URL sourceCodeUrl, @Nullable IdeVersion sinceBuild, @Nullable IdeVersion untilBuild) {
            Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
            Intrinsics.checkNotNullParameter((Object)pluginName, (String)"pluginName");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)repositoryUrl, (String)"repositoryUrl");
            Intrinsics.checkNotNullParameter((Object)downloadUrl, (String)"downloadUrl");
            Intrinsics.checkNotNullParameter((Object)browserUrl, (String)"browserUrl");
            return new PluginInfo(pluginId, pluginName, version, vendor, repositoryUrl, downloadUrl, browserUrl, sourceCodeUrl, sinceBuild, untilBuild);
        }

        public static /* synthetic */ PluginInfo copy$default(PluginInfo pluginInfo, String string, String string2, String string3, String string4, URL uRL, URL uRL2, URL uRL3, URL uRL4, IdeVersion ideVersion, IdeVersion ideVersion2, int n, Object object) {
            if ((n & 1) != 0) {
                string = pluginInfo.pluginId;
            }
            if ((n & 2) != 0) {
                string2 = pluginInfo.pluginName;
            }
            if ((n & 4) != 0) {
                string3 = pluginInfo.version;
            }
            if ((n & 8) != 0) {
                string4 = pluginInfo.vendor;
            }
            if ((n & 0x10) != 0) {
                uRL = pluginInfo.repositoryUrl;
            }
            if ((n & 0x20) != 0) {
                uRL2 = pluginInfo.downloadUrl;
            }
            if ((n & 0x40) != 0) {
                uRL3 = pluginInfo.browserUrl;
            }
            if ((n & 0x80) != 0) {
                uRL4 = pluginInfo.sourceCodeUrl;
            }
            if ((n & 0x100) != 0) {
                ideVersion = pluginInfo.sinceBuild;
            }
            if ((n & 0x200) != 0) {
                ideVersion2 = pluginInfo.untilBuild;
            }
            return pluginInfo.copy(string, string2, string3, string4, uRL, uRL2, uRL3, uRL4, ideVersion, ideVersion2);
        }

        @NotNull
        public String toString() {
            return "PluginInfo(pluginId=" + this.pluginId + ", pluginName=" + this.pluginName + ", version=" + this.version + ", vendor=" + this.vendor + ", repositoryUrl=" + this.repositoryUrl + ", downloadUrl=" + this.downloadUrl + ", browserUrl=" + this.browserUrl + ", sourceCodeUrl=" + this.sourceCodeUrl + ", sinceBuild=" + this.sinceBuild + ", untilBuild=" + this.untilBuild + ")";
        }

        public int hashCode() {
            String string = this.pluginId;
            String string2 = this.pluginName;
            String string3 = this.version;
            String string4 = this.vendor;
            URL uRL = this.repositoryUrl;
            URL uRL2 = this.downloadUrl;
            URL uRL3 = this.browserUrl;
            URL uRL4 = this.sourceCodeUrl;
            IdeVersion ideVersion = this.sinceBuild;
            IdeVersion ideVersion2 = this.untilBuild;
            return (((((((((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31 + (uRL != null ? ((Object)uRL).hashCode() : 0)) * 31 + (uRL2 != null ? ((Object)uRL2).hashCode() : 0)) * 31 + (uRL3 != null ? ((Object)uRL3).hashCode() : 0)) * 31 + (uRL4 != null ? ((Object)uRL4).hashCode() : 0)) * 31 + (ideVersion != null ? ((Object)ideVersion).hashCode() : 0)) * 31 + (ideVersion2 != null ? ((Object)ideVersion2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PluginInfo)) break block3;
                    PluginInfo pluginInfo = (PluginInfo)object;
                    if (!Intrinsics.areEqual((Object)this.pluginId, (Object)pluginInfo.pluginId) || !Intrinsics.areEqual((Object)this.pluginName, (Object)pluginInfo.pluginName) || !Intrinsics.areEqual((Object)this.version, (Object)pluginInfo.version) || !Intrinsics.areEqual((Object)this.vendor, (Object)pluginInfo.vendor) || !Intrinsics.areEqual((Object)this.repositoryUrl, (Object)pluginInfo.repositoryUrl) || !Intrinsics.areEqual((Object)this.downloadUrl, (Object)pluginInfo.downloadUrl) || !Intrinsics.areEqual((Object)this.browserUrl, (Object)pluginInfo.browserUrl) || !Intrinsics.areEqual((Object)this.sourceCodeUrl, (Object)pluginInfo.sourceCodeUrl) || !Intrinsics.areEqual((Object)this.sinceBuild, (Object)pluginInfo.sinceBuild) || !Intrinsics.areEqual((Object)this.untilBuild, (Object)pluginInfo.untilBuild)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

