/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.extractor;

import com.jetbrains.plugin.structure.base.decompress.DecompressorSizeLimitExceededException;
import com.jetbrains.plugin.structure.base.plugin.PluginProblem;
import com.jetbrains.plugin.structure.base.plugin.Settings;
import com.jetbrains.plugin.structure.base.problems.PluginFileSizeIsTooLarge;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.ZipUtilKt;
import com.jetbrains.plugin.structure.intellij.extractor.ExtractedPlugin;
import com.jetbrains.plugin.structure.intellij.extractor.ExtractorResult;
import com.jetbrains.plugin.structure.intellij.problems.PluginZipContainsMultipleFiles;
import com.jetbrains.plugin.structure.intellij.problems.PluginZipContainsSingleJarInRoot;
import com.jetbrains.plugin.structure.intellij.problems.PluginZipContainsUnknownFile;
import com.jetbrains.plugin.structure.intellij.problems.PluginZipIsEmpty;
import com.jetbrains.plugin.structure.intellij.problems.UnexpectedPluginZipStructure;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/plugin/structure/intellij/extractor/PluginExtractor;", "", "()V", "zipPathMatcher", "Ljava/nio/file/PathMatcher;", "kotlin.jvm.PlatformType", "extractPlugin", "Lcom/jetbrains/plugin/structure/intellij/extractor/ExtractorResult;", "pluginFile", "Ljava/nio/file/Path;", "extractDirectory", "fail", "problem", "Lcom/jetbrains/plugin/structure/base/plugin/PluginProblem;", "extractedPlugin", "getExtractorResult", "success", "actualFile", "fileToDelete", "structure-intellij"})
@SourceDebugExtension(value={"SMAP\nPluginExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginExtractor.kt\ncom/jetbrains/plugin/structure/intellij/extractor/PluginExtractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n1747#2,3:72\n1549#2:75\n1620#2,3:76\n*E\n*S KotlinDebug\n*F\n+ 1 PluginExtractor.kt\ncom/jetbrains/plugin/structure/intellij/extractor/PluginExtractor\n*L\n57#1,3:72\n66#1:75\n66#1,3:76\n*E\n"})
public final class PluginExtractor {
    private static final PathMatcher zipPathMatcher;
    @NotNull
    public static final PluginExtractor INSTANCE;

    @NotNull
    public final ExtractorResult extractPlugin(@NotNull Path pluginFile, @NotNull Path extractDirectory) {
        Intrinsics.checkNotNullParameter((Object)pluginFile, (String)"pluginFile");
        Intrinsics.checkNotNullParameter((Object)extractDirectory, (String)"extractDirectory");
        Files.createDirectories(extractDirectory, new FileAttribute[0]);
        Path extractedPlugin = Files.createTempDirectory(extractDirectory, "plugin_", new FileAttribute[0]);
        try {
            Path path = extractedPlugin;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"extractedPlugin");
            ZipUtilKt.extractZip((Path)pluginFile, (Path)path, (Long)Settings.INTELLIJ_PLUGIN_SIZE_LIMIT.getAsLong());
        }
        catch (DecompressorSizeLimitExceededException e) {
            PluginProblem pluginProblem = (PluginProblem)new PluginFileSizeIsTooLarge(e.getSizeLimit());
            Path path = extractedPlugin;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"extractedPlugin");
            return this.fail(pluginProblem, path);
        }
        catch (Throwable e) {
            Path path = extractedPlugin;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"extractedPlugin");
            FileUtilKt.deleteQuietly((Path)path);
            throw e;
        }
        return this.getExtractorResult(extractedPlugin);
    }

    private final ExtractorResult success(Path actualFile, Path fileToDelete) {
        return new ExtractorResult.Success(new ExtractedPlugin(actualFile, fileToDelete));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ExtractorResult fail(PluginProblem problem, Path extractedPlugin) {
        try {
            ExtractorResult extractorResult = new ExtractorResult.Fail(problem);
            return extractorResult;
        }
        finally {
            FileUtilKt.deleteQuietly((Path)extractedPlugin);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final ExtractorResult getExtractorResult(Path extractedPlugin) {
        rootFiles = FileUtilKt.listFiles((Path)extractedPlugin);
        switch (rootFiles.size()) {
            case 0: {
                return this.fail((PluginProblem)new PluginZipIsEmpty(), extractedPlugin);
            }
            case 1: {
                singleFile = (Path)rootFiles.get(0);
                if (!FileUtilKt.isJar((Path)singleFile)) ** GOTO lbl10
                v0 = this.fail((PluginProblem)new PluginZipContainsSingleJarInRoot(FileUtilKt.getSimpleName((Path)singleFile)), extractedPlugin);
                ** GOTO lbl27
lbl10:
                // 1 sources

                if (!FileUtilKt.isDirectory((Path)singleFile)) ** GOTO lbl26
                allFiles = FileUtilKt.listAllFiles((Path)extractedPlugin);
                $this$any$iv = allFiles;
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl17
                v1 = false;
                ** GOTO lbl24
lbl17:
                // 2 sources

                for (T element$iv : $this$any$iv) {
                    it = (Path)element$iv;
                    $i$a$-any-PluginExtractor$getExtractorResult$1 = false;
                    if (!PluginExtractor.zipPathMatcher.matches(it)) continue;
                    v1 = true;
                    ** GOTO lbl24
                }
                v1 = false;
lbl24:
                // 3 sources

                v0 = v1 ? this.success(singleFile, extractedPlugin) : this.fail((PluginProblem)new UnexpectedPluginZipStructure(), extractedPlugin);
                ** GOTO lbl27
lbl26:
                // 1 sources

                v0 = this.fail((PluginProblem)new PluginZipContainsUnknownFile(FileUtilKt.getSimpleName((Path)singleFile)), extractedPlugin);
lbl27:
                // 3 sources

                return v0;
            }
        }
        singleFile = rootFiles;
        var12_19 = this;
        $i$f$map = false;
        $this$any$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            $i$a$-any-PluginExtractor$getExtractorResult$1 = (Path)item$iv$iv;
            var13_21 = destination$iv$iv;
            $i$a$-map-PluginExtractor$getExtractorResult$2 = false;
            var14_22 = FileUtilKt.getSimpleName((Path)it);
            var13_21.add(var14_22);
        }
        var13_21 = (List)destination$iv$iv;
        var15_23 = CollectionsKt.sorted((Iterable)var13_21);
        return var12_19.fail((PluginProblem)new PluginZipContainsMultipleFiles(var15_23), extractedPlugin);
    }

    private PluginExtractor() {
    }

    static {
        PluginExtractor pluginExtractor;
        INSTANCE = pluginExtractor = new PluginExtractor();
        zipPathMatcher = FileSystems.getDefault().getPathMatcher("glob:*/lib/*.jar");
    }
}

