/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.verifiers;

import com.jetbrains.plugin.structure.base.plugin.PluginProblem;
import com.jetbrains.plugin.structure.base.problems.PropertyNotSpecified;
import com.jetbrains.plugin.structure.intellij.beans.PluginBean;
import com.jetbrains.plugin.structure.intellij.beans.PluginVendorBean;
import com.jetbrains.plugin.structure.intellij.problems.IllegalPluginIdPrefix;
import com.jetbrains.plugin.structure.intellij.problems.PropertyWithDefaultValue;
import com.jetbrains.plugin.structure.intellij.problems.TemplateWordInPluginId;
import com.jetbrains.plugin.structure.intellij.verifiers.PluginIdVerifierKt;
import com.jetbrains.plugin.structure.intellij.verifiers.ProblemRegistrar;
import com.jetbrains.plugin.structure.intellij.verifiers.SimpleVerifiersKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ \u0010\r\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/plugin/structure/intellij/verifiers/PluginIdVerifier;", "", "()V", "isDevelopedByJetBrains", "", "plugin", "Lcom/jetbrains/plugin/structure/intellij/beans/PluginBean;", "verify", "", "descriptorPath", "", "problemRegistrar", "Lcom/jetbrains/plugin/structure/intellij/verifiers/ProblemRegistrar;", "verifyPrefix", "structure-intellij"})
@SourceDebugExtension(value={"SMAP\nPluginIdVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginIdVerifier.kt\ncom/jetbrains/plugin/structure/intellij/verifiers/PluginIdVerifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n766#2:58\n857#2,2:59\n1855#2,2:61\n766#2:63\n857#2,2:64\n1855#2,2:66\n*E\n*S KotlinDebug\n*F\n+ 1 PluginIdVerifier.kt\ncom/jetbrains/plugin/structure/intellij/verifiers/PluginIdVerifier\n*L\n45#1:58\n45#1,2:59\n46#1,2:61\n49#1:63\n49#1,2:64\n50#1,2:66\n*E\n"})
public final class PluginIdVerifier {
    public final void verify(@NotNull PluginBean plugin, @NotNull String descriptorPath, @NotNull ProblemRegistrar problemRegistrar) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)descriptorPath, (String)"descriptorPath");
        Intrinsics.checkNotNullParameter((Object)problemRegistrar, (String)"problemRegistrar");
        String string = plugin.id;
        if (string == null) {
            return;
        }
        String id = string;
        if (StringsKt.isBlank((CharSequence)id)) {
            problemRegistrar.registerProblem((PluginProblem)new PropertyNotSpecified("id", null, 2, null));
        } else if (Intrinsics.areEqual((Object)"com.your.company.unique.plugin.id", (Object)id)) {
            problemRegistrar.registerProblem((PluginProblem)new PropertyWithDefaultValue(descriptorPath, PropertyWithDefaultValue.DefaultProperty.ID, id));
        } else {
            SimpleVerifiersKt.verifyPropertyLength("id", id, 255, descriptorPath, problemRegistrar);
            SimpleVerifiersKt.verifyNewlines("id", id, descriptorPath, problemRegistrar);
            this.verifyPrefix(plugin, descriptorPath, problemRegistrar);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyPrefix(PluginBean plugin, String descriptorPath, ProblemRegistrar problemRegistrar) {
        void $this$filterTo$iv$iv;
        Iterable $this$forEach$iv;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv;
        if (this.isDevelopedByJetBrains(plugin)) {
            return;
        }
        String id = plugin.id;
        Iterable iterable = PluginIdVerifierKt.getDEFAULT_ILLEGAL_PREFIXES();
        String string = id;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"id");
        String string2 = string;
        boolean $i$f$filter22 = false;
        void var8_10 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            String p1 = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)string2, (String)p1, (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            problemRegistrar.registerProblem((PluginProblem)new IllegalPluginIdPrefix(id, it));
        }
        $this$forEach$iv = StringsKt.split$default((CharSequence)id, (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable $i$f$filter22 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String idComponent = (String)element$iv$iv;
            boolean bl = false;
            List<String> list = PluginIdVerifierKt.getPRODUCT_ID_RESTRICTED_WORDS();
            String string3 = idComponent;
            String string4 = string3.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase()");
            if (!list.contains(string4)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String idComponent = (String)element$iv;
            boolean bl = false;
            problemRegistrar.registerProblem(new TemplateWordInPluginId(descriptorPath, idComponent));
        }
    }

    private final boolean isDevelopedByJetBrains(PluginBean plugin) {
        PluginVendorBean pluginVendorBean = plugin.vendor;
        return CollectionsKt.contains((Iterable)PluginIdVerifierKt.getJETBRAINS_VENDORS(), (Object)(pluginVendorBean != null ? pluginVendorBean.name : null));
    }
}

