/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin;

import com.jetbrains.plugin.structure.base.plugin.IconTheme;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationFail;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationSuccess;
import com.jetbrains.plugin.structure.base.plugin.PluginIcon;
import com.jetbrains.plugin.structure.base.plugin.PluginManager;
import com.jetbrains.plugin.structure.base.plugin.Settings;
import com.jetbrains.plugin.structure.base.plugin.ThirdPartyDependency;
import com.jetbrains.plugin.structure.base.plugin.ThirdPartyDependencyKt;
import com.jetbrains.plugin.structure.base.problems.IncorrectZipOrJarFile;
import com.jetbrains.plugin.structure.base.problems.MultiplePluginDescriptors;
import com.jetbrains.plugin.structure.base.problems.PluginDescriptorIsNotFound;
import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.problems.PluginProblemsKt;
import com.jetbrains.plugin.structure.base.problems.UnableToExtractZip;
import com.jetbrains.plugin.structure.base.problems.UnableToReadDescriptor;
import com.jetbrains.plugin.structure.base.problems.UnexpectedDescriptorElements;
import com.jetbrains.plugin.structure.base.telemetry.MutablePluginTelemetry;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.intellij.extractor.ExtractedPlugin;
import com.jetbrains.plugin.structure.intellij.extractor.ExtractorResult;
import com.jetbrains.plugin.structure.intellij.extractor.PluginExtractor;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.IdePluginManager;
import com.jetbrains.plugin.structure.intellij.plugin.JarFilesResourceResolver;
import com.jetbrains.plugin.structure.intellij.plugin.Module;
import com.jetbrains.plugin.structure.intellij.plugin.OptionalDependencyResolver;
import com.jetbrains.plugin.structure.intellij.plugin.PluginCreator;
import com.jetbrains.plugin.structure.intellij.plugin.PluginLoader;
import com.jetbrains.plugin.structure.intellij.problems.IntelliJPluginCreationResultResolver;
import com.jetbrains.plugin.structure.intellij.problems.PluginCreationResultResolver;
import com.jetbrains.plugin.structure.intellij.problems.PluginLibDirectoryIsEmpty;
import com.jetbrains.plugin.structure.intellij.resources.CompositeResourceResolver;
import com.jetbrains.plugin.structure.intellij.resources.DefaultResourceResolver;
import com.jetbrains.plugin.structure.intellij.resources.ResourceResolver;
import com.jetbrains.plugin.structure.intellij.utils.JDOMUtil;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import com.jetbrains.plugin.structure.jar.JarArchiveCannotBeOpenException;
import com.jetbrains.plugin.structure.jar.JarFileSystemProvider;
import com.jetbrains.plugin.structure.jar.PluginDescriptorResult;
import com.jetbrains.plugin.structure.jar.PluginJar;
import com.jetbrains.plugin.structure.jar.SingletonCachingJarFileSystemProvider;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Deprecated;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function6;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom2.Document;
import org.jdom2.input.JDOMParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u0000 ;2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001;B!\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ.\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\b\b\u0002\u0010\u0014\u001a\u00020\u0015J.\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\b\b\u0002\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J0\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u0013\u001a\u00020\u000b2\b\b\u0002\u0010\u0014\u001a\u00020\u0015J0\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J0\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J(\u0010 \u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020\u0006H\u0002J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\"2\u0006\u0010$\u001a\u00020\u0006H\u0002J(\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0002JD\u0010)\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00042\b\u0010*\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010+\u001a\u00020\u0019H\u0002JD\u0010,\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00042\b\u0010*\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010+\u001a\u00020\u0019H\u0002J:\u0010-\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00042\b\u0010*\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J:\u0010.\u001a\u00020\u001b2\u0006\u0010/\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00042\b\u0010*\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J(\u00100\u001a\u0002012\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u00102\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J(\u00103\u001a\u0002012\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u00104\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\f\u00105\u001a\u000206*\u000207H\u0002J\u001c\u00108\u001a\u000201*\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u00109\u001a\u00020:H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/IdePluginManager;", "Lcom/jetbrains/plugin/structure/base/plugin/PluginManager;", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "myResourceResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "extractDirectory", "Ljava/nio/file/Path;", "fileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "(Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;Ljava/nio/file/Path;Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;)V", "THIRD_PARTY_LIBRARIES_FILE_NAME", "", "optionalDependencyResolver", "Lcom/jetbrains/plugin/structure/intellij/plugin/OptionalDependencyResolver;", "createBundledModule", "Lcom/jetbrains/plugin/structure/base/plugin/PluginCreationResult;", "pluginFile", "ideVersion", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "descriptorPath", "problemResolver", "Lcom/jetbrains/plugin/structure/intellij/problems/PluginCreationResultResolver;", "createBundledPlugin", "createPlugin", "validateDescriptor", "", "extractZipAndCreatePlugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;", "resourceResolver", "getInvalidPluginFileCreator", "pluginFileName", "getPluginCreator", "getPluginCreatorWithResult", "getThirdPartyDependenciesFromDir", "", "Lcom/jetbrains/plugin/structure/base/plugin/ThirdPartyDependency;", "pluginDirectory", "loadIconsFromDir", "Lcom/jetbrains/plugin/structure/base/plugin/PluginIcon;", "loadModuleInfoFromJarFile", "jarFile", "loadPluginInfoFromDirectory", "parentPlugin", "hasDotNetDirectory", "loadPluginInfoFromJarFile", "loadPluginInfoFromJarOrDirectory", "loadPluginInfoFromLibDirectory", "root", "resolveContentModules", "", "currentPlugin", "resolveOptionalDependencies", "pluginCreator", "loadXml", "Lorg/jdom2/Document;", "Lcom/jetbrains/plugin/structure/jar/PluginDescriptorResult$Found;", "setTelemetry", "pluginCreationDurationInMillis", "", "Companion", "structure-intellij"})
@SourceDebugExtension(value={"SMAP\nIdePluginManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdePluginManager.kt\ncom/jetbrains/plugin/structure/intellij/plugin/IdePluginManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,473:1\n11653#2,9:474\n13579#2:483\n13580#2:485\n11662#2:486\n1#3:484\n1#3:490\n766#4:487\n857#4,2:488\n17#5,6:491\n*E\n*S KotlinDebug\n*F\n+ 1 IdePluginManager.kt\ncom/jetbrains/plugin/structure/intellij/plugin/IdePluginManager\n*L\n178#1,9:474\n178#1:483\n178#1:485\n178#1:486\n178#1:484\n205#1:487\n205#1,2:488\n376#1,6:491\n*E\n"})
public final class IdePluginManager
implements PluginManager<IdePlugin> {
    private final String THIRD_PARTY_LIBRARIES_FILE_NAME;
    private final OptionalDependencyResolver optionalDependencyResolver;
    private final ResourceResolver myResourceResolver;
    private final Path extractDirectory;
    private final JarFileSystemProvider fileSystemProvider;
    private static final Logger LOG;
    @NotNull
    public static final String PLUGIN_XML = "plugin.xml";
    @NotNull
    public static final String META_INF = "META-INF";
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PluginCreator loadPluginInfoFromJarFile(Path jarFile, String descriptorPath, boolean validateDescriptor, ResourceResolver resourceResolver, PluginCreator parentPlugin, PluginCreationResultResolver problemResolver, boolean hasDotNetDirectory) {
        Object object;
        try {
            PluginCreator pluginCreator;
            object = (AutoCloseable)new PluginJar(jarFile, this.fileSystemProvider);
            Throwable throwable = null;
            try {
                PluginCreator pluginCreator2;
                PluginCreator pluginCreator3;
                PluginJar jar = (PluginJar)object;
                boolean bl = false;
                PluginDescriptorResult descriptor = jar.getPluginDescriptor("META-INF/" + descriptorPath);
                if (descriptor instanceof PluginDescriptorResult.Found) {
                    try {
                        PluginCreator pluginCreator4;
                        Document descriptorXml = this.loadXml((PluginDescriptorResult.Found)descriptor);
                        PluginCreator $this$apply = pluginCreator4 = PluginCreator.Companion.createPlugin(FileUtilKt.getSimpleName((Path)jarFile), descriptorPath, parentPlugin, validateDescriptor, descriptorXml, ((PluginDescriptorResult.Found)descriptor).getPath(), resourceResolver, problemResolver);
                        boolean bl2 = false;
                        $this$apply.setIcons(jar.getIcons());
                        $this$apply.setThirdPartyDependencies(jar.getThirdPartyDependencies());
                        $this$apply.setHasDotNetPart(hasDotNetDirectory);
                        pluginCreator3 = pluginCreator4;
                    }
                    catch (Exception e) {
                        LOG.warn("Unable to read descriptor [" + descriptorPath + "] from [" + jarFile + "]", (Throwable)e);
                        String message2 = e.getLocalizedMessage();
                        pluginCreator3 = PluginCreator.Companion.createInvalidPlugin(jarFile, descriptorPath, (PluginProblem)new UnableToReadDescriptor(descriptorPath, message2));
                    }
                    pluginCreator2 = pluginCreator3;
                } else {
                    PluginCreator it = pluginCreator3 = PluginCreator.Companion.createInvalidPlugin(jarFile, descriptorPath, (PluginProblem)new PluginDescriptorIsNotFound(descriptorPath));
                    boolean bl3 = false;
                    LOG.debug("Unable to resolve descriptor [{}] from [{}] ({})", new Object[]{descriptorPath, jarFile, descriptor});
                    pluginCreator2 = pluginCreator3;
                }
                pluginCreator = pluginCreator2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
            }
            object = pluginCreator;
        }
        catch (JarArchiveCannotBeOpenException e) {
            LOG.warn("Unable to extract {} (searching for {}): {}", new Object[]{jarFile, descriptorPath, LanguageUtilsKt.getShortExceptionMessage((Throwable)e)});
            object = PluginCreator.Companion.createInvalidPlugin(jarFile, descriptorPath, (PluginProblem)new UnableToExtractZip());
        }
        return object;
    }

    static /* synthetic */ PluginCreator loadPluginInfoFromJarFile$default(IdePluginManager idePluginManager, Path path, String string, boolean bl, ResourceResolver resourceResolver, PluginCreator pluginCreator, PluginCreationResultResolver pluginCreationResultResolver, boolean bl2, int n, Object object) {
        if ((n & 0x40) != 0) {
            bl2 = false;
        }
        return idePluginManager.loadPluginInfoFromJarFile(path, string, bl, resourceResolver, pluginCreator, pluginCreationResultResolver, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PluginCreator loadModuleInfoFromJarFile(Path jarFile, String descriptorPath, ResourceResolver resourceResolver, PluginCreationResultResolver problemResolver) {
        Object object;
        try {
            PluginCreator pluginCreator;
            object = (AutoCloseable)new PluginJar(jarFile, this.fileSystemProvider);
            Throwable throwable = null;
            try {
                PluginCreator pluginCreator2;
                PluginCreator pluginCreator3;
                PluginJar jar = (PluginJar)object;
                boolean bl = false;
                PluginDescriptorResult descriptor = jar.getPluginDescriptor(descriptorPath);
                if (descriptor instanceof PluginDescriptorResult.Found) {
                    try {
                        Document descriptorXml = this.loadXml((PluginDescriptorResult.Found)descriptor);
                        pluginCreator3 = PluginCreator.Companion.createPlugin(FileUtilKt.getSimpleName((Path)jarFile), descriptorPath, null, false, descriptorXml, ((PluginDescriptorResult.Found)descriptor).getPath(), resourceResolver, problemResolver);
                    }
                    catch (Exception e) {
                        LOG.warn("Unable to read descriptor [" + descriptorPath + "] from [" + jarFile + "]", (Throwable)e);
                        String message2 = e.getLocalizedMessage();
                        pluginCreator3 = PluginCreator.Companion.createInvalidPlugin(jarFile, descriptorPath, (PluginProblem)new UnableToReadDescriptor(descriptorPath, message2));
                    }
                    pluginCreator2 = pluginCreator3;
                } else {
                    PluginCreator it = pluginCreator3 = PluginCreator.Companion.createInvalidPlugin(jarFile, descriptorPath, (PluginProblem)new PluginDescriptorIsNotFound(descriptorPath));
                    boolean bl2 = false;
                    LOG.debug("Unable to resolve descriptor [{}] from [{}] ({})", new Object[]{descriptorPath, jarFile, descriptor});
                    pluginCreator2 = pluginCreator3;
                }
                pluginCreator = pluginCreator2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
            }
            object = pluginCreator;
        }
        catch (JarArchiveCannotBeOpenException e) {
            LOG.warn("Unable to extract {} (searching for {}): {}", new Object[]{jarFile, descriptorPath, LanguageUtilsKt.getShortExceptionMessage((Throwable)e)});
            object = PluginCreator.Companion.createInvalidPlugin(jarFile, descriptorPath, (PluginProblem)new UnableToExtractZip());
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Document loadXml(PluginDescriptorResult.Found $this$loadXml) {
        Document document2;
        Closeable closeable = $this$loadXml.getInputStream();
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            Document document3 = JDOMUtil.loadDocument(it);
            document2 = document3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"inputStream.use {\n      \u2026il.loadDocument(it)\n    }");
        return document2;
    }

    private final PluginCreator loadPluginInfoFromDirectory(Path pluginDirectory, String descriptorPath, boolean validateDescriptor, ResourceResolver resourceResolver, PluginCreator parentPlugin, PluginCreationResultResolver problemResolver, boolean hasDotNetDirectory) {
        PluginCreator pluginCreator;
        Path descriptorFile;
        Path path = descriptorFile = pluginDirectory.resolve(META_INF).resolve(FileUtilKt.withPathSeparatorOf((String)descriptorPath, (Path)pluginDirectory));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"descriptorFile");
        if (!FileUtilKt.exists((Path)path)) {
            pluginCreator = this.loadPluginInfoFromLibDirectory(pluginDirectory, descriptorPath, validateDescriptor, resourceResolver, parentPlugin, problemResolver);
        } else {
            PluginCreator pluginCreator2;
            try {
                PluginCreator pluginCreator3;
                Document document2 = JDOMUtil.loadDocument(Files.newInputStream(descriptorFile, new OpenOption[0]));
                Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"JDOMUtil.loadDocument(Fi\u2026utStream(descriptorFile))");
                Document document3 = document2;
                List<PluginIcon> icons = this.loadIconsFromDir(pluginDirectory);
                List<ThirdPartyDependency> dependencies = this.getThirdPartyDependenciesFromDir(pluginDirectory);
                PluginCreator $this$apply = pluginCreator3 = PluginCreator.Companion.createPlugin(FileUtilKt.getSimpleName((Path)pluginDirectory), descriptorPath, parentPlugin, validateDescriptor, document3, descriptorFile, resourceResolver, problemResolver);
                boolean bl = false;
                $this$apply.setIcons(icons);
                $this$apply.setThirdPartyDependencies(dependencies);
                $this$apply.setHasDotNetPart(hasDotNetDirectory);
                pluginCreator2 = pluginCreator3;
            }
            catch (JDOMParseException e) {
                LOG.info("Unable to parse plugin descriptor " + descriptorPath + " of plugin " + descriptorFile, (Throwable)e);
                pluginCreator2 = PluginCreator.Companion.createInvalidPlugin(pluginDirectory, descriptorPath, (PluginProblem)new UnexpectedDescriptorElements(e.getLineNumber(), descriptorPath));
            }
            catch (Exception e) {
                LOG.info("Unable to read plugin descriptor " + descriptorPath + " of plugin " + descriptorFile, (Throwable)e);
                pluginCreator2 = PluginCreator.Companion.createInvalidPlugin(pluginDirectory, descriptorPath, (PluginProblem)new UnableToReadDescriptor(descriptorPath, descriptorPath));
            }
            pluginCreator = pluginCreator2;
        }
        return pluginCreator;
    }

    static /* synthetic */ PluginCreator loadPluginInfoFromDirectory$default(IdePluginManager idePluginManager, Path path, String string, boolean bl, ResourceResolver resourceResolver, PluginCreator pluginCreator, PluginCreationResultResolver pluginCreationResultResolver, boolean bl2, int n, Object object) {
        if ((n & 0x40) != 0) {
            bl2 = false;
        }
        return idePluginManager.loadPluginInfoFromDirectory(path, string, bl, resourceResolver, pluginCreator, pluginCreationResultResolver, bl2);
    }

    private final List<ThirdPartyDependency> getThirdPartyDependenciesFromDir(Path pluginDirectory) {
        Path path;
        Path path2 = path = pluginDirectory.resolve(META_INF).resolve(this.THIRD_PARTY_LIBRARIES_FILE_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
        return ThirdPartyDependencyKt.parseThirdPartyDependenciesByPath((Path)path2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<PluginIcon> loadIconsFromDir(Path pluginDirectory) throws IOException {
        void $this$mapNotNullTo$iv$iv;
        IconTheme[] $this$mapNotNull$iv = IconTheme.values();
        boolean $i$f$mapNotNull = false;
        IconTheme[] iconThemeArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            PluginIcon pluginIcon;
            PluginIcon pluginIcon2;
            Path iconFile;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void theme = element$iv$iv;
            boolean bl2 = false;
            Path path = iconFile = pluginDirectory.resolve(META_INF).resolve(IdePluginManager.Companion.getIconFileName((IconTheme)theme));
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"iconFile");
            if (FileUtilKt.exists((Path)path)) {
                byte[] byArray = Files.readAllBytes(iconFile);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Files.readAllBytes(iconFile)");
                pluginIcon2 = new PluginIcon((IconTheme)theme, byArray, FileUtilKt.getSimpleName((Path)iconFile));
            } else {
                pluginIcon2 = null;
            }
            if (pluginIcon2 == null) continue;
            PluginIcon it$iv$iv = pluginIcon = pluginIcon2;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final PluginCreator loadPluginInfoFromLibDirectory(Path root, String descriptorPath, boolean validateDescriptor, ResourceResolver resourceResolver, PluginCreator parentPlugin, PluginCreationResultResolver problemResolver) {
        PluginCreator pluginCreator;
        void $this$filterTo$iv$iv;
        Path libDir = root.resolve("lib");
        Path path = root.resolve("dotnet");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"root.resolve(\"dotnet\")");
        boolean hasDotNetDirectory = FileUtilKt.exists((Path)path);
        Path path2 = libDir;
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"libDir");
        if (!FileUtilKt.isDirectory((Path)path2)) {
            return PluginCreator.Companion.createInvalidPlugin(root, descriptorPath, (PluginProblem)new PluginDescriptorIsNotFound(descriptorPath));
        }
        List files = FileUtilKt.listFiles((Path)libDir);
        if (files.isEmpty()) {
            return PluginCreator.Companion.createInvalidPlugin(root, descriptorPath, (PluginProblem)new PluginLibDirectoryIsEmpty());
        }
        Iterable $this$filter$iv = files;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Path it = (Path)element$iv$iv;
            boolean bl = false;
            if (!FileUtilKt.isJar((Path)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List jarFiles = (List)destination$iv$iv;
        ResourceResolver libResourceResolver = new JarFilesResourceResolver(jarFiles);
        ResourceResolver compositeResolver = new CompositeResourceResolver(CollectionsKt.listOf((Object[])new ResourceResolver[]{libResourceResolver, resourceResolver}));
        List results = new ArrayList();
        for (Path file : files) {
            PluginCreator pluginCreator2;
            if (FileUtilKt.isJar((Path)file) || FileUtilKt.isZip((Path)file)) {
                pluginCreator2 = this.loadPluginInfoFromJarFile(file, descriptorPath, validateDescriptor, compositeResolver, parentPlugin, problemResolver, hasDotNetDirectory);
            } else {
                if (!FileUtilKt.isDirectory((Path)file)) continue;
                pluginCreator2 = this.loadPluginInfoFromDirectory(file, descriptorPath, validateDescriptor, resourceResolver, parentPlugin, problemResolver, hasDotNetDirectory);
            }
            PluginCreator innerCreator = pluginCreator2;
            results.add(innerCreator);
        }
        List possibleResults2 = results.stream().filter(loadPluginInfoFromLibDirectory.possibleResults.1.INSTANCE).collect(Collectors.toList());
        switch (possibleResults2.size()) {
            case 0: {
                pluginCreator = PluginCreator.Companion.createInvalidPlugin(root, descriptorPath, (PluginProblem)new PluginDescriptorIsNotFound(descriptorPath));
                break;
            }
            case 1: {
                Object t = possibleResults2.get(0);
                Intrinsics.checkNotNullExpressionValue(t, (String)"possibleResults[0]");
                pluginCreator = (PluginCreator)t;
                break;
            }
            default: {
                PluginCreator first = (PluginCreator)possibleResults2.get(0);
                PluginCreator second = (PluginCreator)possibleResults2.get(1);
                PluginProblem multipleDescriptorsProblem = (PluginProblem)new MultiplePluginDescriptors(first.getDescriptorPath(), first.getPluginFileName(), second.getDescriptorPath(), second.getPluginFileName());
                pluginCreator = PluginCreator.Companion.createInvalidPlugin(root, descriptorPath, multipleDescriptorsProblem);
            }
        }
        return pluginCreator;
    }

    private final PluginCreator loadPluginInfoFromJarOrDirectory(Path pluginFile, String descriptorPath, boolean validateDescriptor, ResourceResolver resourceResolver, PluginCreator parentPlugin, PluginCreationResultResolver problemResolver) {
        PluginCreator pluginCreator;
        LOG.debug("Loading {} with descriptor [{}]", (Object)pluginFile, (Object)descriptorPath);
        String systemIndependentDescriptorPath = FileUtilKt.toSystemIndependentName((String)descriptorPath);
        if (FileUtilKt.isDirectory((Path)pluginFile)) {
            pluginCreator = IdePluginManager.loadPluginInfoFromDirectory$default(this, pluginFile, systemIndependentDescriptorPath, validateDescriptor, resourceResolver, parentPlugin, problemResolver, false, 64, null);
        } else if (FileUtilKt.isJar((Path)pluginFile)) {
            pluginCreator = IdePluginManager.loadPluginInfoFromJarFile$default(this, pluginFile, systemIndependentDescriptorPath, validateDescriptor, resourceResolver, parentPlugin, problemResolver, false, 64, null);
        } else {
            throw (Throwable)new IllegalArgumentException();
        }
        return pluginCreator;
    }

    private final void resolveOptionalDependencies(Path pluginFile, PluginCreator pluginCreator, ResourceResolver resourceResolver, PluginCreationResultResolver problemResolver) {
        if (pluginCreator.isSuccess()) {
            this.optionalDependencyResolver.resolveOptionalDependencies(pluginCreator, pluginFile, resourceResolver, problemResolver);
        }
    }

    private final void resolveContentModules(Path pluginFile, PluginCreator currentPlugin, ResourceResolver resourceResolver, PluginCreationResultResolver problemResolver) {
        if (currentPlugin.isSuccess()) {
            ArrayList<Module> contentModules = currentPlugin.getContentModules();
            for (Module module : contentModules) {
                String configFile = module.getConfigFile();
                PluginCreator moduleCreator = this.loadPluginInfoFromJarOrDirectory(pluginFile, configFile, false, resourceResolver, currentPlugin, problemResolver);
                currentPlugin.addModuleDescriptor(module.getName(), configFile, moduleCreator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PluginCreator extractZipAndCreatePlugin(Path pluginFile, String descriptorPath, boolean validateDescriptor, ResourceResolver resourceResolver, PluginCreationResultResolver problemResolver) {
        PluginCreator pluginCreator;
        ExtractorResult extractorResult;
        ExtractorResult extractorResult2;
        try {
            extractorResult2 = PluginExtractor.INSTANCE.extractPlugin(pluginFile, this.extractDirectory);
        }
        catch (Exception e) {
            LOG.info("Unable to extract plugin zip " + FileUtilKt.getSimpleName((Path)pluginFile), (Throwable)e);
            return PluginCreator.Companion.createInvalidPlugin(FileUtilKt.getSimpleName((Path)pluginFile), descriptorPath, (PluginProblem)new UnableToExtractZip());
        }
        extractorResult2 = extractorResult = extractorResult2;
        if (extractorResult2 instanceof ExtractorResult.Success) {
            Closeable closeable = ((ExtractorResult.Success)extractorResult).getExtractedPlugin();
            Throwable throwable = null;
            try {
                ExtractedPlugin $dstr$extractedFile = (ExtractedPlugin)closeable;
                boolean bl = false;
                Path extractedFile = $dstr$extractedFile.component1();
                PluginCreator pluginCreator2 = FileUtilKt.isJar((Path)extractedFile) || FileUtilKt.isDirectory((Path)extractedFile) ? this.getPluginCreator(extractedFile, descriptorPath, validateDescriptor, resourceResolver, problemResolver) : this.getInvalidPluginFileCreator(FileUtilKt.getSimpleName((Path)pluginFile), descriptorPath);
                pluginCreator = pluginCreator2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else if (extractorResult2 instanceof ExtractorResult.Fail) {
            pluginCreator = PluginCreator.Companion.createInvalidPlugin(FileUtilKt.getSimpleName((Path)pluginFile), descriptorPath, ((ExtractorResult.Fail)extractorResult).getPluginProblem());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return pluginCreator;
    }

    @NotNull
    public PluginCreationResult<IdePlugin> createPlugin(@NotNull Path pluginFile) {
        Intrinsics.checkNotNullParameter((Object)pluginFile, (String)"pluginFile");
        return IdePluginManager.createPlugin$default(this, pluginFile, true, null, null, 12, null);
    }

    @NotNull
    public final PluginCreationResult<IdePlugin> createPlugin(@NotNull Path pluginFile, boolean validateDescriptor, @NotNull String descriptorPath, @NotNull PluginCreationResultResolver problemResolver) {
        Intrinsics.checkNotNullParameter((Object)pluginFile, (String)"pluginFile");
        Intrinsics.checkNotNullParameter((Object)descriptorPath, (String)"descriptorPath");
        Intrinsics.checkNotNullParameter((Object)problemResolver, (String)"problemResolver");
        PluginCreator pluginCreator = this.getPluginCreatorWithResult(pluginFile, validateDescriptor, descriptorPath, problemResolver);
        return pluginCreator.getPluginCreationResult();
    }

    public static /* synthetic */ PluginCreationResult createPlugin$default(IdePluginManager idePluginManager, Path path, boolean bl, String string, PluginCreationResultResolver pluginCreationResultResolver, int n, Object object) {
        if ((n & 4) != 0) {
            string = PLUGIN_XML;
        }
        if ((n & 8) != 0) {
            pluginCreationResultResolver = new IntelliJPluginCreationResultResolver();
        }
        return idePluginManager.createPlugin(path, bl, string, pluginCreationResultResolver);
    }

    @NotNull
    public final PluginCreationResult<IdePlugin> createBundledPlugin(@NotNull Path pluginFile, @NotNull IdeVersion ideVersion, @NotNull String descriptorPath, @NotNull PluginCreationResultResolver problemResolver) {
        Intrinsics.checkNotNullParameter((Object)pluginFile, (String)"pluginFile");
        Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
        Intrinsics.checkNotNullParameter((Object)descriptorPath, (String)"descriptorPath");
        Intrinsics.checkNotNullParameter((Object)problemResolver, (String)"problemResolver");
        PluginCreator pluginCreator = this.getPluginCreatorWithResult(pluginFile, false, descriptorPath, problemResolver);
        String string = ideVersion.asStringWithoutProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ideVersion.asStringWithoutProductCode()");
        pluginCreator.setPluginVersion(string);
        return pluginCreator.getPluginCreationResult();
    }

    public static /* synthetic */ PluginCreationResult createBundledPlugin$default(IdePluginManager idePluginManager, Path path, IdeVersion ideVersion, String string, PluginCreationResultResolver pluginCreationResultResolver, int n, Object object) {
        if ((n & 8) != 0) {
            pluginCreationResultResolver = new IntelliJPluginCreationResultResolver();
        }
        return idePluginManager.createBundledPlugin(path, ideVersion, string, pluginCreationResultResolver);
    }

    @NotNull
    public final PluginCreationResult<IdePlugin> createBundledModule(@NotNull Path pluginFile, @NotNull IdeVersion ideVersion, @NotNull String descriptorPath, @NotNull PluginCreationResultResolver problemResolver) {
        PluginCreator pluginCreator;
        Intrinsics.checkNotNullParameter((Object)pluginFile, (String)"pluginFile");
        Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
        Intrinsics.checkNotNullParameter((Object)descriptorPath, (String)"descriptorPath");
        Intrinsics.checkNotNullParameter((Object)problemResolver, (String)"problemResolver");
        PluginCreator $this$apply = pluginCreator = this.loadModuleInfoFromJarFile(pluginFile, descriptorPath, this.myResourceResolver, problemResolver);
        boolean bl = false;
        String string = ideVersion.asStringWithoutProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ideVersion.asStringWithoutProductCode()");
        $this$apply.setPluginVersion(string);
        $this$apply.setOriginalFile(pluginFile);
        return pluginCreator.getPluginCreationResult();
    }

    public static /* synthetic */ PluginCreationResult createBundledModule$default(IdePluginManager idePluginManager, Path path, IdeVersion ideVersion, String string, PluginCreationResultResolver pluginCreationResultResolver, int n, Object object) {
        if ((n & 8) != 0) {
            pluginCreationResultResolver = new IntelliJPluginCreationResultResolver();
        }
        return idePluginManager.createBundledModule(path, ideVersion, string, pluginCreationResultResolver);
    }

    private final PluginCreator getPluginCreatorWithResult(Path pluginFile, boolean validateDescriptor, String descriptorPath, PluginCreationResultResolver problemResolver) {
        long l;
        boolean bl = FileUtilKt.exists((Path)pluginFile);
        if (!bl) {
            boolean $i$a$-require-IdePluginManager$getPluginCreatorWithResult$22 = false;
            String $i$a$-require-IdePluginManager$getPluginCreatorWithResult$22 = "Plugin file " + pluginFile + " does not exist";
            throw new IllegalArgumentException($i$a$-require-IdePluginManager$getPluginCreatorWithResult$22.toString());
        }
        PluginCreator pluginCreator = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl2 = false;
        pluginCreator = FileUtilKt.isZip((Path)pluginFile) ? this.extractZipAndCreatePlugin(pluginFile, descriptorPath, validateDescriptor, this.myResourceResolver, problemResolver) : (FileUtilKt.isJar((Path)pluginFile) || FileUtilKt.isDirectory((Path)pluginFile) ? this.getPluginCreator(pluginFile, descriptorPath, validateDescriptor, this.myResourceResolver, problemResolver) : this.getInvalidPluginFileCreator(FileUtilKt.getSimpleName((Path)pluginFile), descriptorPath));
        pluginCreator.setOriginalFile(pluginFile);
        long pluginCreationDuration = l = System.currentTimeMillis() - start$iv;
        boolean bl3 = false;
        this.setTelemetry(pluginCreator, pluginFile, pluginCreationDuration);
        return pluginCreator;
    }

    private final PluginCreator getPluginCreator(Path pluginFile, String descriptorPath, boolean validateDescriptor, ResourceResolver resourceResolver, PluginCreationResultResolver problemResolver) {
        PluginCreator pluginCreator = this.loadPluginInfoFromJarOrDirectory(pluginFile, descriptorPath, validateDescriptor, resourceResolver, null, problemResolver);
        this.resolveOptionalDependencies(pluginFile, pluginCreator, this.myResourceResolver, problemResolver);
        this.resolveContentModules(pluginFile, pluginCreator, this.myResourceResolver, problemResolver);
        return pluginCreator;
    }

    private final PluginCreator getInvalidPluginFileCreator(String pluginFileName, String descriptorPath) {
        return PluginCreator.Companion.createInvalidPlugin(pluginFileName, descriptorPath, (PluginProblem)new IncorrectZipOrJarFile(pluginFileName));
    }

    private final void setTelemetry(PluginCreator $this$setTelemetry, Path pluginFile, long pluginCreationDurationInMillis) {
        MutablePluginTelemetry mutablePluginTelemetry;
        MutablePluginTelemetry $this$with = mutablePluginTelemetry = $this$setTelemetry.getTelemetry();
        boolean bl = false;
        $this$with.setParsingDuration(Duration.ofMillis(pluginCreationDurationInMillis));
        $this$with.setArchiveFileSize(FileUtilKt.getPluginSize((Path)pluginFile));
    }

    private IdePluginManager(ResourceResolver myResourceResolver, Path extractDirectory, JarFileSystemProvider fileSystemProvider) {
        this.myResourceResolver = myResourceResolver;
        this.extractDirectory = extractDirectory;
        this.fileSystemProvider = fileSystemProvider;
        this.THIRD_PARTY_LIBRARIES_FILE_NAME = "dependencies.json";
        Function6 function6 = (Function6)new Function6<Path, String, Boolean, ResourceResolver, PluginCreator, PluginCreationResultResolver, PluginCreator>(this){

            @NotNull
            public final PluginCreator invoke(@NotNull Path p1, @NotNull String p2, boolean p3, @NotNull ResourceResolver p4, @Nullable PluginCreator p5, @NotNull PluginCreationResultResolver p6) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                Intrinsics.checkNotNullParameter((Object)p4, (String)"p4");
                Intrinsics.checkNotNullParameter((Object)p6, (String)"p6");
                return IdePluginManager.access$loadPluginInfoFromJarOrDirectory((IdePluginManager)this.receiver, p1, p2, p3, p4, p5, p6);
            }
        };
        this.optionalDependencyResolver = new OptionalDependencyResolver(new PluginLoader(function6){
            private final /* synthetic */ Function6 function;
            {
                this.function = function6;
            }

            public final /* synthetic */ PluginCreator load(Path pluginFile, String descriptorPath, boolean validateDescriptor, ResourceResolver resourceResolver, PluginCreator parentPlugin, PluginCreationResultResolver problemResolver) {
                Intrinsics.checkNotNullParameter((Object)pluginFile, (String)"pluginFile");
                Intrinsics.checkNotNullParameter((Object)descriptorPath, (String)"descriptorPath");
                Intrinsics.checkNotNullParameter((Object)resourceResolver, (String)"resourceResolver");
                Intrinsics.checkNotNullParameter((Object)problemResolver, (String)"problemResolver");
                Object object = this.function.invoke((Object)pluginFile, (Object)descriptorPath, (Object)validateDescriptor, (Object)resourceResolver, (Object)parentPlugin, (Object)problemResolver);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invoke(...)");
                return (PluginCreator)object;
            }

            public Function getFunctionDelegate() {
                return this.function;
            }

            public boolean equals(Object object) {
                return object instanceof PluginLoader && object instanceof FunctionAdapter && Intrinsics.areEqual((Object)this.function, (Object)((FunctionAdapter)object).getFunctionDelegate());
            }

            public int hashCode() {
                return this.function.hashCode();
            }
        });
    }

    /* synthetic */ IdePluginManager(ResourceResolver resourceResolver, Path path, JarFileSystemProvider jarFileSystemProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            jarFileSystemProvider = (JarFileSystemProvider)SingletonCachingJarFileSystemProvider.INSTANCE;
        }
        this(resourceResolver, path, jarFileSystemProvider);
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(IdePluginManager.class);
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="createPlugin(pluginFile.toPath())"), message="Use method with java.nio.Path instead of java.io.File")
    @NotNull
    public PluginCreationResult<IdePlugin> createPlugin(@NotNull File pluginFile) {
        Intrinsics.checkNotNullParameter((Object)pluginFile, (String)"pluginFile");
        return PluginManager.DefaultImpls.createPlugin((PluginManager)this, (File)pluginFile);
    }

    public static final /* synthetic */ PluginCreator access$loadPluginInfoFromJarOrDirectory(IdePluginManager $this, Path pluginFile, String descriptorPath, boolean validateDescriptor, ResourceResolver resourceResolver, PluginCreator parentPlugin, PluginCreationResultResolver problemResolver) {
        return $this.loadPluginInfoFromJarOrDirectory(pluginFile, descriptorPath, validateDescriptor, resourceResolver, parentPlugin, problemResolver);
    }

    public /* synthetic */ IdePluginManager(ResourceResolver myResourceResolver, Path extractDirectory, JarFileSystemProvider fileSystemProvider, DefaultConstructorMarker $constructor_marker) {
        this(myResourceResolver, extractDirectory, fileSystemProvider);
    }

    @JvmStatic
    @NotNull
    public static final IdePluginManager createManager() {
        return Companion.createManager();
    }

    @JvmStatic
    @NotNull
    public static final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver) {
        return Companion.createManager(resourceResolver);
    }

    @JvmStatic
    @NotNull
    public static final IdePluginManager createManager(@NotNull Path extractDirectory) {
        return Companion.createManager(extractDirectory);
    }

    @JvmStatic
    @NotNull
    public static final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver, @NotNull Path extractDirectory) {
        return Companion.createManager(resourceResolver, extractDirectory);
    }

    @JvmStatic
    @NotNull
    public static final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver, @NotNull Path extractDirectory, @NotNull JarFileSystemProvider fileSystemProvider) {
        return Companion.createManager(resourceResolver, extractDirectory, fileSystemProvider);
    }

    @Deprecated(message="Use factory method with java.nio.Path", replaceWith=@ReplaceWith(imports={}, expression="createManager(extractDirectory.toPath())"))
    @JvmStatic
    @NotNull
    public static final IdePluginManager createManager(@NotNull File extractDirectory) {
        return Companion.createManager(extractDirectory);
    }

    @Deprecated(message="Use factory method with java.nio.Path", replaceWith=@ReplaceWith(imports={}, expression="createManager(resourceResolver, extractDirectory.toPath())"))
    @JvmStatic
    @NotNull
    public static final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver, @NotNull File extractDirectory) {
        return Companion.createManager(resourceResolver, extractDirectory);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000fH\u0007J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000fH\u0007J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/IdePluginManager$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "META_INF", "", "PLUGIN_XML", "createManager", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePluginManager;", "resourceResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "extractDirectory", "Ljava/io/File;", "Ljava/nio/file/Path;", "fileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "getIconFileName", "iconTheme", "Lcom/jetbrains/plugin/structure/base/plugin/IconTheme;", "hasOnlyInvalidDescriptorErrors", "", "creator", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;", "structure-intellij"})
    @SourceDebugExtension(value={"SMAP\nIdePluginManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdePluginManager.kt\ncom/jetbrains/plugin/structure/intellij/plugin/IdePluginManager$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,473:1\n1726#2,3:474\n*E\n*S KotlinDebug\n*F\n+ 1 IdePluginManager.kt\ncom/jetbrains/plugin/structure/intellij/plugin/IdePluginManager$Companion\n*L\n466#1,3:474\n*E\n"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final IdePluginManager createManager() {
            return this.createManager((ResourceResolver)DefaultResourceResolver.INSTANCE, Settings.EXTRACT_DIRECTORY.getAsPath());
        }

        @JvmStatic
        @NotNull
        public final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver) {
            Intrinsics.checkNotNullParameter((Object)resourceResolver, (String)"resourceResolver");
            return this.createManager(resourceResolver, Settings.EXTRACT_DIRECTORY.getAsPath());
        }

        @JvmStatic
        @NotNull
        public final IdePluginManager createManager(@NotNull Path extractDirectory) {
            Intrinsics.checkNotNullParameter((Object)extractDirectory, (String)"extractDirectory");
            return this.createManager((ResourceResolver)DefaultResourceResolver.INSTANCE, extractDirectory);
        }

        @JvmStatic
        @NotNull
        public final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver, @NotNull Path extractDirectory) {
            Intrinsics.checkNotNullParameter((Object)resourceResolver, (String)"resourceResolver");
            Intrinsics.checkNotNullParameter((Object)extractDirectory, (String)"extractDirectory");
            return new IdePluginManager(resourceResolver, extractDirectory, null, 4, null);
        }

        @JvmStatic
        @NotNull
        public final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver, @NotNull Path extractDirectory, @NotNull JarFileSystemProvider fileSystemProvider) {
            Intrinsics.checkNotNullParameter((Object)resourceResolver, (String)"resourceResolver");
            Intrinsics.checkNotNullParameter((Object)extractDirectory, (String)"extractDirectory");
            Intrinsics.checkNotNullParameter((Object)fileSystemProvider, (String)"fileSystemProvider");
            return new IdePluginManager(resourceResolver, extractDirectory, fileSystemProvider, null);
        }

        @Deprecated(message="Use factory method with java.nio.Path", replaceWith=@ReplaceWith(imports={}, expression="createManager(extractDirectory.toPath())"))
        @JvmStatic
        @NotNull
        public final IdePluginManager createManager(@NotNull File extractDirectory) {
            Intrinsics.checkNotNullParameter((Object)extractDirectory, (String)"extractDirectory");
            ResourceResolver resourceResolver = DefaultResourceResolver.INSTANCE;
            Path path = extractDirectory.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"extractDirectory.toPath()");
            return this.createManager(resourceResolver, path);
        }

        @Deprecated(message="Use factory method with java.nio.Path", replaceWith=@ReplaceWith(imports={}, expression="createManager(resourceResolver, extractDirectory.toPath())"))
        @JvmStatic
        @NotNull
        public final IdePluginManager createManager(@NotNull ResourceResolver resourceResolver, @NotNull File extractDirectory) {
            Intrinsics.checkNotNullParameter((Object)resourceResolver, (String)"resourceResolver");
            Intrinsics.checkNotNullParameter((Object)extractDirectory, (String)"extractDirectory");
            Path path = extractDirectory.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"extractDirectory.toPath()");
            return this.createManager(resourceResolver, path);
        }

        private final boolean hasOnlyInvalidDescriptorErrors(PluginCreator creator) {
            boolean bl;
            block7: {
                PluginCreationResult<IdePlugin> pluginCreationResult = creator.getPluginCreationResult();
                if (pluginCreationResult instanceof PluginCreationSuccess) {
                    bl = false;
                } else if (pluginCreationResult instanceof PluginCreationFail) {
                    List errorsAndWarnings = ((PluginCreationFail)pluginCreationResult).getErrorsAndWarnings();
                    Iterable $this$all$iv = errorsAndWarnings;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            PluginProblem it = (PluginProblem)element$iv;
                            boolean bl2 = false;
                            if (it.getLevel() != PluginProblem.Level.ERROR || PluginProblemsKt.isInvalidDescriptorProblem((PluginProblem)it)) continue;
                            bl = false;
                            break block7;
                        }
                        bl = true;
                    }
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return bl;
        }

        private final String getIconFileName(IconTheme iconTheme) {
            return "pluginIcon" + iconTheme.getSuffix() + ".svg";
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$hasOnlyInvalidDescriptorErrors(Companion $this, PluginCreator creator) {
            return $this.hasOnlyInvalidDescriptorErrors(creator);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

