/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.problems;

import com.jetbrains.plugin.structure.intellij.problems.IntelliJPluginCreationResultResolver;
import com.jetbrains.plugin.structure.intellij.problems.JetBrainsPluginCreationResultResolver;
import com.jetbrains.plugin.structure.intellij.problems.JsonUrlProblemLevelRemappingManager;
import com.jetbrains.plugin.structure.intellij.problems.LevelRemappingDefinition;
import com.jetbrains.plugin.structure.intellij.problems.LevelRemappingDefinitions;
import com.jetbrains.plugin.structure.intellij.problems.LevelRemappingPluginCreationResultResolver;
import com.jetbrains.plugin.structure.intellij.problems.PluginCreationResultResolver;
import com.jetbrains.plugin.structure.intellij.problems.ProblemLevelRemappingManager;
import java.io.IOException;
import java.net.URL;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004\u001a\u0006\u0010\b\u001a\u00020\t\u001a\u0012\u0010\n\u001a\u00020\u0006*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004\u001a\u0012\u0010\r\u001a\u00020\u000e*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "PLUGIN_PROBLEMS_FILE_NAME", "", "emptyLevelRemapping", "Lcom/jetbrains/plugin/structure/intellij/problems/LevelRemappingDefinition;", "name", "levelRemappingFromClassPathJson", "Lcom/jetbrains/plugin/structure/intellij/problems/JsonUrlProblemLevelRemappingManager;", "getLevelRemapping", "Lcom/jetbrains/plugin/structure/intellij/problems/ProblemLevelRemappingManager;", "levelRemappingDefinitionName", "newDefaultResolver", "Lcom/jetbrains/plugin/structure/intellij/problems/PluginCreationResultResolver;", "structure-intellij"})
public final class ProblemLevelRemappingManagerKt {
    @NotNull
    public static final String PLUGIN_PROBLEMS_FILE_NAME = "plugin-problems.json";
    private static final Logger LOG = LoggerFactory.getLogger(JsonUrlProblemLevelRemappingManager.class);

    @NotNull
    public static final JsonUrlProblemLevelRemappingManager levelRemappingFromClassPathJson() {
        URL uRL = JsonUrlProblemLevelRemappingManager.class.getResource(PLUGIN_PROBLEMS_FILE_NAME);
        if (uRL == null) {
            throw (Throwable)new IOException("Plugin problem level remapping definition cannot be found at <plugin-problems.json>");
        }
        URL pluginProblemsJsonUrl = uRL;
        return new JsonUrlProblemLevelRemappingManager(pluginProblemsJsonUrl);
    }

    @NotNull
    public static final LevelRemappingDefinition getLevelRemapping(@NotNull ProblemLevelRemappingManager $this$getLevelRemapping, @NotNull String levelRemappingDefinitionName) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)$this$getLevelRemapping, (String)"$this$getLevelRemapping");
        Intrinsics.checkNotNullParameter((Object)levelRemappingDefinitionName, (String)"levelRemappingDefinitionName");
        Object object3 = $this$getLevelRemapping;
        try {
            ProblemLevelRemappingManager $this$runCatching = object3;
            boolean bl = false;
            LevelRemappingDefinitions levelRemappings = $this$runCatching.initialize();
            LevelRemappingDefinition levelRemappingDefinition = levelRemappings.get(levelRemappingDefinitionName);
            if (levelRemappingDefinition == null) {
                LevelRemappingDefinition levelRemappingDefinition2;
                LevelRemappingDefinition it = levelRemappingDefinition2 = ProblemLevelRemappingManagerKt.emptyLevelRemapping(levelRemappingDefinitionName);
                boolean bl2 = false;
                LOG.warn("Plugin problem remapping definition '" + levelRemappingDefinitionName + "' was not found. Problem levels will not be remapped");
                levelRemappingDefinition = levelRemappingDefinition2;
            }
            LevelRemappingDefinition levelRemappingDefinition3 = levelRemappingDefinition;
            object2 = Result.constructor-impl((Object)levelRemappingDefinition3);
        }
        catch (Throwable bl) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object3 = object2;
        object2 = Result.exceptionOrNull-impl((Object)object3);
        if (object2 == null) {
            object = object3;
        } else {
            Object it = object2;
            boolean bl = false;
            LOG.error(((Throwable)it).getMessage(), (Throwable)it);
            object = ProblemLevelRemappingManagerKt.emptyLevelRemapping(levelRemappingDefinitionName);
        }
        return (LevelRemappingDefinition)object;
    }

    @NotNull
    public static final PluginCreationResultResolver newDefaultResolver(@NotNull ProblemLevelRemappingManager $this$newDefaultResolver, @NotNull String levelRemappingDefinitionName) {
        Intrinsics.checkNotNullParameter((Object)$this$newDefaultResolver, (String)"$this$newDefaultResolver");
        Intrinsics.checkNotNullParameter((Object)levelRemappingDefinitionName, (String)"levelRemappingDefinitionName");
        IntelliJPluginCreationResultResolver defaultResolver = new IntelliJPluginCreationResultResolver();
        LevelRemappingDefinition problemLevelRemapping = ProblemLevelRemappingManagerKt.getLevelRemapping($this$newDefaultResolver, levelRemappingDefinitionName);
        LevelRemappingPluginCreationResultResolver levelRemappingResolver = new LevelRemappingPluginCreationResultResolver(defaultResolver, problemLevelRemapping, false, 4, null);
        return JetBrainsPluginCreationResultResolver.Companion.fromClassPathJson(levelRemappingResolver);
    }

    @NotNull
    public static final LevelRemappingDefinition emptyLevelRemapping(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new LevelRemappingDefinition(name, MapsKt.emptyMap());
    }
}

