/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin.loaders;

import com.jetbrains.plugin.structure.base.problems.PluginDescriptorIsNotFound;
import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.problems.UnableToExtractZip;
import com.jetbrains.plugin.structure.base.problems.UnableToReadDescriptor;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.intellij.plugin.PluginCreator;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.JarModuleLoaderKt;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginLoader;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginLoadersKt;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginLoadingContext;
import com.jetbrains.plugin.structure.intellij.problems.PluginCreationResultResolver;
import com.jetbrains.plugin.structure.intellij.resources.ResourceResolver;
import com.jetbrains.plugin.structure.jar.JarArchiveCannotBeOpenException;
import com.jetbrains.plugin.structure.jar.JarFileSystemProvider;
import com.jetbrains.plugin.structure.jar.PluginDescriptorResult;
import com.jetbrains.plugin.structure.jar.PluginJar;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jdom2.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/JarModuleLoader;", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginLoader;", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/JarModuleLoader$Context;", "fileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "(Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;)V", "loadPlugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;", "pluginLoadingContext", "Context", "structure-intellij"})
public final class JarModuleLoader
implements PluginLoader<Context> {
    private final JarFileSystemProvider fileSystemProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public PluginCreator loadPlugin(@NotNull Context pluginLoadingContext) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)pluginLoadingContext, (String)"pluginLoadingContext");
        Context $this$with = pluginLoadingContext;
        boolean bl = false;
        try {
            PluginCreator pluginCreator;
            object = (AutoCloseable)new PluginJar($this$with.getJarPath(), this.fileSystemProvider);
            Throwable throwable = null;
            try {
                PluginCreator pluginCreator2;
                PluginCreator pluginCreator3;
                PluginJar jar = (PluginJar)object;
                boolean bl2 = false;
                PluginDescriptorResult descriptor = jar.getPluginDescriptor($this$with.getDescriptorPath());
                if (descriptor instanceof PluginDescriptorResult.Found) {
                    try {
                        Document descriptorXml = PluginLoadersKt.loadXml((PluginDescriptorResult.Found)descriptor);
                        pluginCreator3 = PluginCreator.Companion.createPlugin(FileUtilKt.getSimpleName((Path)$this$with.getJarPath()), $this$with.getDescriptorPath(), null, false, descriptorXml, ((PluginDescriptorResult.Found)descriptor).getPath(), $this$with.getResourceResolver(), $this$with.getProblemResolver());
                    }
                    catch (Exception e) {
                        JarModuleLoaderKt.access$getLOG$p().warn("Unable to read descriptor [" + $this$with.getDescriptorPath() + "] from [" + $this$with.getJarPath() + "]", (Throwable)e);
                        String message2 = e.getLocalizedMessage();
                        pluginCreator3 = PluginCreator.Companion.createInvalidPlugin($this$with.getJarPath(), $this$with.getDescriptorPath(), (PluginProblem)new UnableToReadDescriptor($this$with.getDescriptorPath(), message2));
                    }
                    pluginCreator2 = pluginCreator3;
                } else {
                    PluginCreator it = pluginCreator3 = PluginCreator.Companion.createInvalidPlugin($this$with.getJarPath(), $this$with.getDescriptorPath(), (PluginProblem)new PluginDescriptorIsNotFound($this$with.getDescriptorPath()));
                    boolean bl3 = false;
                    JarModuleLoaderKt.access$getLOG$p().debug("Unable to resolve descriptor [{}] from [{}] ({})", new Object[]{$this$with.getDescriptorPath(), $this$with.getJarPath(), descriptor});
                    pluginCreator2 = pluginCreator3;
                }
                pluginCreator = pluginCreator2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
            }
            object = pluginCreator;
        }
        catch (JarArchiveCannotBeOpenException e) {
            JarModuleLoaderKt.access$getLOG$p().warn("Unable to extract {} (searching for {}): {}", new Object[]{$this$with.getJarPath(), $this$with.getDescriptorPath(), LanguageUtilsKt.getShortExceptionMessage((Throwable)e)});
            object = PluginCreator.Companion.createInvalidPlugin($this$with.getJarPath(), $this$with.getDescriptorPath(), (PluginProblem)new UnableToExtractZip());
        }
        return object;
    }

    public JarModuleLoader(@NotNull JarFileSystemProvider fileSystemProvider) {
        Intrinsics.checkNotNullParameter((Object)fileSystemProvider, (String)"fileSystemProvider");
        this.fileSystemProvider = fileSystemProvider;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/JarModuleLoader$Context;", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginLoadingContext;", "jarPath", "Ljava/nio/file/Path;", "descriptorPath", "", "resourceResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "problemResolver", "Lcom/jetbrains/plugin/structure/intellij/problems/PluginCreationResultResolver;", "(Ljava/nio/file/Path;Ljava/lang/String;Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;Lcom/jetbrains/plugin/structure/intellij/problems/PluginCreationResultResolver;)V", "getDescriptorPath", "()Ljava/lang/String;", "getJarPath", "()Ljava/nio/file/Path;", "getProblemResolver", "()Lcom/jetbrains/plugin/structure/intellij/problems/PluginCreationResultResolver;", "getResourceResolver", "()Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "structure-intellij"})
    public static final class Context
    extends PluginLoadingContext {
        @NotNull
        private final Path jarPath;
        @NotNull
        private final String descriptorPath;
        @NotNull
        private final ResourceResolver resourceResolver;
        @NotNull
        private final PluginCreationResultResolver problemResolver;

        @NotNull
        public final Path getJarPath() {
            return this.jarPath;
        }

        @NotNull
        public final String getDescriptorPath() {
            return this.descriptorPath;
        }

        @Override
        @NotNull
        public ResourceResolver getResourceResolver() {
            return this.resourceResolver;
        }

        @Override
        @NotNull
        public PluginCreationResultResolver getProblemResolver() {
            return this.problemResolver;
        }

        public Context(@NotNull Path jarPath, @NotNull String descriptorPath, @NotNull ResourceResolver resourceResolver, @NotNull PluginCreationResultResolver problemResolver) {
            Intrinsics.checkNotNullParameter((Object)jarPath, (String)"jarPath");
            Intrinsics.checkNotNullParameter((Object)descriptorPath, (String)"descriptorPath");
            Intrinsics.checkNotNullParameter((Object)resourceResolver, (String)"resourceResolver");
            Intrinsics.checkNotNullParameter((Object)problemResolver, (String)"problemResolver");
            super(resourceResolver, problemResolver);
            this.jarPath = jarPath;
            this.descriptorPath = descriptorPath;
            this.resourceResolver = resourceResolver;
            this.problemResolver = problemResolver;
        }

        @NotNull
        public final Path component1() {
            return this.jarPath;
        }

        @NotNull
        public final String component2() {
            return this.descriptorPath;
        }

        @NotNull
        public final ResourceResolver component3() {
            return this.getResourceResolver();
        }

        @NotNull
        public final PluginCreationResultResolver component4() {
            return this.getProblemResolver();
        }

        @NotNull
        public final Context copy(@NotNull Path jarPath, @NotNull String descriptorPath, @NotNull ResourceResolver resourceResolver, @NotNull PluginCreationResultResolver problemResolver) {
            Intrinsics.checkNotNullParameter((Object)jarPath, (String)"jarPath");
            Intrinsics.checkNotNullParameter((Object)descriptorPath, (String)"descriptorPath");
            Intrinsics.checkNotNullParameter((Object)resourceResolver, (String)"resourceResolver");
            Intrinsics.checkNotNullParameter((Object)problemResolver, (String)"problemResolver");
            return new Context(jarPath, descriptorPath, resourceResolver, problemResolver);
        }

        public static /* synthetic */ Context copy$default(Context context, Path path, String string, ResourceResolver resourceResolver, PluginCreationResultResolver pluginCreationResultResolver, int n, Object object) {
            if ((n & 1) != 0) {
                path = context.jarPath;
            }
            if ((n & 2) != 0) {
                string = context.descriptorPath;
            }
            if ((n & 4) != 0) {
                resourceResolver = context.getResourceResolver();
            }
            if ((n & 8) != 0) {
                pluginCreationResultResolver = context.getProblemResolver();
            }
            return context.copy(path, string, resourceResolver, pluginCreationResultResolver);
        }

        @NotNull
        public String toString() {
            return "Context(jarPath=" + this.jarPath + ", descriptorPath=" + this.descriptorPath + ", resourceResolver=" + this.getResourceResolver() + ", problemResolver=" + this.getProblemResolver() + ")";
        }

        public int hashCode() {
            Path path = this.jarPath;
            String string = this.descriptorPath;
            ResourceResolver resourceResolver = this.getResourceResolver();
            PluginCreationResultResolver pluginCreationResultResolver = this.getProblemResolver();
            return (((path != null ? ((Object)path).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (resourceResolver != null ? resourceResolver.hashCode() : 0)) * 31 + (pluginCreationResultResolver != null ? pluginCreationResultResolver.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Context)) break block3;
                    Context context = (Context)object;
                    if (!Intrinsics.areEqual((Object)this.jarPath, (Object)context.jarPath) || !Intrinsics.areEqual((Object)this.descriptorPath, (Object)context.descriptorPath) || !Intrinsics.areEqual((Object)this.getResourceResolver(), (Object)context.getResourceResolver()) || !Intrinsics.areEqual((Object)this.getProblemResolver(), (Object)context.getProblemResolver())) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

