/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin.loaders;

import com.jetbrains.plugin.structure.base.plugin.PluginCreationFail;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationSuccess;
import com.jetbrains.plugin.structure.base.problems.MultiplePluginDescriptors;
import com.jetbrains.plugin.structure.base.problems.PluginDescriptorIsNotFound;
import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.problems.PluginProblemsKt;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.intellij.plugin.Classpath;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.IdePluginManager;
import com.jetbrains.plugin.structure.intellij.plugin.PluginCreator;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.JarPluginLoader;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginDirectoryLoader;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginLoader;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginLoaderProvider;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginLoadingContext;
import com.jetbrains.plugin.structure.intellij.plugin.module.ContentModuleScanner;
import com.jetbrains.plugin.structure.intellij.plugin.module.ContentModules;
import com.jetbrains.plugin.structure.intellij.problems.PluginCreationResultResolver;
import com.jetbrains.plugin.structure.intellij.problems.PluginLibDirectoryIsEmpty;
import com.jetbrains.plugin.structure.intellij.resources.CompositeResourceResolver;
import com.jetbrains.plugin.structure.intellij.resources.JarsResourceResolver;
import com.jetbrains.plugin.structure.intellij.resources.ResourceResolver;
import com.jetbrains.plugin.structure.jar.JarFileSystemProvider;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\f\u0010\u0018\u001a\u00020\u0019*\u00020\u0019H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/LibDirectoryPluginLoader;", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginLoader;", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/LibDirectoryPluginLoader$Context;", "pluginLoaderRegistry", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginLoaderProvider;", "fileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "(Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginLoaderProvider;Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;)V", "contentModuleScanner", "Lcom/jetbrains/plugin/structure/intellij/plugin/module/ContentModuleScanner;", "directoryLoader", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginDirectoryLoader;", "getDirectoryLoader", "()Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginDirectoryLoader;", "jarLoader", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/JarPluginLoader;", "getJarLoader", "()Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/JarPluginLoader;", "hasOnlyInvalidDescriptorErrors", "", "creator", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;", "loadPlugin", "pluginLoadingContext", "withResolvedClasspath", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePluginManager$CreationResult;", "Context", "structure-intellij"})
@SourceDebugExtension(value={"SMAP\nLibDirectoryPluginLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibDirectoryPluginLoader.kt\ncom/jetbrains/plugin/structure/intellij/plugin/loaders/LibDirectoryPluginLoader\n+ 2 PluginLoaderProvider.kt\ncom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginLoaderProvider\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n21#2:136\n21#2:137\n766#3:138\n857#3,2:139\n766#3:141\n857#3,2:142\n1726#3,3:144\n*E\n*S KotlinDebug\n*F\n+ 1 LibDirectoryPluginLoader.kt\ncom/jetbrains/plugin/structure/intellij/plugin/loaders/LibDirectoryPluginLoader\n*L\n36#1:136\n39#1:137\n53#1:138\n53#1,2:139\n89#1:141\n89#1,2:142\n118#1,3:144\n*E\n"})
public final class LibDirectoryPluginLoader
implements PluginLoader<Context> {
    private final ContentModuleScanner contentModuleScanner;
    private final PluginLoaderProvider pluginLoaderRegistry;
    private final JarFileSystemProvider fileSystemProvider;

    private final JarPluginLoader getJarLoader() {
        PluginLoaderProvider this_$iv = this.pluginLoaderRegistry;
        boolean $i$f$get$structure_intellij = false;
        PluginLoader<JarPluginLoader.Context> pluginLoader = this_$iv.get$structure_intellij(JarPluginLoader.Context.class);
        if (pluginLoader == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.plugin.structure.intellij.plugin.loaders.JarPluginLoader");
        }
        return (JarPluginLoader)((PluginLoader)((JarPluginLoader)pluginLoader));
    }

    private final PluginDirectoryLoader getDirectoryLoader() {
        PluginLoaderProvider this_$iv = this.pluginLoaderRegistry;
        boolean $i$f$get$structure_intellij = false;
        PluginLoader<PluginDirectoryLoader.Context> pluginLoader = this_$iv.get$structure_intellij(PluginDirectoryLoader.Context.class);
        if (pluginLoader == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginDirectoryLoader");
        }
        return (PluginDirectoryLoader)((PluginLoader)((PluginDirectoryLoader)pluginLoader));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PluginCreator loadPlugin(@NotNull Context pluginLoadingContext) {
        PluginCreator pluginCreator;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Object element$iv$iv2;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)pluginLoadingContext, (String)"pluginLoadingContext");
        Context $this$with = pluginLoadingContext;
        boolean bl = false;
        Path libDir = $this$with.getLibDirectoryParent().resolve("lib");
        Path path = $this$with.getLibDirectoryParent().resolve("dotnet");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"libDirectoryParent.resolve(\"dotnet\")");
        boolean hasDotNetDirectory = FileUtilKt.exists((Path)path);
        Path path2 = libDir;
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"libDir");
        if (!FileUtilKt.isDirectory((Path)path2)) {
            return PluginCreator.Companion.createInvalidPlugin($this$with.getLibDirectoryParent(), $this$with.getDescriptorPath(), (PluginProblem)new PluginDescriptorIsNotFound($this$with.getDescriptorPath()));
        }
        List files = FileUtilKt.listFiles((Path)libDir);
        if (files.isEmpty()) {
            return PluginCreator.Companion.createInvalidPlugin($this$with.getLibDirectoryParent(), $this$with.getDescriptorPath(), (PluginProblem)new PluginLibDirectoryIsEmpty());
        }
        Iterable $this$filter$iv2 = files;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
            Path it = (Path)element$iv$iv2;
            boolean bl2 = false;
            if (!FileUtilKt.isJar((Path)it)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        List jarFiles = (List)destination$iv$iv;
        ResourceResolver libResourceResolver = new JarsResourceResolver(jarFiles, this.fileSystemProvider);
        ResourceResolver compositeResolver = new CompositeResourceResolver(CollectionsKt.listOf((Object[])new ResourceResolver[]{libResourceResolver, $this$with.getResourceResolver()}));
        List results = new ArrayList();
        for (Path file : files) {
            PluginCreator pluginCreator2;
            if (FileUtilKt.isJar((Path)file) || FileUtilKt.isZip((Path)file)) {
                pluginCreator2 = this.getJarLoader().loadPlugin(new JarPluginLoader.Context(file, $this$with.getDescriptorPath(), $this$with.getValidateDescriptor(), compositeResolver, $this$with.getParentPlugin(), $this$with.getProblemResolver(), hasDotNetDirectory));
            } else {
                if (!FileUtilKt.isDirectory((Path)file)) continue;
                pluginCreator2 = this.getDirectoryLoader().loadPlugin(new PluginDirectoryLoader.Context(file, $this$with.getDescriptorPath(), $this$with.getValidateDescriptor(), $this$with.getResourceResolver(), $this$with.getParentPlugin(), $this$with.getProblemResolver(), hasDotNetDirectory));
            }
            PluginCreator innerCreator = pluginCreator2;
            results.add(new IdePluginManager.CreationResult($this$with.getLibDirectoryParent(), innerCreator));
        }
        Iterable $i$f$filterTo22 = results;
        boolean $i$f$filter2 = false;
        element$iv$iv2 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv3 : $this$filterTo$iv$iv) {
            IdePluginManager.CreationResult $dstr$_u24__u24$r = (IdePluginManager.CreationResult)element$iv$iv3;
            boolean bl3 = false;
            PluginCreator r = $dstr$_u24__u24$r.component2();
            if (!(r.isSuccess() || this.hasOnlyInvalidDescriptorErrors(r))) continue;
            destination$iv$iv2.add(element$iv$iv3);
        }
        List possibleResults = (List)destination$iv$iv2;
        switch (possibleResults.size()) {
            case 0: {
                pluginCreator = PluginCreator.Companion.createInvalidPlugin($this$with.getLibDirectoryParent(), $this$with.getDescriptorPath(), (PluginProblem)new PluginDescriptorIsNotFound($this$with.getDescriptorPath()));
                break;
            }
            case 1: {
                pluginCreator = this.withResolvedClasspath((IdePluginManager.CreationResult)possibleResults.get(0)).getCreator();
                break;
            }
            default: {
                PluginCreator first = ((IdePluginManager.CreationResult)possibleResults.get(0)).getCreator();
                PluginCreator second = ((IdePluginManager.CreationResult)possibleResults.get(1)).getCreator();
                PluginProblem multipleDescriptorsProblem = (PluginProblem)new MultiplePluginDescriptors(first.getDescriptorPath(), first.getPluginFileName(), second.getDescriptorPath(), second.getPluginFileName());
                pluginCreator = PluginCreator.Companion.createInvalidPlugin($this$with.getLibDirectoryParent(), $this$with.getDescriptorPath(), multipleDescriptorsProblem);
            }
        }
        return pluginCreator;
    }

    private final IdePluginManager.CreationResult withResolvedClasspath(IdePluginManager.CreationResult $this$withResolvedClasspath) {
        IdePluginManager.CreationResult creationResult;
        IdePluginManager.CreationResult $this$apply = creationResult = $this$withResolvedClasspath;
        boolean bl = false;
        ContentModules contentModules = this.contentModuleScanner.getContentModules($this$apply.getArtifact());
        Classpath classpath = contentModules.asClasspath();
        $this$apply.getCreator().setClasspath(classpath.getUnique());
        return creationResult;
    }

    private final boolean hasOnlyInvalidDescriptorErrors(PluginCreator creator) {
        boolean bl;
        block7: {
            PluginCreationResult<IdePlugin> pluginCreationResult = creator.getPluginCreationResult();
            if (pluginCreationResult instanceof PluginCreationSuccess) {
                bl = false;
            } else if (pluginCreationResult instanceof PluginCreationFail) {
                List errorsAndWarnings = ((PluginCreationFail)pluginCreationResult).getErrorsAndWarnings();
                Iterable $this$all$iv = errorsAndWarnings;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        PluginProblem it = (PluginProblem)element$iv;
                        boolean bl2 = false;
                        if (it.getLevel() != PluginProblem.Level.ERROR || PluginProblemsKt.isInvalidDescriptorProblem((PluginProblem)it)) continue;
                        bl = false;
                        break block7;
                    }
                    bl = true;
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public LibDirectoryPluginLoader(@NotNull PluginLoaderProvider pluginLoaderRegistry, @NotNull JarFileSystemProvider fileSystemProvider) {
        Intrinsics.checkNotNullParameter((Object)pluginLoaderRegistry, (String)"pluginLoaderRegistry");
        Intrinsics.checkNotNullParameter((Object)fileSystemProvider, (String)"fileSystemProvider");
        this.pluginLoaderRegistry = pluginLoaderRegistry;
        this.fileSystemProvider = fileSystemProvider;
        this.contentModuleScanner = new ContentModuleScanner(this.fileSystemProvider);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0007H\u00c6\u0003J\t\u0010 \u001a\u00020\tH\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\t\u0010\"\u001a\u00020\rH\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003JQ\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010%\u001a\u00020\u00072\b\u0010&\u001a\u0004\u0018\u00010'H\u00d6\u0003J\t\u0010(\u001a\u00020)H\u00d6\u0001J\t\u0010*\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013\u00a8\u0006+"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/LibDirectoryPluginLoader$Context;", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginLoadingContext;", "libDirectoryParent", "Ljava/nio/file/Path;", "descriptorPath", "", "validateDescriptor", "", "resourceResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "parentPlugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;", "problemResolver", "Lcom/jetbrains/plugin/structure/intellij/problems/PluginCreationResultResolver;", "hasDotNetDirectory", "(Ljava/nio/file/Path;Ljava/lang/String;ZLcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;Lcom/jetbrains/plugin/structure/intellij/problems/PluginCreationResultResolver;Z)V", "getDescriptorPath", "()Ljava/lang/String;", "getHasDotNetDirectory", "()Z", "getLibDirectoryParent", "()Ljava/nio/file/Path;", "getParentPlugin", "()Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;", "getProblemResolver", "()Lcom/jetbrains/plugin/structure/intellij/problems/PluginCreationResultResolver;", "getResourceResolver", "()Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "getValidateDescriptor", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "", "hashCode", "", "toString", "structure-intellij"})
    public static final class Context
    extends PluginLoadingContext {
        @NotNull
        private final Path libDirectoryParent;
        @NotNull
        private final String descriptorPath;
        private final boolean validateDescriptor;
        @NotNull
        private final ResourceResolver resourceResolver;
        @Nullable
        private final PluginCreator parentPlugin;
        @NotNull
        private final PluginCreationResultResolver problemResolver;
        private final boolean hasDotNetDirectory;

        @NotNull
        public final Path getLibDirectoryParent() {
            return this.libDirectoryParent;
        }

        @NotNull
        public final String getDescriptorPath() {
            return this.descriptorPath;
        }

        public final boolean getValidateDescriptor() {
            return this.validateDescriptor;
        }

        @Override
        @NotNull
        public ResourceResolver getResourceResolver() {
            return this.resourceResolver;
        }

        @Nullable
        public final PluginCreator getParentPlugin() {
            return this.parentPlugin;
        }

        @Override
        @NotNull
        public PluginCreationResultResolver getProblemResolver() {
            return this.problemResolver;
        }

        public final boolean getHasDotNetDirectory() {
            return this.hasDotNetDirectory;
        }

        public Context(@NotNull Path libDirectoryParent, @NotNull String descriptorPath, boolean validateDescriptor, @NotNull ResourceResolver resourceResolver, @Nullable PluginCreator parentPlugin, @NotNull PluginCreationResultResolver problemResolver, boolean hasDotNetDirectory) {
            Intrinsics.checkNotNullParameter((Object)libDirectoryParent, (String)"libDirectoryParent");
            Intrinsics.checkNotNullParameter((Object)descriptorPath, (String)"descriptorPath");
            Intrinsics.checkNotNullParameter((Object)resourceResolver, (String)"resourceResolver");
            Intrinsics.checkNotNullParameter((Object)problemResolver, (String)"problemResolver");
            super(resourceResolver, problemResolver);
            this.libDirectoryParent = libDirectoryParent;
            this.descriptorPath = descriptorPath;
            this.validateDescriptor = validateDescriptor;
            this.resourceResolver = resourceResolver;
            this.parentPlugin = parentPlugin;
            this.problemResolver = problemResolver;
            this.hasDotNetDirectory = hasDotNetDirectory;
        }

        public /* synthetic */ Context(Path path, String string, boolean bl, ResourceResolver resourceResolver, PluginCreator pluginCreator, PluginCreationResultResolver pluginCreationResultResolver, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x40) != 0) {
                bl2 = false;
            }
            this(path, string, bl, resourceResolver, pluginCreator, pluginCreationResultResolver, bl2);
        }

        @NotNull
        public final Path component1() {
            return this.libDirectoryParent;
        }

        @NotNull
        public final String component2() {
            return this.descriptorPath;
        }

        public final boolean component3() {
            return this.validateDescriptor;
        }

        @NotNull
        public final ResourceResolver component4() {
            return this.getResourceResolver();
        }

        @Nullable
        public final PluginCreator component5() {
            return this.parentPlugin;
        }

        @NotNull
        public final PluginCreationResultResolver component6() {
            return this.getProblemResolver();
        }

        public final boolean component7() {
            return this.hasDotNetDirectory;
        }

        @NotNull
        public final Context copy(@NotNull Path libDirectoryParent, @NotNull String descriptorPath, boolean validateDescriptor, @NotNull ResourceResolver resourceResolver, @Nullable PluginCreator parentPlugin, @NotNull PluginCreationResultResolver problemResolver, boolean hasDotNetDirectory) {
            Intrinsics.checkNotNullParameter((Object)libDirectoryParent, (String)"libDirectoryParent");
            Intrinsics.checkNotNullParameter((Object)descriptorPath, (String)"descriptorPath");
            Intrinsics.checkNotNullParameter((Object)resourceResolver, (String)"resourceResolver");
            Intrinsics.checkNotNullParameter((Object)problemResolver, (String)"problemResolver");
            return new Context(libDirectoryParent, descriptorPath, validateDescriptor, resourceResolver, parentPlugin, problemResolver, hasDotNetDirectory);
        }

        public static /* synthetic */ Context copy$default(Context context, Path path, String string, boolean bl, ResourceResolver resourceResolver, PluginCreator pluginCreator, PluginCreationResultResolver pluginCreationResultResolver, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                path = context.libDirectoryParent;
            }
            if ((n & 2) != 0) {
                string = context.descriptorPath;
            }
            if ((n & 4) != 0) {
                bl = context.validateDescriptor;
            }
            if ((n & 8) != 0) {
                resourceResolver = context.getResourceResolver();
            }
            if ((n & 0x10) != 0) {
                pluginCreator = context.parentPlugin;
            }
            if ((n & 0x20) != 0) {
                pluginCreationResultResolver = context.getProblemResolver();
            }
            if ((n & 0x40) != 0) {
                bl2 = context.hasDotNetDirectory;
            }
            return context.copy(path, string, bl, resourceResolver, pluginCreator, pluginCreationResultResolver, bl2);
        }

        @NotNull
        public String toString() {
            return "Context(libDirectoryParent=" + this.libDirectoryParent + ", descriptorPath=" + this.descriptorPath + ", validateDescriptor=" + this.validateDescriptor + ", resourceResolver=" + this.getResourceResolver() + ", parentPlugin=" + this.parentPlugin + ", problemResolver=" + this.getProblemResolver() + ", hasDotNetDirectory=" + this.hasDotNetDirectory + ")";
        }

        public int hashCode() {
            Path path = this.libDirectoryParent;
            String string = this.descriptorPath;
            int n = ((path != null ? ((Object)path).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31;
            int n2 = this.validateDescriptor ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            ResourceResolver resourceResolver = this.getResourceResolver();
            PluginCreator pluginCreator = this.parentPlugin;
            PluginCreationResultResolver pluginCreationResultResolver = this.getProblemResolver();
            int n3 = ((((n + n2) * 31 + (resourceResolver != null ? resourceResolver.hashCode() : 0)) * 31 + (pluginCreator != null ? pluginCreator.hashCode() : 0)) * 31 + (pluginCreationResultResolver != null ? pluginCreationResultResolver.hashCode() : 0)) * 31;
            int n4 = this.hasDotNetDirectory ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            return n3 + n4;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Context)) break block3;
                    Context context = (Context)object;
                    if (!Intrinsics.areEqual((Object)this.libDirectoryParent, (Object)context.libDirectoryParent) || !Intrinsics.areEqual((Object)this.descriptorPath, (Object)context.descriptorPath) || this.validateDescriptor != context.validateDescriptor || !Intrinsics.areEqual((Object)this.getResourceResolver(), (Object)context.getResourceResolver()) || !Intrinsics.areEqual((Object)this.parentPlugin, (Object)context.parentPlugin) || !Intrinsics.areEqual((Object)this.getProblemResolver(), (Object)context.getProblemResolver()) || this.hasDotNetDirectory != context.hasDotNetDirectory) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

